/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.hyphenate.util.EMLog;

@SuppressLint(value={"MissingPermission"})
public class NetUtils {
    private static final String TAG = "net";
    private static final int LOW_SPEED_UPLOAD_BUF_SIZE = 1024;
    private static final int HIGH_SPEED_UPLOAD_BUF_SIZE = 10240;
    private static final int MAX_SPEED_UPLOAD_BUF_SIZE = 102400;
    private static final int LOW_SPEED_DOWNLOAD_BUF_SIZE = 2024;
    private static final int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int MAX_SPEED_DOWNLOAD_BUF_SIZE = 102400;

    public static boolean hasNetwork(Context context) {
        if (context != null) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isAvailable();
            }
            return false;
        }
        return false;
    }

    public static Types getNetworkTypes(Context context) {
        Types types = Types.NONE;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                if (networkCapabilities != null) {
                    boolean bl = networkCapabilities.hasTransport(0);
                    boolean bl2 = networkCapabilities.hasTransport(1);
                    boolean bl3 = networkCapabilities.hasTransport(2);
                    boolean bl4 = networkCapabilities.hasTransport(3);
                    boolean bl5 = networkCapabilities.hasTransport(4);
                    if (bl) {
                        types = Types.MOBILE;
                    } else if (bl2) {
                        types = Types.WIFI;
                    } else if (bl4) {
                        types = Types.ETHERNET;
                    } else if (bl3 || bl5) {
                        types = Types.OTHERS;
                    }
                }
                EMLog.i(TAG, "Network info: " + (Object)((Object)types));
            } else {
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                EMLog.i(TAG, "Active Network info: " + (networkInfo == null ? "null" : networkInfo.toString()));
                if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                    int n = networkInfo.getType();
                    if (n == 1) {
                        types = Types.WIFI;
                    } else if (n == 0) {
                        types = Types.MOBILE;
                    } else if (n == 9) {
                        types = Types.ETHERNET;
                    } else if (n == 7 || n == 17) {
                        types = Types.OTHERS;
                    }
                }
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
        }
        return types;
    }

    @TargetApi(value=13)
    public static boolean hasDataConnection(Context context) {
        return NetUtils.getNetworkTypes(context) != Types.NONE;
    }

    @Deprecated
    public static boolean isWifiConnection(Context context) {
        return NetUtils.isWifiConnected(context);
    }

    public static boolean isWifiConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                if (networkCapabilities == null) {
                    return false;
                }
                return networkCapabilities.hasTransport(1);
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
            return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            return false;
        }
    }

    @Deprecated
    public static boolean isMobileConnection(Context context) {
        return NetUtils.isMobileConnected(context);
    }

    public static boolean isMobileConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                return networkCapabilities != null && networkCapabilities.hasTransport(0);
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(0);
            return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            return false;
        }
    }

    @Deprecated
    public static boolean isEthernetConnection(Context context) {
        return NetUtils.isEthernetConnected(context);
    }

    public static boolean isEthernetConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                return networkCapabilities != null && networkCapabilities.hasTransport(0);
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(9);
            return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            return false;
        }
    }

    public static boolean isOthersConnected(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = connectivityManager.getActiveNetwork();
                NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(network);
                if (networkCapabilities == null) {
                    return false;
                }
                boolean bl = networkCapabilities.hasTransport(2);
                boolean bl2 = networkCapabilities.hasTransport(4);
                return bl || bl2;
            }
            NetworkInfo networkInfo = connectivityManager.getNetworkInfo(7);
            NetworkInfo networkInfo2 = null;
            if (Build.VERSION.SDK_INT >= 21) {
                networkInfo2 = connectivityManager.getNetworkInfo(17);
            }
            return networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected() || networkInfo2 != null && networkInfo2.isAvailable() && networkInfo2.isConnected();
        }
        catch (Exception exception) {
            EMLog.e(TAG, exception.getMessage());
            return false;
        }
    }

    public static String getWiFiSSID(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        String string = "";
        try {
            WifiInfo wifiInfo = wifiManager.getConnectionInfo();
            string = wifiInfo.getSSID();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static int getUploadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (networkInfo != null && networkInfo.getType() == 9) {
            return 102400;
        }
        if (networkInfo != null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 10240;
        }
        return 1024;
    }

    public static int getDownloadBufSize(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.getType() == 1) {
            return 102400;
        }
        if (Build.VERSION.SDK_INT >= 13 && networkInfo != null && networkInfo.getType() == 9) {
            return 102400;
        }
        if (networkInfo != null && NetUtils.isConnectionFast(networkInfo.getType(), networkInfo.getSubtype())) {
            return 30720;
        }
        return 2024;
    }

    private static boolean isConnectionFast(int n, int n2) {
        if (n == 1) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 13 && n == 9) {
            return true;
        }
        if (n == 0) {
            switch (n2) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
            }
            if (Build.VERSION.SDK_INT >= 11 && (n2 == 14 || n2 == 13)) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 9 && n2 == 12) {
                return true;
            }
            if (Build.VERSION.SDK_INT >= 8 && n2 == 11) {
                return false;
            }
        }
        return false;
    }

    public static String getNetworkType(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            int n = networkInfo.getType();
            if (Build.VERSION.SDK_INT >= 13 && n == 9) {
                return "ETHERNET";
            }
            if (n == 1) {
                return "WIFI";
            }
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            switch (telephonyManager.getNetworkType()) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
            }
            return "unkonw network";
        }
        return "no network";
    }

    public static enum Types {
        NONE,
        WIFI,
        MOBILE,
        ETHERNET,
        OTHERS;

    }
}

