/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Point;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.superrtc.util.BitmapUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@TargetApi(value=21)
public class ScreenCaptureManager {
    public final String TAG = this.getClass().getSimpleName();
    public static final int RECORD_REQUEST_CODE = 1000;
    private static ScreenCaptureManager instance;
    private Activity activity;
    private ScreenCaptureCallback screenCaptureCallback;
    public State state = State.IDLE;
    private MediaProjectionManager projectionManager;
    private MediaProjection mediaProjection;
    private VirtualDisplay virtualDisplay;
    private ImageReader imageReader;
    private Display screenDisplay;
    private WindowManager windowManager;
    private int screenHeight;
    private long oldTime = 0L;
    private int fps = 5;

    private ScreenCaptureManager() {
    }

    public static ScreenCaptureManager getInstance() {
        if (instance == null) {
            instance = new ScreenCaptureManager();
        }
        return instance;
    }

    public void init(Activity activity) {
        this.activity = activity;
        this.projectionManager = (MediaProjectionManager)activity.getSystemService("media_projection");
        if (this.projectionManager != null && this.state == State.IDLE) {
            activity.startActivityForResult(this.projectionManager.createScreenCaptureIntent(), 1000);
            this.state = State.RUNNING;
            Log.d((String)this.TAG, (String)"Init capture screen success!");
        }
        this.windowManager = (WindowManager)activity.getSystemService("window");
        Point point = new Point();
        this.windowManager.getDefaultDisplay().getRealSize(point);
        this.screenHeight = point.y;
    }

    public void stop() {
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
        }
        this.state = State.IDLE;
        this.activity = null;
    }

    public void start(int n, Intent intent) {
        if (this.projectionManager != null) {
            this.mediaProjection = this.projectionManager.getMediaProjection(n, intent);
            if (this.mediaProjection != null) {
                this.initVirtualDisplay();
                this.mediaProjection.registerCallback((MediaProjection.Callback)new MediaProjectionStopCallback(), null);
            }
            Log.d((String)this.TAG, (String)"Capture screen start success!");
        } else {
            Log.d((String)this.TAG, (String)"Capture screen start failed! ProjectionManager is null");
        }
    }

    private void initVirtualDisplay() {
        DisplayMetrics displayMetrics = this.activity.getResources().getDisplayMetrics();
        int n = displayMetrics.densityDpi;
        this.screenDisplay = this.activity.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        this.screenDisplay.getSize(point);
        int n2 = point.x;
        int n3 = point.y;
        this.imageReader = ImageReader.newInstance((int)n2, (int)n3, (int)1, (int)1);
        this.imageReader.setOnImageAvailableListener((ImageReader.OnImageAvailableListener)new ImageAvailableListener(), null);
        String string = "Screenshot";
        int n4 = 9;
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay(string, n2, n3, n, n4, this.imageReader.getSurface(), null, null);
    }

    public void setFps(int n) {
        this.fps = n;
    }

    public void setScreenCaptureCallback(ScreenCaptureCallback screenCaptureCallback) {
        this.screenCaptureCallback = screenCaptureCallback;
    }

    public static enum State {
        IDLE,
        RUNNING;

    }

    public static interface ScreenCaptureCallback {
        public void onBitmap(Bitmap var1);
    }

    private class MediaProjectionStopCallback
    extends MediaProjection.Callback {
        private MediaProjectionStopCallback() {
        }

        public void onStop() {
            if (ScreenCaptureManager.this.virtualDisplay != null) {
                ScreenCaptureManager.this.virtualDisplay.release();
            }
            if (ScreenCaptureManager.this.imageReader != null) {
                ScreenCaptureManager.this.imageReader.setOnImageAvailableListener(null, null);
            }
            ScreenCaptureManager.this.mediaProjection.unregisterCallback((MediaProjection.Callback)this);
            ScreenCaptureManager.this.state = State.IDLE;
        }
    }

    private class ImageAvailableListener
    implements ImageReader.OnImageAvailableListener {
        private ImageAvailableListener() {
        }

        public void onImageAvailable(ImageReader imageReader) {
            Image image = imageReader.acquireNextImage();
            long l = System.currentTimeMillis();
            if (l - ScreenCaptureManager.this.oldTime > (long)(1000 / ScreenCaptureManager.this.fps)) {
                Log.d((String)"lzan13", (String)"capture next");
                Bitmap bitmap = null;
                if (image != null) {
                    ScreenCaptureManager.this.oldTime = l;
                    Image.Plane[] planeArray = image.getPlanes();
                    ByteBuffer byteBuffer = planeArray[0].getBuffer();
                    int n = image.getWidth();
                    int n2 = image.getHeight();
                    int n3 = planeArray[0].getPixelStride();
                    int n4 = planeArray[0].getRowStride();
                    int n5 = (n4 - n3 * n) / n3;
                    bitmap = Bitmap.createBitmap((int)(n + n5), (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
                    Matrix matrix = new Matrix();
                    float f2 = 1.0f / BitmapUtil.getZoomScale(n, n2, 800);
                    matrix.postScale(f2, f2);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix, (boolean)true);
                    if (n2 < ScreenCaptureManager.this.screenHeight) {
                        int n6 = bitmap.getWidth();
                        int n7 = bitmap.getHeight();
                        float f3 = (float)n2 / (float)ScreenCaptureManager.this.screenHeight;
                        int n8 = (int)((float)n6 * f3);
                        int n9 = (n6 - n8) / 2;
                        int[] nArray = new int[n6 * n7];
                        bitmap.getPixels(nArray, 0, n6, 0, 0, n6, n7);
                        int[] nArray2 = new int[n8 * n7];
                        for (int k = 0; k < n7; ++k) {
                            System.arraycopy(nArray, k * n6 + n9, nArray2, k * n8, n8);
                        }
                        bitmap = Bitmap.createBitmap((int[])nArray2, (int)0, (int)n8, (int)n8, (int)n7, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Log.i((String)"SRManager", (String)("onImageAvailable: bitmap2 " + bitmap.getWidth() + " x " + bitmap.getHeight()));
                    }
                    if (ScreenCaptureManager.this.screenCaptureCallback != null) {
                        ScreenCaptureManager.this.screenCaptureCallback.onBitmap(bitmap);
                    }
                }
            }
            if (image != null) {
                image.close();
            }
        }
    }
}

