/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.FeatureInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import com.superrtc.call.Logging;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaSessionInvoker;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.mediamanager.EMediaTalker;
import com.superrtc.mediamanager.RTCNetworkReceiver;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.mediamanager.SRWebSocketExt;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.RtcListener;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class EMediaManager {
    private static final String TAG = "EMediaManager";
    private static LooperExecutor executor;
    private static boolean isInit;
    private EMediaSession.EMediaSessionDelegate sessiondelegate;
    private String sessionticket;
    private static boolean iscreatemediamanager;
    public static EMediaManager instance;
    private ManagerData mgrData;
    private JSONObject ticketDict;
    private EMediaSession session;
    EMediaSessionInvoker invoker;
    static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    static long idnum;
    private boolean isMute;
    private Timer timer;
    private SRWebSocketExt websockext;
    private static Context applicationContext;
    private AtomicBoolean isInputNext = new AtomicBoolean(true);
    private List<Long> fpsList = new ArrayList<Long>();
    private static final String INVOKE_OP_CONN_OPEN = "connOpened";
    private static final String INVOKE_OP_CONN_FAIL = "connFail";
    private static final String INVOKE_OP_CONN_CLOSE = "connClosed";
    private static final String INVOKE_OP_TIMER = "timerCheck";
    private static final String INVOKE_OP_TRYTKT = "tryTicket";
    private static final String INVOKE_OP_EXITTKT = "exitTicket";
    private static final String INVOKE_OP_SUBSR = "subscribe";
    private static final String INVOKE_OP_USUBSR = "unsubscribe";
    private static final String INVOKE_OP_UP_SUBSR = "upsubscribe";
    private static final String INVOKE_OP_RTC_SETSDP = "setLocalSDP";
    private static final String INVOKE_OP_RTC_SETCAND = "setLocalCand";
    private static final String INVOKE_OP_RTC_CAND_DONE = "candDone";
    private static final String INVOKE_OP_RTC_SETUP = "rtcSetup";
    private static final String INVOKE_OP_RTC_RECONN = "rtcReconn";
    private static final String INVOKE_OP_RTC_DISCONN = "rtcDisconn";
    private static final String INVOKE_OP_RTC_CLOSED = "rtcClosed";
    private static final String INVOKE_OP_RTC_ERROR = "rtcError";
    private static final String INVOKE_OP_RTC_UPDATE = "rtcUpd";
    private static final String INVOKE_OP_RTC_STATIS = "rtcStatis";
    private static final String INVOKE_OP_PUBLISH = "publish";
    private static final String INVOKE_OP_UNPUBLISH = "unpublish";
    private static final String INVOKE_OP_CAMERACTRL = "cameraCtrl";
    private static final String INVOKE_OP_NETCHANGED = "netChanged";
    private static final String INVOKE_OP_ERR_DESC = "errDesc";
    private static final String INVOKE_OP_SEND_CUMSTOM = "sendCustom";
    private static final String INVOKE_OP_SEND_RCTRL = "sendRCtrl";
    private static final String INVOKE_OP_ENABLE_XEST = "enableXest";
    private static final String INVOKE_OP_ENABLE_SUB_AUDIOMIX = "enableSubsrAudioMix";
    private static final int XSESSION_EVENT_OPEN_CONN = 1002;
    private static final int XSESSION_EVENT_ENTER = 1004;
    private static final int XSESSION_EVENT_PASSIVE_EXIT = 1005;
    private static final int XSESSION_EVENT_CLOSE_CONN = 1008;
    private static final int XSESSION_EVENT_CALLING = 1010;
    private static final int XSESSION_EVENT_RINGING = 1012;
    private static final int XSESSION_EVENT_MEMBER_JOIN = 1020;
    private static final int XSESSION_EVENT_MEMBER_EXIT = 1022;
    private static final int XSESSION_EVENT_STREAM_PUB = 1030;
    private static final int XSESSION_EVENT_STREAM_UNPUB = 1032;
    private static final int XSESSION_EVENT_STREAM_UPDATE = 1034;
    private static final int XSESSION_EVENT_OPEN_RTC = 1040;
    private static final int XSESSION_EVENT_SET_RTC_CFG = 1041;
    private static final int XSESSION_EVENT_CLOSE_RTC = 1042;
    private static final int XSESSION_EVENT_SET_MYRTC_MIC = 1043;
    private static final int XSESSION_EVENT_SET_MYRTC = 1044;
    private static final int XSESSION_EVENT_SUBSR = 1046;
    private static final int XSESSION_EVENT_UNSUBSR = 1047;
    private static final int XSESSION_EVENT_PUB_UPDATE = 1048;
    private static final int XSESSION_EVENT_UNPUB = 1049;
    private static final int XSESSION_EVENT_CREATE_OFFER = 1050;
    private static final int XSESSION_EVENT_CREATE_ANSWER = 1051;
    private static final int XSESSION_EVENT_REMOTE_SDP = 1053;
    private static final int XSESSION_EVENT_REMOTE_CAND = 1054;
    private static final int XSESSION_EVENT_CAMERACTRL = 1056;
    private static final int XSESSION_EVENT_NOTIFY = 1058;
    private static final int XSESSION_EVENT_UPDATE_ROLE = 1059;
    private static int cameraId;
    private boolean isUnpub = false;
    private int unpubCameraId = -1;
    private String specificUrl;
    private String specificCandIP;
    private JSONObject configObject = new JSONObject();
    private RtcConnection.Listener rtclistener = new RtcConnection.Listener(){

        @Override
        public void onLocalSdp(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetLocalSdp")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("sdp", (Object)string);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETSDP);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onLocalCandidate(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetLocalCandidate")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("cand", (Object)string);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETCAND);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onConnected(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didReconnect")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_RECONN);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onConnectionsetup(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didSetup")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETUP);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onDisconnected(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didDisconnect")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_DISCONN);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onCandidateCompleted(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didLocalCandidateComplete")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CAND_DONE);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onClosed(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didClose")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CLOSED);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onStats(final RtcConnection rtcConnection, final RtcConnection.RtcStatistics rtcStatistics) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetStats")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_STATIS);
                        jSONObject.put("conntype", (Object)rtcStatistics.connectionType);
                        jSONObject.put("rtt", rtcStatistics.localVideoRtt);
                        jSONObject.put("llostratev", rtcStatistics.localVideoPacketsLostrate);
                        jSONObject.put("llostratea", rtcStatistics.localAudioPacketsLostrate);
                        jSONObject.put("rlostratev", rtcStatistics.remoteVideoPacketsLostrate);
                        jSONObject.put("rlostratea", rtcStatistics.remoteAudioPacketsLostrate);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (rtcConnection != null) {
                        // empty if block
                    }
                    RtcConnectionExt rtcConnectionExt = (RtcConnectionExt)rtcConnection;
                    if (rtcConnectionExt.ownConn != null && rtcConnectionExt.ownConn.enableStati) {
                        if (!TextUtils.isEmpty((CharSequence)rtcConnection.streamId)) {
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_STATS, rtcConnection.name, rtcConnection.streamId, rtcStatistics, rtcConnectionExt.ownConn);
                        } else if (!TextUtils.isEmpty((CharSequence)rtcConnection.pubStreamId)) {
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_STATS, rtcConnection.name, rtcConnection.pubStreamId, rtcStatistics, rtcConnectionExt.ownConn);
                        }
                    }
                }
            });
        }

        @Override
        public void onError(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didError")) {
                        return;
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "rtc error: [" + rtcConnection.name + "]->[" + string + "]");
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_ERROR);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }
    };
    private SRWebSocketExt.SRWebSocketDelegate sockdelegate = new SRWebSocketExt.SRWebSocketDelegate(){

        @Override
        public void invokeConnWithWebsocket(final SRWebSocketExt sRWebSocketExt, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession eMediaSession = EMediaManager.this.checkExistSameWebsocket(sRWebSocketExt, string);
                    if (eMediaSession == null) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "non-exist session [" + sRWebSocketExt.name + "] for op [" + string + "]");
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("connId", (Object)eMediaSession.instanceId);
                        jSONObject.put("op", (Object)string);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (n != 0) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "invokeConnWithWebsocket : fail with " + n);
                    }
                }
            });
        }

        @Override
        public void webSocketDidOpen(SRWebSocketExt sRWebSocketExt) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: webSocketDidOpen " + sRWebSocketExt.name);
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_OPEN);
        }

        @Override
        public void didReceiveMessageWithString(final SRWebSocketExt sRWebSocketExt, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession eMediaSession = EMediaManager.this.checkExistSameWebsocket(sRWebSocketExt, "recvString");
                    if (eMediaSession == null) {
                        return;
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.jsonrecvstring(eMediaSession.instanceId, string);
                }
            });
        }

        @Override
        public void didReceiveMessageWithData(SRWebSocketExt sRWebSocketExt, byte[] byArray) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didReceiveMessageWithData");
        }

        @Override
        public void didFailWithError(SRWebSocketExt sRWebSocketExt, Exception exception) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "webSocket: didFailWithError, " + exception);
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_FAIL);
        }

        @Override
        public void didCloseWithCode(SRWebSocketExt sRWebSocketExt, int n, String string, boolean bl) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didCloseWithCode, code=[" + n + "], reason=[" + string + "], wasClean=[" + bl + "]");
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_CLOSE);
        }

        @Override
        public void didReceivePong(SRWebSocketExt sRWebSocketExt, byte[] byArray) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "WebSocket received pong, " + byArray);
        }
    };
    private XClientBridger.XClientBridgerDelegate xdelegate = new XClientBridger.XClientBridgerDelegate(){

        @Override
        public int onJsonSendWithConn(String string, String string2) {
            EMediaSession eMediaSession = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(string);
            eMediaSession.websocket.send(string2);
            return 0;
        }

        public EMediaDefines.EMediaStreamType wrapStreamType(int n) {
            for (EMediaDefines.EMediaStreamType eMediaStreamType : EMediaDefines.EMediaStreamType.values()) {
                if (eMediaStreamType.val != n) continue;
                return eMediaStreamType;
            }
            throw new RuntimeException("Json str. error on = " + n);
        }

        @Override
        public JSONObject onJsonCallback(JSONObject jSONObject) throws JSONException, URISyntaxException {
            int n = 0;
            JSONObject jSONObject2 = new JSONObject();
            String string = jSONObject.optString("op");
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "onJsonCallback dict::" + jSONObject.toString());
            if (string.equals("onEvent")) {
                long l = jSONObject.optInt("event");
                String string2 = jSONObject.optString("connId");
                final EMediaSession eMediaSession = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(string2);
                if (eMediaSession == null) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "onEvent: can't find conn [" + string2 + "]");
                } else {
                    logcallback.onLog(logLevel.LS_INFO.ordinal(), "onEvent: connId=[" + string2 + "] event=[" + l + "]");
                    String string3 = null;
                    if (jSONObject.has("argStr")) {
                        string3 = jSONObject.getString("argStr");
                    }
                    int n2 = 0;
                    if (jSONObject.has("argInt")) {
                        n2 = jSONObject.getInt("argInt");
                    }
                    if (l == 1002L) {
                        String string4 = string3;
                        if (EMediaManager.this.specificUrl != null) {
                            string4 = EMediaManager.this.specificUrl;
                        }
                        boolean bl = false;
                        if (eMediaSession.websocket != null) {
                            eMediaSession.websocket.close();
                            eMediaSession.websocket = null;
                            bl = true;
                        }
                        EMediaManager.this.websockext = new SRWebSocketExt(string4, EMediaManager.this.sockdelegate, eMediaSession.instanceId);
                        eMediaSession.websocket = EMediaManager.this.websockext;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + eMediaSession.instanceId + "] -> [" + eMediaSession.websocket.url + "]");
                        eMediaSession.websocket.open();
                        if (bl) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopening websocket [" + eMediaSession.instanceId + "][" + eMediaSession.websocket + "] -> [" + string4 + "%@]");
                        } else {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + eMediaSession.instanceId + "][" + eMediaSession.websocket + "] -> [" + string4 + "%@]");
                        }
                    } else if (l == 1040L) {
                        String string5 = string3;
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string5);
                        boolean bl = false;
                        VideoViewRenderer videoViewRenderer = null;
                        VideoViewRenderer videoViewRenderer2 = null;
                        View view = null;
                        if (rtcConnectionExt != null) {
                            videoViewRenderer = rtcConnectionExt.localViewRender;
                            videoViewRenderer2 = rtcConnectionExt.remoteViewRender;
                            view = rtcConnectionExt.pubView;
                            rtcConnectionExt.hangup();
                            bl = true;
                        }
                        RtcConnectionExt rtcConnectionExt2 = new RtcConnectionExt(string5);
                        rtcConnectionExt2.ownConn = eMediaSession;
                        rtcConnectionExt2.pubType = -1;
                        rtcConnectionExt2.setListener(EMediaManager.this.rtclistener);
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.put(rtcConnectionExt2.name, rtcConnectionExt2);
                        EMediaManager.this.setRtc(string5, jSONObject);
                        if (bl) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopen rtc " + rtcConnectionExt2.name);
                            if (videoViewRenderer != null && videoViewRenderer2 != null) {
                                rtcConnectionExt2.setViews(videoViewRenderer, videoViewRenderer2);
                            } else if (videoViewRenderer2 != null) {
                                rtcConnectionExt2.setViews(null, videoViewRenderer2);
                            } else if (videoViewRenderer != null) {
                                rtcConnectionExt2.setViews(videoViewRenderer, null);
                            }
                            if (view != null) {
                                rtcConnectionExt2.pubView = view;
                                rtcConnectionExt2.setCaptureFromView(view);
                            }
                            rtcConnectionExt2.streamId = rtcConnectionExt.streamId;
                            rtcConnectionExt2.pubStreamId = rtcConnectionExt.pubStreamId;
                            rtcConnectionExt2.pubType = rtcConnectionExt.pubType;
                            rtcConnectionExt2.csrc = rtcConnectionExt.csrc;
                            for (String string6 : ((EMediaManager)EMediaManager.this).mgrData.subsrDict.keySet()) {
                                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string6);
                                if (eMediaStreamSubscription.rtc != rtcConnectionExt) continue;
                                eMediaStreamSubscription.rtc = rtcConnectionExt2;
                            }
                        } else {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "new rtc " + rtcConnectionExt2.name);
                        }
                    } else if (l == 1044L) {
                        ((EMediaManager)EMediaManager.this).mgrData.myRtcId = string3;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "set myRtcId: " + ((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null) {
                            RtcConnectionExt rtcConnectionExt;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = eMediaSession;
                            if (((EMediaManager)EMediaManager.this).mgrData.localViewRender != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string3)) != null) {
                                rtcConnectionExt.setListener(EMediaManager.this.rtclistener);
                                rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                    } else if (l == 1043L) {
                        ((EMediaManager)EMediaManager.this).mgrData.myMicRtcId = string3;
                    } else if (l == 1041L) {
                        String string7 = string3;
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string7);
                        String string8 = jSONObject.optString("config");
                        if (rtcConnectionExt != null && !TextUtils.isEmpty((CharSequence)string8)) {
                            rtcConnectionExt.setConfigure(string8);
                        }
                        if (rtcConnectionExt != null && EMediaManager.this.configObject != null) {
                            rtcConnectionExt.setConfigure(EMediaManager.this.configObject.toString());
                        }
                    } else if (l == 1050L) {
                        String string9 = string3;
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string9);
                        if (rtcConnectionExt != null) {
                            rtcConnectionExt.createOffer();
                        }
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "creating offer...");
                    } else if (l == 1042L) {
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string3);
                        if (rtcConnectionExt != null) {
                            rtcConnectionExt.hangup();
                        }
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.remove(string3);
                        if (rtcConnectionExt.name.equals(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) {
                            ((EMediaManager)EMediaManager.this).mgrData.myRtcId = null;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                        if (rtcConnectionExt.name.equals(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId)) {
                            ((EMediaManager)EMediaManager.this).mgrData.myMicRtcId = null;
                        }
                    } else if (l == 1008L) {
                        EMediaManager.this.closeSession(eMediaSession);
                    } else if (l == 1053L || l == 1054L) {
                        String string10 = null;
                        if (jSONObject.has("rtcId")) {
                            string10 = jSONObject.getString("rtcId");
                        }
                        String string11 = null;
                        if (jSONObject.has("sdp")) {
                            string11 = jSONObject.getString("sdp");
                        }
                        String string12 = null;
                        if (jSONObject.has("cand")) {
                            string12 = jSONObject.getString("cand");
                        }
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string10);
                        if (string11 != null && rtcConnectionExt != null) {
                            try {
                                rtcConnectionExt.setRemoteJson(string11);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (string12 != null && rtcConnectionExt != null) {
                            if (EMediaManager.this.specificCandIP != null) {
                                String string13 = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
                                string12 = string12.replaceAll(string13, EMediaManager.this.specificCandIP);
                            }
                            try {
                                rtcConnectionExt.setRemoteJson(string12);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else if (l == 1004L) {
                        int n3 = 0;
                        if (n2 != 0) {
                            n3 = n2;
                        }
                        if (n3 == 0) {
                            EMediaManager.this.invoker.invokeBlock(eMediaSession.joinBlock, string3, null, eMediaSession);
                            eMediaSession.role = jSONObject.optInt("role", 0);
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "Session event enter, default role: " + eMediaSession.role);
                        } else {
                            EMediaManager.this.closeSession(eMediaSession);
                            EMediaEntities.EMediaError eMediaError = EMediaManager.this.newErrorWithCode(n3, string3);
                            EMediaManager.this.invoker.invokeBlock(eMediaSession.joinBlock, eMediaSession, eMediaError, eMediaSession);
                        }
                        eMediaSession.joinBlock = null;
                    } else if (l == 1005L) {
                        int n4 = n2;
                        EMediaManager.this.invoker.invokeOnExitConference(n4, string3, eMediaSession);
                    } else if (l == 1020L) {
                        EMediaEntities.EMediaMember eMediaMember = new EMediaEntities.EMediaMember(string3, jSONObject.optString("memId"), jSONObject.optString("ext"));
                        EMediaManager.this.invoker.invokeOnMemberJoin(eMediaMember, eMediaSession);
                    } else if (l == 1022L) {
                        int n5 = 0;
                        if (n2 != 0) {
                            n5 = n2;
                        }
                        EMediaEntities.EMediaMember eMediaMember = new EMediaEntities.EMediaMember(string3, jSONObject.optString("memId"), jSONObject.optString("ext"));
                        EMediaManager.this.invoker.invokeOnMemberExit(eMediaMember, eMediaSession, n5);
                    } else if (l == 1030L || l == 1032L || l == 1034L) {
                        EMediaStream eMediaStream = new EMediaStream(string3, jSONObject.optString("memName"), this.wrapStreamType(jSONObject.optInt("streamType")), jSONObject.optString("streamName"), jSONObject.optInt("voff") != 0, jSONObject.optInt("aoff") != 0, jSONObject.optString("ext"), jSONObject.optInt("csrc"));
                        if (l == 1030L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.put(string3, eMediaStream);
                            if (eMediaStream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.put(eMediaStream.csrc, eMediaStream);
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "add stream csrc " + eMediaStream.csrc + ", streamId " + eMediaStream.streamId + ", memberName " + eMediaStream.memberName);
                            }
                            EMediaManager.this.invoker.invokeOnStreamPublish(eMediaStream, eMediaSession);
                        } else if (l == 1032L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.remove(string3);
                            if (eMediaStream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.remove(eMediaStream.csrc);
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remove stream csrc " + eMediaStream.csrc + ", streamId " + eMediaStream.streamId + ", memberName " + eMediaStream.memberName);
                            }
                            EMediaManager.this.invoker.invokeOnStopStream(eMediaStream, eMediaSession);
                        } else if (l == 1034L) {
                            ((EMediaManager)EMediaManager.this).mgrData.streamDict.put(string3, eMediaStream);
                            EMediaStream eMediaStream2 = ((EMediaManager)EMediaManager.this).mgrData.streamDict.get(string3);
                            if (eMediaStream2 != null && eMediaStream2.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.remove(eMediaStream.csrc);
                            }
                            if (eMediaStream.csrc != 0) {
                                ((EMediaManager)EMediaManager.this).mgrData.csrcDict.put(eMediaStream.csrc, eMediaStream);
                            }
                            EMediaManager.this.invoker.invokeOnUpdateStream(eMediaStream, eMediaSession);
                        }
                    } else if (l == 1046L) {
                        String string14 = string3;
                        String string15 = jSONObject.optString("subsrId");
                        String string16 = jSONObject.optString("streamId");
                        ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.put(string15, string14);
                        if (string14 != null) {
                            RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string14);
                            rtcConnectionExt.setListener(EMediaManager.this.rtclistener);
                            EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string15);
                            if (rtcConnectionExt != null && eMediaStreamSubscription != null) {
                                eMediaStreamSubscription.rtc = rtcConnectionExt;
                                rtcConnectionExt.streamId = string16;
                                rtcConnectionExt.setViews(null, eMediaStreamSubscription.view);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string15);
                        }
                    } else if (l == 1047L) {
                        RtcConnectionExt rtcConnectionExt;
                        String string17 = string3;
                        String string18 = jSONObject.optString("subsrId");
                        if (!TextUtils.isEmpty((CharSequence)string17) && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string17)) != null) {
                            rtcConnectionExt.setViews(null, null);
                        }
                        if (!TextUtils.isEmpty((CharSequence)string18)) {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string18);
                        }
                    } else if (l == 1056L) {
                        String string19 = jSONObject.optString("rtcId");
                        int n6 = jSONObject.optInt("x");
                        int n7 = jSONObject.optInt("y");
                        int n8 = jSONObject.optInt("focus");
                        int n9 = jSONObject.optInt("expo");
                        int n10 = jSONObject.optInt("zoom");
                        int n11 = jSONObject.optInt("pic");
                        int n12 = jSONObject.optInt("frz");
                        int n13 = jSONObject.optInt("tor");
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && string19.endsWith(((EMediaManager)EMediaManager.this).mgrData.myRtcId) && rtcConnectionExt != null) {
                            if (n8 >= 0 || n9 >= 0) {
                                n8 = n8 > 0 ? 1 : 0;
                                n9 = n9 > 0 ? 1 : 0;
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: interestAt x=[" + n6 + "], y=[" + n7 + "], focus=" + n8 + ", expo=" + n9);
                                rtcConnectionExt.interestAt(n6, n7, n8, n9, true);
                            }
                            if (n10 >= 0) {
                                Float f2 = Float.valueOf((float)((double)n10 / 10000.0));
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: zoom factor [" + f2 + "]");
                                rtcConnectionExt.zoomWithFactor(f2);
                            }
                            if (n11 > 0) {
                                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- command --");
                                rtcConnectionExt.takeCameraPicture(new RTCCallback(){

                                    @Override
                                    public void onDone(Object object) {
                                        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- success --" + object);
                                        eMediaSession.delegate.notice(eMediaSession, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_TAKE_CAMERA_PICTURE, null, null, object);
                                    }
                                });
                            }
                            if (n12 >= 0) {
                                // empty if block
                            }
                            if (n13 >= 0) {
                                if (EMediaManager.this.isSupportFlashLight()) {
                                    boolean bl = n13 > 0;
                                    rtcConnectionExt.handleFlashLight(bl);
                                } else {
                                    n = EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_UNKNOWN.errorcode;
                                }
                            }
                        }
                    } else if (l == 1058L) {
                        String string20 = jSONObject.optString("arg2");
                        String string21 = jSONObject.optString("arg3");
                        EMediaManager.this.invoker.invokeOnNotice(EMediaManager.wrapENoticeCode(n2), string3, string20, string21, eMediaSession);
                    } else if (l == 1048L) {
                        String string22 = jSONObject.optString("rtcId");
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string22);
                        String string23 = jSONObject.optString("pubStreamId");
                        if (rtcConnectionExt != null) {
                            rtcConnectionExt.csrc = jSONObject.optInt("csrc");
                            if (TextUtils.isEmpty((CharSequence)rtcConnectionExt.pubStreamId)) {
                                rtcConnectionExt.pubStreamId = string23;
                                EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_UPDATE_PUB, rtcConnectionExt.name, rtcConnectionExt.pubStreamId, null, eMediaSession);
                            }
                        }
                    } else if (l == 1049L) {
                        String string24 = jSONObject.optString("rtcId");
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string24);
                        String string25 = jSONObject.optString("pubStreamId");
                        if (rtcConnectionExt != null && !TextUtils.isEmpty((CharSequence)rtcConnectionExt.pubStreamId) && rtcConnectionExt.pubStreamId.equals(string25)) {
                            rtcConnectionExt.csrc = 0;
                            rtcConnectionExt.pubStreamId = null;
                            EMediaManager.this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_UNPUB, rtcConnectionExt.name, string25, null, eMediaSession);
                        }
                    } else if (l == 1059L) {
                        eMediaSession.role = jSONObject.optInt("role", 0);
                        EMediaManager.this.invoker.invokeOnChangeRole(eMediaSession);
                    }
                }
            }
            jSONObject2.put("op", (Object)"rsp");
            jSONObject2.put("status", n);
            return jSONObject2;
        }
    };
    private static XClientBridger.Logcallbackfunc logcallback;

    public static EMediaDefines.EMediaNoticeCode wrapENoticeCode(int n) {
        for (EMediaDefines.EMediaNoticeCode eMediaNoticeCode : EMediaDefines.EMediaNoticeCode.values()) {
            if (eMediaNoticeCode.noticeCode != n) continue;
            return eMediaNoticeCode;
        }
        throw new RuntimeException("Json str. error on = " + n);
    }

    public void setRtc(String string, JSONObject jSONObject) {
        int n;
        int n2;
        RtcConnectionExt rtcConnectionExt = this.mgrData.rtcDict.get(string);
        if (this.isUnpub) {
            this.isUnpub = false;
            if (this.unpubCameraId != -1) {
                RtcConnectionExt.setCameraFacing(this.unpubCameraId);
            }
        } else {
            RtcConnectionExt.setCameraFacing(cameraId);
        }
        String string2 = null;
        if (jSONObject.has("config")) {
            string2 = jSONObject.optString("config");
        }
        if (string2 != null) {
            rtcConnectionExt.setConfigure(string2);
        }
        int n3 = jSONObject.optInt("voff");
        boolean bl = false;
        if (n3 != 0) {
            bl = true;
            rtcConnectionExt.stopCapture();
        }
        int n4 = jSONObject.optInt("aoff");
        boolean bl2 = false;
        if (n4 != 0) {
            bl2 = true;
            rtcConnectionExt.setMute(bl2);
        }
        if ((n2 = jSONObject.optInt("useBackCamera")) != 0) {
            RtcConnectionExt.setCameraFacing(0);
        }
        rtcConnectionExt.pubType = n = jSONObject.optInt("pubType");
        if (n == EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_DESKTOP.val) {
            Logging.d(TAG, "this is share view Rtc");
            rtcConnectionExt.setEnableExternalVideoData(true);
            this.mgrData.shareRtcId = string;
        }
        int n5 = jSONObject.optInt("maxVKbps");
        try {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put("maxVKbps", n5);
            rtcConnectionExt.setConfigure(jSONObject2.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n6 = jSONObject.optInt("maxAKbps");
        try {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("maxAKbps", n6);
            rtcConnectionExt.setConfigure(jSONObject3.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVideoViews(final String string, final VideoViewRenderer videoViewRenderer, final VideoViewRenderer videoViewRenderer2, final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoViews ,streamId=[" + string + "] ,localview=[" + videoViewRenderer + "] ,remoteview=[" + videoViewRenderer2 + "] ,islocal=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    RtcConnectionExt rtcConnectionExt;
                    ((EMediaManager)EMediaManager.this).mgrData.localViewRender = videoViewRenderer;
                    if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                        rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                    }
                } else {
                    String string3 = EMediaManager.this.getSubcribeId(string);
                    if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string3) != null) {
                        if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get((Object)string3).view != videoViewRenderer2) {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string3);
                            String string2 = ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.get(string3);
                            if (string2 == null) {
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "rtcId is not exit");
                                return;
                            }
                            RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string2);
                            if (rtcConnectionExt != null) {
                                rtcConnectionExt.setViews(null, videoViewRenderer2);
                                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                                eMediaStreamSubscription.subscribeId = string3;
                                eMediaStreamSubscription.view = videoViewRenderer2;
                                ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string3, eMediaStreamSubscription);
                            }
                        }
                    } else {
                        EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                        eMediaStreamSubscription.subscribeId = string3;
                        eMediaStreamSubscription.view = videoViewRenderer2;
                        ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string3, eMediaStreamSubscription);
                    }
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setVideoViews ");
            }
        });
    }

    public void updateVideoMaxKbps(final int n) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ updateVideoMaxKbps=[" + n + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null) {
                    RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                    if (rtcConnectionExt == null) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- updateVideoMaxKbps, rtc == null");
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject();
                        jSONObject.put("maxVKbps", n);
                        rtcConnectionExt.setConfigure(jSONObject.toString());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- updateVideoMaxKbps");
                }
            }
        });
    }

    private String generateString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int k = 0; k < n; ++k) {
            int n2 = Math.round(letters.length() - 1);
            stringBuilder.append(letters.charAt(n2));
        }
        return stringBuilder.toString();
    }

    private String generateRTCId() {
        return "rtc-" + ++idnum + "-" + this.generateString(3);
    }

    public EMediaSession newSessionWithTicket(String string, String string2, EMediaSession.EMediaSessionDelegate eMediaSessionDelegate) throws JSONException {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ newSessionWithTicket ,aTicket=[" + string + "]");
        if (string == null) {
            Log.i((String)TAG, (String)"ticket is null");
        }
        JSONTokener jSONTokener = new JSONTokener(string);
        JSONObject jSONObject = (JSONObject)jSONTokener.nextValue();
        this.session = new EMediaSession(this, string, jSONObject, string2);
        this.session.delegate = eMediaSessionDelegate;
        EMediaSession.delegateQueue = executor;
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- newSessionWithTicket ");
        return this.session;
    }

    public void setSession(final EMediaSession eMediaSession, final String string) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                eMediaSession.nickName = string;
            }
        });
    }

    public static EMediaManager getInstance() {
        if (instance == null) {
            instance = new EMediaManager();
        }
        return instance;
    }

    public static boolean isInit() {
        return isInit;
    }

    public static void initGlobal(Context context) {
        if (isInit) {
            return;
        }
        applicationContext = context;
        executor = new LooperExecutor();
        executor.setPriority(10);
        executor.requestStart();
        try {
            RtcConnection.initGlobal(context, executor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        isInit = true;
        EMediaManager.getInstance();
    }

    public EMediaManager() {
        this.mgrData = new ManagerData();
        this.mgrData.workQueue = executor;
        this.mgrData.bridger = new XClientBridger(this.xdelegate);
        this.mgrData.bridger.setlogfunc(logcallback);
        this.mgrData.myRtcId = null;
        this.invoker = new EMediaSessionInvoker();
        this.setNetworkChangedListener();
        this.setRtcListener();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_ENABLE_XEST);
                    jSONObject.put("code", 1);
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    public void setNetworkChangedListener() {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "Register network change receiver!");
        RTCNetworkReceiver rTCNetworkReceiver = new RTCNetworkReceiver();
        rTCNetworkReceiver.setNetworkListener(new RTCNetworkReceiver.NetworkListener(){

            @Override
            public void onNetworkChanged(int n) {
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "Network changed " + n);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("netStatus", n);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_NETCHANGED);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
            }
        });
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        applicationContext.registerReceiver((BroadcastReceiver)rTCNetworkReceiver, intentFilter);
    }

    public static void setLoggerDelegate(XClientBridger.Logcallbackfunc logcallbackfunc) {
        logcallback = logcallbackfunc;
        RtcConnection.registerLogListener(new RtcConnection.LogListener(){

            @Override
            public void onLog(int n, String string) {
                logcallback.onLog(n, string);
            }
        });
    }

    public void setLocalPreviewView(final VideoViewRenderer videoViewRenderer) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setLocalPreviewView  ,localview=[" + videoViewRenderer + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt;
                ((EMediaManager)EMediaManager.this).mgrData.localViewRender = videoViewRenderer;
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                    rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setLocalPreviewView");
            }
        });
    }

    public void join(final EMediaSession eMediaSession, final EMediaPublishConfiguration eMediaPublishConfiguration, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ join");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, false, "join")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                if (eMediaPublishConfiguration != null) {
                    EMediaManager.this.makePubArg(eMediaSession, EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL, eMediaPublishConfiguration, jSONObject);
                }
                eMediaSession.joinBlock = eMediaIdBlockType;
                ((EMediaManager)EMediaManager.this).mgrData.connDict.put(eMediaSession.instanceId, eMediaSession);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "startTimer");
                EMediaManager.this.startTimer();
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("ticket", (Object)eMediaSession.ticket);
                    if (eMediaSession.extension != null) {
                        jSONObject.put("ext", (Object)eMediaSession.extension);
                    }
                    if (eMediaSession.nickName != null) {
                        jSONObject.put("nickName", (Object)eMediaSession.nickName);
                    }
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_TRYTKT);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- join");
            }
        });
    }

    public void exit(EMediaSession eMediaSession, EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        this.exit(eMediaSession, 0, eMediaIdBlockType);
    }

    public void exit(final EMediaSession eMediaSession, final int n, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ exit");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "exit")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("reason", n);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_EXITTKT);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n2 = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invokeResult(eMediaSession, n2, eMediaSession, eMediaIdBlockType);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- exit");
            }
        });
    }

    String getSubcribeId(String string) {
        return "rtc-" + string;
    }

    private boolean checkExistSession(EMediaSession eMediaSession, EMediaEntities.EMediaIdBlockType eMediaIdBlockType, boolean bl, String string) {
        if (eMediaSession == null) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "null  session , origin=" + string);
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_INVALID_ARG.errorcode, ""), eMediaSession);
            return false;
        }
        EMediaSession eMediaSession2 = this.mgrData.connDict.get(eMediaSession.instanceId);
        if (eMediaSession2 == null && bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NOT join session[" + eMediaSession.instanceId + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SESSION.errorcode, null), eMediaSession);
            return false;
        }
        if (eMediaSession2 != null && !bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already join session[" + eMediaSession.instanceId + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_JOIN.errorcode, null), eMediaSession);
            return false;
        }
        return true;
    }

    private boolean checkExistSubscribe(EMediaSession eMediaSession, EMediaEntities.EMediaIdBlockType eMediaIdBlockType, boolean bl, String string, String string2) {
        EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = this.mgrData.subsrDict.get(string2);
        if (eMediaStreamSubscription != null && !bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already subscribed, session[" + eMediaSession.instanceId + "], streamId[" + string + "], subsrId[" + string2 + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, eMediaSession, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_SUBSCRIBE.errorcode, null), eMediaSession);
            return false;
        }
        if (eMediaStreamSubscription == null && bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NO subscribed, session[" + eMediaSession.instanceId + "], streamId[" + string + "], subsrId[" + string2 + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, eMediaSession, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SUBSCRIBE.errorcode, null), eMediaSession);
            return false;
        }
        return true;
    }

    public static EMediaDefines.EMediaErrorCode wrap(int n) {
        for (EMediaDefines.EMediaErrorCode eMediaErrorCode : EMediaDefines.EMediaErrorCode.values()) {
            if (eMediaErrorCode.errorcode != n) continue;
            return eMediaErrorCode;
        }
        throw new RuntimeException("Json str. error on = " + n);
    }

    private EMediaEntities.EMediaError newErrorWithCode(int n, String string) {
        Object object;
        if (string == null || string.length() == 0) {
            object = new JSONObject();
            try {
                object.put("code", n);
                object.put("op", (Object)INVOKE_OP_ERR_DESC);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            String[] stringArray = new String[1];
            this.mgrData.bridger.invokeWithDict(object.toString(), stringArray);
            JSONTokener jSONTokener = new JSONTokener(stringArray[0]);
            JSONObject jSONObject = null;
            try {
                jSONObject = (JSONObject)jSONTokener.nextValue();
                string = jSONObject.optString("desc");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        object = EMediaEntities.EMediaError.newError(EMediaManager.wrap(n), string);
        return object;
    }

    private boolean invokeResult(EMediaSession eMediaSession, int n, Object object, EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        if (n != 0) {
            EMediaEntities.EMediaError eMediaError = EMediaEntities.EMediaError.newError(EMediaManager.wrap(n), null);
            this.invoker.invokeBlock(eMediaIdBlockType, null, eMediaError, eMediaSession);
            return false;
        }
        this.invoker.invokeBlock(eMediaIdBlockType, object, null, eMediaSession);
        return true;
    }

    private boolean checkExistSameRtc(RtcConnectionExt rtcConnectionExt, String string) {
        RtcConnectionExt rtcConnectionExt2 = this.mgrData.rtcDict.get(rtcConnectionExt.name);
        if (rtcConnectionExt2 == rtcConnectionExt) {
            return true;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same rtc [" + rtcConnectionExt.name + "], origin=[" + string + "%@]");
        return false;
    }

    private EMediaSession checkExistSameWebsocket(SRWebSocketExt sRWebSocketExt, String string) {
        EMediaSession eMediaSession = this.mgrData.connDict.get(sRWebSocketExt.name);
        if (eMediaSession != null && eMediaSession.websocket == sRWebSocketExt) {
            return eMediaSession;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same websocket [" + sRWebSocketExt.name + "], origin=[" + string + "%@]");
        return null;
    }

    public void closeSession(EMediaSession eMediaSession) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi] closeSession");
        this.mgrData.connDict.remove(eMediaSession.instanceId);
        if (eMediaSession.websocket != null) {
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "close websocket [" + eMediaSession.instanceId + "] -> [" + eMediaSession.websocket.url + "]");
            eMediaSession.websocket.close();
            eMediaSession.websocket = null;
        }
        if (eMediaSession == this.mgrData.pubSession) {
            this.mgrData.pubSession = null;
        }
        if (this.mgrData.connDict.size() == 0) {
            this.stopTimer();
        }
    }

    public void makePubArg(EMediaSession eMediaSession, EMediaDefines.EMediaStreamType eMediaStreamType, EMediaPublishConfiguration eMediaPublishConfiguration, JSONObject jSONObject) {
        if (eMediaPublishConfiguration == null) {
            eMediaPublishConfiguration = new EMediaPublishConfiguration();
        }
        try {
            jSONObject.put("pubtype", eMediaStreamType.val);
            jSONObject.put("voff", eMediaPublishConfiguration.videoOff);
            jSONObject.put("aoff", eMediaPublishConfiguration.mute);
            jSONObject.put("useBackCamera", eMediaPublishConfiguration.useBackCamera);
            jSONObject.put("vwidth", eMediaPublishConfiguration.vwidth);
            jSONObject.put("vheight", eMediaPublishConfiguration.vheight);
            jSONObject.put("extVideoSrc", eMediaPublishConfiguration.externalVideoSource);
            jSONObject.put("maxVKbps", eMediaPublishConfiguration.maxVideoKbps);
            jSONObject.put("maxAKbps", eMediaPublishConfiguration.maxAudioKbps);
            if (eMediaPublishConfiguration.extension != null) {
                jSONObject.put("streamExt", (Object)eMediaPublishConfiguration.extension);
            }
            if (eMediaPublishConfiguration.name != null) {
                jSONObject.put("pubname", (Object)eMediaPublishConfiguration.name);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void setInputNext(boolean bl) {
        this.isInputNext.getAndSet(bl);
    }

    public void inputExternalVideoData(final Bitmap bitmap) {
        if (!this.isInputNext.get()) {
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "input external video data -0-, previous input not processed.");
            return;
        }
        this.computeFrameRate();
        this.setInputNext(false);
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "input external video data -0- fps size " + this.fpsList.size());
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.shareRtcId);
                if (rtcConnectionExt != null) {
                    rtcConnectionExt.inputExternalVideoData(bitmap, 0);
                }
                EMediaManager.this.setInputNext(true);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "input external video data -1-");
            }
        });
    }

    public void inputExternalVideoData(final byte[] byArray, final int n, final int n2, final int n3) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId);
                if (rtcConnectionExt != null) {
                    rtcConnectionExt.inputExternalVideoData(byArray, n, n2, n3);
                }
            }
        });
    }

    public void computeFrameRate() {
        this.fpsList.add(System.currentTimeMillis());
        long l = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
        if (l > 1000L) {
            this.removeFirst();
            l = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
            float f2 = (float)this.fpsList.size() / (float)l * 1000.0f;
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Input frame rate: " + f2);
        }
    }

    public void removeFirst() {
        this.fpsList.remove(0);
        long l = this.fpsList.get(this.fpsList.size() - 1) - this.fpsList.get(0);
        if (l > 1000L) {
            this.removeFirst();
        }
    }

    public void publish(final EMediaSession eMediaSession, final EMediaPublishConfiguration eMediaPublishConfiguration, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_INFO.ordinal(), "publish config=" + eMediaPublishConfiguration);
        if (!this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "pub")) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                Object object;
                JSONObject jSONObject = new JSONObject();
                EMediaManager.this.makePubArg(eMediaSession, eMediaPublishConfiguration.pubType, eMediaPublishConfiguration, jSONObject);
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_PUBLISH);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                String[] stringArray = new String[1];
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), stringArray);
                String string = "";
                try {
                    object = new JSONObject(stringArray[0]);
                    if (object.has("pubId")) {
                        string = object.getString("pubId");
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (n == 0 && eMediaPublishConfiguration.isExternalVideoSource() && (object = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string)) != null) {
                    ((RtcConnection)object).setEnableExternalVideoData(true);
                    if (eMediaPublishConfiguration.pubView != null) {
                        ((RtcConnectionExt)object).pubView = eMediaPublishConfiguration.pubView;
                        ((RtcConnection)object).setCaptureFromView(((RtcConnectionExt)object).pubView);
                    }
                }
                EMediaManager.this.invokeResult(eMediaSession, n, string, eMediaIdBlockType);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- publish");
            }
        });
    }

    public void unpublish(final EMediaSession eMediaSession, final String string, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unpublish");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "unpub")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("rtcId", (Object)string);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_UNPUBLISH);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt != null) {
                    EMediaManager.this.isUnpub = true;
                    EMediaManager.this.unpubCameraId = rtcConnectionExt.getCameraFacing();
                }
                String[] stringArray = new String[1];
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), stringArray);
                JSONTokener jSONTokener = new JSONTokener(stringArray[0]);
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2 = (JSONObject)jSONTokener.nextValue();
                    EMediaManager.this.invokeResult(eMediaSession, n, jSONObject2.optString("pubId"), eMediaIdBlockType);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unpublish");
            }
        });
    }

    public void subscribe(final EMediaSession eMediaSession, final String string, final VideoViewRenderer videoViewRenderer, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ subscribe ,streamId=" + string + " ,remoteview=[" + videoViewRenderer + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription;
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "sub")) {
                    return;
                }
                String string2 = EMediaManager.this.getSubcribeId(string);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "subscribing stream [" + string + "]with subsrId[" + string2 + "]");
                if (!EMediaManager.this.checkExistSubscribe(eMediaSession, eMediaIdBlockType, false, string, string2)) {
                    return;
                }
                if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string2) == null) {
                    eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                    eMediaStreamSubscription.subscribeId = string2;
                    eMediaStreamSubscription.view = videoViewRenderer;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string2, eMediaStreamSubscription);
                } else {
                    eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string2);
                    eMediaStreamSubscription.subscribeId = string2;
                    eMediaStreamSubscription.view = videoViewRenderer;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string2, eMediaStreamSubscription);
                }
                boolean bl = videoViewRenderer != null;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("subsrId", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("subSVideo", bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_SUBSR);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                if (n != 0) {
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string2);
                    EMediaManager.this.invokeResult(eMediaSession, n, null, eMediaIdBlockType);
                } else {
                    EMediaManager.this.invokeResult(eMediaSession, n, string2, eMediaIdBlockType);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- subscribe");
            }
        });
    }

    public void updateSubscribe(final EMediaSession eMediaSession, final String string, final VideoViewRenderer videoViewRenderer, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ update subscribe ,streamId=" + string + " ,remoteview=[" + videoViewRenderer + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "sub")) {
                    return;
                }
                String string2 = EMediaManager.this.getSubcribeId(string);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + string + "]with subsrId[" + string2 + "]");
                if (!EMediaManager.this.checkExistSubscribe(eMediaSession, eMediaIdBlockType, true, string, string2)) {
                    return;
                }
                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string2);
                if (eMediaStreamSubscription == null || eMediaStreamSubscription.view == videoViewRenderer) {
                    logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + string + "]with subsrId[" + string2 + "] ignore");
                    EMediaManager.this.invokeResult(eMediaSession, 0, string2, eMediaIdBlockType);
                    return;
                }
                if (eMediaStreamSubscription.rtc != null) {
                    eMediaStreamSubscription.rtc.setViews(null, videoViewRenderer);
                }
                if (eMediaStreamSubscription.view != null && videoViewRenderer != null) {
                    logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "update subscribe stream [" + string + "]with subsrId[" + string2 + "] change it");
                    eMediaStreamSubscription.view = videoViewRenderer;
                    EMediaManager.this.invokeResult(eMediaSession, 0, string2, eMediaIdBlockType);
                    return;
                }
                eMediaStreamSubscription.view = videoViewRenderer;
                boolean bl = videoViewRenderer != null;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("subsrId", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("subSVideo", bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_UP_SUBSR);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                if (n != 0) {
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string2);
                    EMediaManager.this.invokeResult(eMediaSession, n, null, eMediaIdBlockType);
                } else {
                    EMediaManager.this.invokeResult(eMediaSession, n, string2, eMediaIdBlockType);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- update subscribe");
            }
        });
    }

    public void unsubscribe(final EMediaSession eMediaSession, final String string, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unsubscribe ,streamId=[" + string + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "unsub")) {
                    return;
                }
                String string2 = EMediaManager.this.getSubcribeId(string);
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "unsubscribing  stream [" + string + "]with subsrId[" + string2 + "]");
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("subsrId", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_USUBSR);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invokeResult(eMediaSession, n, string2, eMediaIdBlockType);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unsubscribe");
            }
        });
    }

    public void switchCamera() {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchCamera");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.switchCamera();
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchCamera");
            }
        });
    }

    public static void setCameraFacing(final int n) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setCameraFacing");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (cameraId != n) {
                    cameraId = n;
                }
                RtcConnectionExt.setCameraFacing(n);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setCameraFacing");
            }
        });
    }

    public int getCameraFacing() {
        RtcConnectionExt rtcConnectionExt = this.mgrData.rtcDict.get(this.mgrData.myRtcId);
        if (rtcConnectionExt == null) {
            return 0;
        }
        return rtcConnectionExt.getCameraFacing();
    }

    public void setMuteEnabled(final boolean bl) {
        this.isMute = bl;
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setMuteEnabled ,enable=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (TextUtils.isEmpty((CharSequence)((EMediaManager)EMediaManager.this).mgrData.myMicRtcId)) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myMicRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.setMute(bl);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("rtcId", (Object)rtcConnectionExt.name);
                    jSONObject.put("aoff", bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setMuteEnabled");
            }
        });
    }

    public void setVideoEnabled(final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled ,enable=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                if (bl) {
                    rtcConnectionExt.startCapture();
                } else {
                    rtcConnectionExt.stopCapture();
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("rtcId", (Object)rtcConnectionExt.name);
                    jSONObject.put("voff", !bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled");
            }
        });
    }

    public void switchTorchOn(final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchTorchOn ,on=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.switchTorchOn(bl);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchTorchOn");
            }
        });
    }

    public void remoteCamerafocus(final EMediaSession eMediaSession, final String string, final boolean bl, final boolean bl2, final Point point, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCamerafocus ,streamId=[" + string + "] ,focus=[" + bl + "] ,exposure=[" + bl2 + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "remote-focus")) {
                    return;
                }
                int n = point.x * 10000;
                int n2 = point.y * 10000;
                int n3 = bl ? 1 : 0;
                int n4 = bl2 ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("x", n);
                    jSONObject.put("y", n2);
                    jSONObject.put("focus", n3);
                    jSONObject.put("expo", n4);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCamerafocus");
            }
        });
    }

    public void remoteCameraZoomWith(final EMediaSession eMediaSession, final String string, final float f2, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCameraZoomWith ,streamId=[" + string + "] ,zoomFactor=[" + f2 + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "remote-zoom")) {
                    return;
                }
                int n = (int)(f2 * 10000.0f);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("zoom", n);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCameraZoomWith");
            }
        });
    }

    public String getVersion() {
        return RtcConnection.getVersion();
    }

    public void setDocDirectory(String string) {
        RtcConnection.setDocDirectory(string);
    }

    public boolean startRecordPlayout() {
        return RtcConnection.startRecordPlayout();
    }

    public String stopRecordPlayout() {
        return RtcConnection.stopRecordPlayout();
    }

    public void enableStatistics(EMediaSession eMediaSession, boolean bl) {
        eMediaSession.enableStati = bl;
    }

    public void setAudioTalkerInterval(final int n, EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        if (!this.checkExistSession(this.session, eMediaIdBlockType, true, "set-audio-talker")) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int n2 = n;
                if (n2 < 50) {
                    n2 = 300;
                }
                if (n2 > 0 && ((EMediaManager)EMediaManager.this).session.audioVolumeInterval <= 0) {
                    EMediaManager.this.fireNextGetAudioVolume(EMediaManager.this.session, n2);
                }
                ((EMediaManager)EMediaManager.this).session.audioVolumeInterval = n2;
            }
        });
    }

    public void stopAudioTalker() {
        if (this.session != null) {
            this.session.audioVolumeInterval = 0;
        }
    }

    private void fireNextGetAudioVolume(final EMediaSession eMediaSession, final int n) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (eMediaSession.audioVolumeInterval > 0) {
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    Map<String, Map<Integer, Integer>> map = RtcConnection.getAudioVolumeOfRTCMap(((EMediaManager)EMediaManager.this).mgrData.rtcDict);
                    if (map != null && map.size() > 0) {
                        EMediaManager.this.parseAudioVolume(eMediaSession, map);
                    }
                    EMediaManager.this.fireNextGetAudioVolume(eMediaSession, eMediaSession.audioVolumeInterval);
                }
            }
        });
    }

    private void parseAudioVolume(EMediaSession eMediaSession, Map<String, Map<Integer, Integer>> map) {
        HashMap<String, EMediaTalker> hashMap = new HashMap<String, EMediaTalker>();
        for (String string : map.keySet()) {
            EMediaTalker eMediaTalker;
            Object object;
            Map<Integer, Integer> map2 = map.get(string);
            RtcConnectionExt rtcConnectionExt = this.mgrData.rtcDict.get(string);
            if (rtcConnectionExt == null || rtcConnectionExt.ownConn != eMediaSession) continue;
            int n = map2.get(-1);
            int n2 = map2.get(-2);
            if (rtcConnectionExt.pubType == EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_AUDIOMIX.val) {
                object = map2.keySet().iterator();
                while (object.hasNext()) {
                    EMediaTalker eMediaTalker2;
                    int n3 = object.next();
                    if (n3 < 0) continue;
                    EMediaStream eMediaStream = this.mgrData.csrcDict.get(n3);
                    if (eMediaStream != null) {
                        eMediaTalker2 = new EMediaTalker(eMediaStream.streamId);
                        hashMap.put(eMediaStream.streamId, eMediaTalker2);
                        continue;
                    }
                    if (rtcConnectionExt.csrc != 0 && rtcConnectionExt.csrc == n3) {
                        eMediaTalker2 = new EMediaTalker(rtcConnectionExt.name);
                        hashMap.put(rtcConnectionExt.name, eMediaTalker2);
                        continue;
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), String.format("csrc:" + n3 + " incoming:" + n, new Object[0]));
                }
                continue;
            }
            object = this.mgrData.streamDict.get(rtcConnectionExt.streamId);
            if (n >= 800 && object != null) {
                eMediaTalker = new EMediaTalker(((EMediaStream)object).streamId);
                hashMap.put(((EMediaStream)object).streamId, eMediaTalker);
            }
            if (this.isMute || n2 < 800) continue;
            eMediaTalker = new EMediaTalker(rtcConnectionExt.name);
            hashMap.put(rtcConnectionExt.name, eMediaTalker);
        }
        this.invoker.invokeOnNotice(EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_AUDIO_TALKERS, "", "", hashMap, eMediaSession);
    }

    private void setRtcListener() {
        RtcConnection.setRtcListener(new RtcListener(){

            @Override
            public void onError(RtcListener.RTCError rTCError) {
                switch (rTCError) {
                    case OPEN_CAMERA_FAIL: {
                        if (EMediaManager.this.session == null || ((EMediaManager)EMediaManager.this).session.delegate == null) break;
                        ((EMediaManager)EMediaManager.this).session.delegate.notice(EMediaManager.this.session, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_OPEN_CAMERA_FAIL, null, null, null);
                        break;
                    }
                    case OPEN_MIC_FAIL: {
                        if (EMediaManager.this.session == null || ((EMediaManager)EMediaManager.this).session.delegate == null) break;
                        ((EMediaManager)EMediaManager.this).session.delegate.notice(EMediaManager.this.session, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_OPEN_MIC_FAIL, null, null, null);
                    }
                }
            }
        });
    }

    public void manualFocus(final float f2, final float f3, final int n, final int n2) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualFocus -start- x:" + f2 + ", y:" + f3);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt != null) {
                    rtcConnectionExt.handleManualFocus(f2, f3, n, n2);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualFocus -end- ");
            }
        });
    }

    public void manualZoom(final boolean bl, final int n) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualZoom -start- zoomIn:" + bl + ", scale:" + n);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt != null) {
                    rtcConnectionExt.handleManualZoom(bl, n);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "manualZoom -start- ");
            }
        });
    }

    public boolean isSupportFlashLight() {
        if (this.getCameraFacing() == 1) {
            return false;
        }
        PackageManager packageManager = applicationContext.getPackageManager();
        FeatureInfo[] featureInfoArray = packageManager.getSystemAvailableFeatures();
        if (featureInfoArray != null) {
            for (FeatureInfo featureInfo : featureInfoArray) {
                if (featureInfo == null || !"android.hardware.camera.flash".equals(featureInfo.name)) continue;
                return true;
            }
        }
        return false;
    }

    public void sendCtrlMsgByMemberId(final EMediaSession eMediaSession, final String string, final int n, final Object object, final String string2, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByMemberId -start- " + string);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "send-custom")) {
                    return;
                }
                int n2 = n;
                if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode) {
                    n2 = 1003;
                } else if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CTRL_MSG.noticeCode) {
                    n2 = 1002;
                } else if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_RESPONSE_MSG.noticeCode) {
                    n2 = 1001;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("memId", (Object)string);
                    jSONObject.put("msg", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("context", object);
                    jSONObject.put("ctrlOP", n2);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_SEND_RCTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invoker.invokeBlock(eMediaIdBlockType, null, null, eMediaSession);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByMemberId -end- " + string);
            }
        });
    }

    public void sendCtrlMsgByStreamId(final EMediaSession eMediaSession, final String string, final int n, final Object object, final String string2, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByStreamId -start- " + string);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "send-custom")) {
                    return;
                }
                int n2 = n;
                if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CUSTOM_MSG.noticeCode) {
                    n2 = 1003;
                } else if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_CTRL_MSG.noticeCode) {
                    n2 = 1002;
                } else if (n == EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_RESPONSE_MSG.noticeCode) {
                    n2 = 1001;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("msg", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("context", object);
                    jSONObject.put("ctrlOP", n2);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_SEND_RCTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invoker.invokeBlock(eMediaIdBlockType, null, null, eMediaSession);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "sendCtrlMsgByStreamId -end- " + string);
            }
        });
    }

    public void setSubscribeAudioMixEnabled(final boolean bl) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int n = bl ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_ENABLE_SUB_AUDIOMIX);
                    jSONObject.put("code", n);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
            }
        });
    }

    public void setSpecificServerUrl(final String string, final String string2) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                EMediaManager.this.specificUrl = string;
                EMediaManager.this.specificCandIP = string2;
            }
        });
    }

    public void setVideoMaxKbps(int n) {
        if (this.configObject != null) {
            try {
                this.configObject.put("maxVKbps", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setVideoMinKbps(int n) {
        RtcConnection.setMinVideoKbps(n);
    }

    public void setAudioMaxKbps(int n) {
        if (this.configObject != null) {
            try {
                this.configObject.put("maxAKbps", n);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    public void setAECConfig(String string, int n) {
        this.mgrData.bridger.setAECConfig(string, n);
    }

    public void setAECConfig(String string, String string2) {
        this.mgrData.bridger.setAECConfig(string, string2);
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            EMediaManager.this.timerDidFire();
                        }
                    });
                }
            }, 0L, 1000L);
        }
        catch (Exception exception) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: Can not schedule statistics timer " + exception);
        }
    }

    public void timerDidFire() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_TIMER);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                if (n != 0) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: timerDidFire: fail with " + n);
                }
            }
        });
    }

    public void stopTimer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "stop timer");
                if (EMediaManager.this.timer != null) {
                    EMediaManager.this.timer.cancel();
                    EMediaManager.this.timer.purge();
                    EMediaManager.this.timer = null;
                }
            }
        });
    }

    static {
        isInit = false;
        iscreatemediamanager = false;
        instance = null;
        idnum = 0L;
        cameraId = -1;
        logcallback = new XClientBridger.Logcallbackfunc(){

            @Override
            public void onLog(int n, String string) {
                Log.i((String)EMediaManager.TAG, (String)string);
            }
        };
    }

    private class ManagerData {
        public String myRtcId;
        public String shareRtcId;
        public String myMicRtcId;
        public VideoViewRenderer localViewRender;
        public XClientBridger bridger;
        public LooperExecutor workQueue;
        public Map<String, RtcConnectionExt> rtcDict = new HashMap<String, RtcConnectionExt>();
        public Map<String, EMediaSession> connDict = new HashMap<String, EMediaSession>();
        public Map<String, EMediaEntities.EMediaStreamSubscription> subsrDict = new HashMap<String, EMediaEntities.EMediaStreamSubscription>();
        public Map<String, String> subscribidRtcid = new HashMap<String, String>();
        public EMediaSession pubSession;
        public Map<String, EMediaStream> streamDict = new HashMap<String, EMediaStream>();
        public Map<Integer, EMediaStream> csrcDict = new HashMap<Integer, EMediaStream>();
    }

    private static enum logLevel {
        LS_INFO,
        LS_DEBUG,
        LS_ERROR;

    }
}

