/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import com.superrtc.sdk.VideoViewWrapper;

/*!
 * Created by lzan13 on 2017/5/10.
 *
 * \~chinese
 * 视频通话UI显示视图，
 * 这里将原来的 EMLocalSurfaceView 和 EMOppositeSurfaceView 合并，方便 App 层面切换通话视图
 *
 * \~english
 * The video call UI displays the view,
 * Here the original EMLocalSurfaceView and EMOppositeSurfaceView merger, to facilitate the realization of UI size switch
 */
public class EMCallSurfaceView extends VideoViewWrapper {

    public EMCallSurfaceView(Context context) {
        this(context, null);
    }

    public EMCallSurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EMCallSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    /**
     * ~\chinese
     * 设置封面图片.
     * 如果view通过该方法设置了封面(bitmap)，则在通过{@link com.hyphenate.chat.EMConferenceManager#updateLocalSurfaceView(EMCallSurfaceView)}
     * 或{@link com.hyphenate.chat.EMConferenceManager#updateRemoteSurfaceView(String, EMCallSurfaceView)}设置该view时，该view会在stream到来前显示封面。
     *
     * @param bitmap
     *
     * ~\english
     * Set a cover image.
     * If set a cover by this method, when this view be set by
     * {@link com.hyphenate.chat.EMConferenceManager#updateLocalSurfaceView(EMCallSurfaceView)}
     * or {@link com.hyphenate.chat.EMConferenceManager#updateRemoteSurfaceView(String, EMCallSurfaceView)},
     * the cover would show first until stream coming.
     *
     * @param bitmap
     */
    @Override
    public void setCoverImage(Bitmap bitmap) {
        super.setCoverImage(bitmap);
    }

    /**
     * ~\chinese
     * 判断当前view是否设置了封面
     *
     * @return
     *
     * ~\english
     * Check whether this view set a cover.
     *
     * @return
     */
    @Override
    public boolean hasCover() {
        return super.hasCover();
    }
}
