/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.exceptions.HyphenateException;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EMAChatManager extends EMABase {
	
	// used to keep reference of listener, JNI part will not track the reference
	// that's to avoid GC listeners.
	private Set<EMAChatManagerListener> listeners = new HashSet<EMAChatManagerListener>();
	
    public void sendMessage(EMAMessage msg) {
    	nativeSendMessage(msg);	
    }
    
    public void recallMessage(EMAMessage msg, EMAError error)
    {
        nativeRecallMessage(msg, error);
    }
    public void sendReadAckForMessage(EMAMessage msg)
    {
    	nativeSendReadAckForMessage(msg);
    }

    public void resendMessage(EMAMessage msg)
    {
    	 nativeResendMessage(msg);
    }
    
    public void downloadMessageThumbnail(EMAMessage msg)
    {
    	nativeDownloadMessageThumbnail(msg);
    }
    
    public void downloadMessageAttachments(EMAMessage msg)
    {
    	nativeDownloadMessageAttachments(msg);
    }
 
    public void removeConversation(String conversationId, boolean isRemoveMessages)
    {
    	nativeRemoveConversation(conversationId, isRemoveMessages);
    }

    public EMAConversation conversationWithType(String conversationId,
    		EMAConversation.EMAConversationType type, boolean createIfNotExist)
    {
    	return nativeConversationWithType(conversationId, type.ordinal(), createIfNotExist);
    }
    
    public List<EMAConversation> getConversations()
    {
    	return nativeGetConversations();
    }
    
    public List<EMAConversation> loadAllConversationsFromDB()
    {
    	return nativeLoadAllConversationsFromDB();
    }
    
    public void addListener(EMAChatManagerListener listener)
    {
    	listeners.add(listener);
    	nativeAddListener(listener);
    }
    
    public void removeListener(EMAChatManagerListener listener)
    {
    	listeners.remove(listener);
    	nativeRemoveListener(listener);
    }
    
    public void clearListeners()
    {
    	listeners.clear();
    	nativeClearListeners();
    }
    
    public void setEncryptProvider(EMAEncryptProviderInterface provider)
    {
    	nativeSetEncryptProvider(provider);
    }
    
    public EMAEncryptProviderInterface getEncryptProvider(boolean createIfNotExist)
    {
    	return nativeGetEncryptProvider(createIfNotExist);
    }
    
    public EMAMessage getMessage(final String messageId) {
    	return nativeGetMessage(messageId);
    }
    
    public void uploadLog() {
        nativeUploadLog();
    }

    native void nativeSendMessage(EMAMessage msg);

    native void nativeRecallMessage(EMAMessage msg, EMAError error);
    
    native void nativeSendReadAckForMessage(EMAMessage msg);

    native void nativeResendMessage(EMAMessage msg);
    
    native void nativeDownloadMessageThumbnail(EMAMessage msg);
    
    native void nativeDownloadMessageAttachments(EMAMessage msg);
 
    native void nativeRemoveConversation(String conversationId, boolean isRemoveMessages);

    native EMAConversation nativeConversationWithType(String conversationId,
    		int conversationType, boolean createIfNotExist);
    
    native List<EMAConversation> nativeGetConversations();
    
    native List<EMAConversation> nativeLoadAllConversationsFromDB();
    
    native void nativeAddListener(EMAChatManagerListener listener);
    
    native void nativeRemoveListener(EMAChatManagerListener listener);
    
    native void nativeClearListeners();
    
    native void nativeSetEncryptProvider(EMAEncryptProviderInterface provider);
    
    native EMAEncryptProviderInterface nativeGetEncryptProvider(boolean createIfNotExist);
    
    native EMAMessage nativeGetMessage(String messageId);
    
    native void nativeUploadLog();
    
    protected EMAChatManager() {}
    
    protected EMAChatManager(EMAChatManager manager) {
        nativeInit(manager);
    }
    native void nativeInit(EMAChatManager manager);

    public boolean updateParticipant(String from, String changeTo) {
        return nativeUpdateParticipant(from, changeTo);
    }
    native boolean nativeUpdateParticipant(String from, String changeTo);

    public EMCursorResult<EMAMessage> fetchHistoryMessages(String conversationId, int type, int pageSize,
                                     String startMsgId, EMAError error) {
        return nativeFetchHistoryMessages(conversationId, type, pageSize, startMsgId, error);
    }

    native EMCursorResult<EMAMessage> nativeFetchHistoryMessages(String conversationId, int type, int pageSize,
                                                                String startMsgId, EMAError error);

}

