/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.RtcConnection.RtcStatistics;

public class EMACallRtcListenerDelegate extends EMABase  implements RtcConnection.Listener{
    RtcStatistics states;
    public synchronized RtcStatistics getStatistics() {
        return states;
    }

    @Override
    public void onClosed(RtcConnection rtcConnection) {
        nativeOnClosed();
    }
    native void nativeOnClosed();

    @Override
    public void onConnected(RtcConnection rtcConnection) {
        nativeOnConnected();
    }
    native void nativeOnConnected();

    @Override
    public void onDisconnected(RtcConnection rtcConnection) {
        nativeOnDisconnected();
    }
    native void nativeOnDisconnected();

    @Override
    public void onError(RtcConnection rtcConnection, String arg0) {
        nativeOnError();
    }
    native void nativeOnError();

    @Override
    public void onLocalCandidate(RtcConnection rtcConnection, String arg0) {
        nativeOnLocalCandidate(arg0);
    }
    native void nativeOnLocalCandidate(String arg0);

    @Override
    public void onLocalSdp(RtcConnection rtcConnection, String arg0) {
        nativeOnLocalSdp(arg0);
    }
    native void nativeOnLocalSdp(String arg0);

    @Override
    public void onStats(RtcConnection rtcConnection, RtcStatistics arg0) {
        synchronized (this) {
            states = arg0;
        }
        EMACallSessionStatistics statistics = new EMACallSessionStatistics();
        statistics.setConnType(states.connectionType);
        statistics.setLocalVideoRtt(states.localVideoRtt);
        statistics.setRemoteVideoWidth(states.remoteWidth);
        statistics.setRemoteVideoHeight(states.remoteHeight);
        statistics.setLocalVideoFps(states.localEncodedFps);
        statistics.setRemoteVideoFps(states.remoteFps);
        statistics.setLocalVideoPacketsLost(states.localVideoPacketsLost);
        statistics.setRemoteVideoPacketsLost(states.remoteVideoPacketsLost);
        statistics.setLocalVideoActualBps(states.localVideoActualBps);
        statistics.setRemoteAudioBps(states.remoteAudioBps);
        statistics.setRemoteVideoBps(states.remoteVideoBps);
        //statistics.setRtcReport(states.xx_no_method);
        nativeOnStats(statistics);
    }
    native void nativeOnStats(EMACallSessionStatistics statistics);

    @Override
    public void onConnectionsetup(RtcConnection rtcConnection) {
        nativeOnConnectionSetup();
    }
    native void nativeOnConnectionSetup();

    @Override
    public void onCandidateCompleted(RtcConnection rtcConnection) {
        nativeOnCandidateCompleted();
    }
    native void nativeOnCandidateCompleted();
    
    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }    
    native void nativeFinalize();

}
