/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import android.util.Pair;

import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

class EMExtraService {
	
	private static final String TAG = EMExtraService.class.getSimpleName();
	
	/**
	 * global EMExtraService instance
	 */
	private static final EMExtraService me = new EMExtraService();
	
	/**
	 * get global EMExtraService instance
	 * @return
	 */
	public static EMExtraService getInstance(){
		return me;
	}

	/**
	 * 获取Robot列表
	 * @throws HyphenateException 
	 */
	protected List<EMContact> getRobotsFromServer() throws HyphenateException {
		final List<EMContact> mList = new ArrayList<EMContact>();
		String url = HttpClientConfig.getBaseUrlByAppKey() + "/robots";
		try {
			Pair<Integer, String> result = EMHttpClient.getInstance().sendRequestWithToken(url, null, EMHttpClient.GET);
			if (result != null && result.first == 200) {
				String respResult = result.second;
				JSONObject jsonObject = new JSONObject(respResult);
				if (jsonObject.has("entities")) {
					JSONArray entitiesArray = jsonObject.getJSONArray("entities");
					for (int i = 0; i < entitiesArray.length(); i++) {
						JSONObject jsonBot = entitiesArray.getJSONObject(i);
						EMContact user = new EMContact();
						user.username = jsonBot.getString("username").toLowerCase();
						if (jsonBot.has("name")) {
							user.nick = jsonBot.getString("name");
						}
						boolean isActive = false;
						if (jsonBot.has("activated")) {
							isActive = jsonBot.getBoolean("activated");
						}
						if (isActive) {
							mList.add(user);
						}
					}
				}
			} else if (result != null) {
				EMLog.e(TAG, "getRobotUsers resp statusCode:" + result.first);
			} else {
				EMLog.e(TAG, "getRobotUsers resp result is null");
			}
		} catch (HyphenateException e) {
			throw e;
		} catch (JSONException e) {
			throw new HyphenateException(e.getMessage());
		}
		return mList;
	}

}
