/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import com.superrtc.call.AudioTrack;
import com.superrtc.call.MediaStreamTrack;
import com.superrtc.call.VideoTrack;
import java.util.LinkedList;

public class MediaStream {
    public final LinkedList<AudioTrack> audioTracks = new LinkedList();
    public final LinkedList<VideoTrack> videoTracks = new LinkedList();
    public final LinkedList<VideoTrack> preservedVideoTracks = new LinkedList();
    final long nativeStream;

    public MediaStream(long l) {
        this.nativeStream = l;
    }

    public boolean addTrack(AudioTrack audioTrack) {
        if (MediaStream.nativeAddAudioTrack(this.nativeStream, audioTrack.nativeTrack)) {
            this.audioTracks.add(audioTrack);
            return true;
        }
        return false;
    }

    public boolean addTrack(VideoTrack videoTrack) {
        if (MediaStream.nativeAddVideoTrack(this.nativeStream, videoTrack.nativeTrack)) {
            this.videoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean addPreservedTrack(VideoTrack videoTrack) {
        if (MediaStream.nativeAddVideoTrack(this.nativeStream, videoTrack.nativeTrack)) {
            this.preservedVideoTracks.add(videoTrack);
            return true;
        }
        return false;
    }

    public boolean removeTrack(AudioTrack audioTrack) {
        this.audioTracks.remove(audioTrack);
        return MediaStream.nativeRemoveAudioTrack(this.nativeStream, audioTrack.nativeTrack);
    }

    public boolean removeTrack(VideoTrack videoTrack) {
        this.videoTracks.remove(videoTrack);
        this.preservedVideoTracks.remove(videoTrack);
        return MediaStream.nativeRemoveVideoTrack(this.nativeStream, videoTrack.nativeTrack);
    }

    public void dispose() {
        MediaStreamTrack mediaStreamTrack;
        while (!this.audioTracks.isEmpty()) {
            mediaStreamTrack = this.audioTracks.getFirst();
            this.removeTrack((AudioTrack)mediaStreamTrack);
            mediaStreamTrack.dispose();
        }
        while (!this.videoTracks.isEmpty()) {
            mediaStreamTrack = this.videoTracks.getFirst();
            this.removeTrack((VideoTrack)mediaStreamTrack);
            ((VideoTrack)mediaStreamTrack).dispose();
        }
        while (!this.preservedVideoTracks.isEmpty()) {
            this.removeTrack(this.preservedVideoTracks.getFirst());
        }
        MediaStream.free(this.nativeStream);
    }

    public String label() {
        return MediaStream.nativeLabel(this.nativeStream);
    }

    public String toString() {
        return "[" + this.label() + ":A=" + this.audioTracks.size() + ":V=" + this.videoTracks.size() + "]";
    }

    private static native boolean nativeAddAudioTrack(long var0, long var2);

    private static native boolean nativeAddVideoTrack(long var0, long var2);

    private static native boolean nativeRemoveAudioTrack(long var0, long var2);

    private static native boolean nativeRemoveVideoTrack(long var0, long var2);

    private static native String nativeLabel(long var0);

    private static native void free(long var0);
}

