/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.hardware.Camera;
import android.os.SystemClock;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.Logging;
import java.util.ArrayList;
import java.util.List;

public class CameraEnumerator
implements CameraEnumerationAndroid.Enumerator {
    private static final String TAG = "CameraEnumerator";
    private List<List<CameraEnumerationAndroid.CaptureFormat>> cachedSupportedFormats;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats(int n) {
        CameraEnumerator cameraEnumerator = this;
        synchronized (cameraEnumerator) {
            if (this.cachedSupportedFormats == null) {
                this.cachedSupportedFormats = new ArrayList<List<CameraEnumerationAndroid.CaptureFormat>>();
                for (int k = 0; k < CameraEnumerationAndroid.getDeviceCount(); ++k) {
                    this.cachedSupportedFormats.add(this.enumerateFormats(k));
                }
            }
        }
        return this.cachedSupportedFormats.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CameraEnumerationAndroid.CaptureFormat> enumerateFormats(int n) {
        Camera.Parameters parameters;
        Logging.d(TAG, "Get supported formats for camera index " + n + ".");
        long l = SystemClock.elapsedRealtime();
        Camera camera = null;
        try {
            Logging.d(TAG, "Opening camera with index " + n);
            camera = Camera.open((int)n);
            parameters = camera.getParameters();
        }
        catch (RuntimeException runtimeException) {
            Logging.e(TAG, "Open camera failed on camera index " + n, runtimeException);
            ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
            return arrayList;
        }
        finally {
            if (camera != null) {
                camera.release();
            }
        }
        ArrayList<CameraEnumerationAndroid.CaptureFormat> arrayList = new ArrayList<CameraEnumerationAndroid.CaptureFormat>();
        try {
            Object object;
            Object exception;
            boolean n2 = false;
            boolean bl = false;
            List list = parameters.getSupportedPreviewFpsRange();
            if (list != null) {
                Object object2 = (int[])list.get(list.size() - 1);
                exception = object2[0];
                object = object2[1];
            }
            for (Camera.Size size : parameters.getSupportedPreviewSizes()) {
                arrayList.add(new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, (int)exception, (int)object));
            }
        }
        catch (Exception l2) {
            Logging.e(TAG, "getSupportedFormats() failed on camera index " + n, l2);
        }
        long l2 = SystemClock.elapsedRealtime();
        Logging.d(TAG, "Get supported formats for camera index " + n + " done. Time spent: " + (l2 - l) + " ms.");
        return arrayList;
    }
}

