/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.graphics.Bitmap;
import com.hyphenate.EMConferenceListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConference;
import com.hyphenate.chat.EMConferenceMember;
import com.hyphenate.chat.EMConferenceStream;
import com.hyphenate.chat.EMStreamParam;
import com.hyphenate.chat.EMStreamStatistics;
import com.hyphenate.chat.adapter.EMACallConferenceListener;
import com.hyphenate.chat.adapter.EMACallManager;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.media.EMCallSurfaceView;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.EasyUtils;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaManager;
import com.superrtc.mediamanager.EMediaPublishConfiguration;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.VideoViewRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMConferenceManager {
    private final String TAG = this.getClass().getSimpleName();
    private EMACallManager emaCallManager;
    private EMediaManager mediaManager = null;
    private EMediaSession mediaSession = null;
    private Role role = new Role();
    private ExecutorService executorService;
    private List<EMConferenceListener> conferenceListeners = Collections.synchronizedList(new ArrayList());
    private List<EMConferenceMember> memberList = Collections.synchronizedList(new ArrayList());
    private Map<String, EMConferenceStream> availableStreamMap = new ConcurrentHashMap<String, EMConferenceStream>();
    private Map<String, EMConferenceStream> subscribedStreamMap = new ConcurrentHashMap<String, EMConferenceStream>();
    private EMConferenceListener.ConferenceMode conferenceMode = EMConferenceListener.ConferenceMode.NORMAL;
    EMediaSession.EMediaSessionDelegate sessionDelegate = new EMediaSession.EMediaSessionDelegate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void joinMember(EMediaSession eMediaSession, EMediaEntities.EMediaMember eMediaMember) {
            EMLog.d(EMConferenceManager.this.TAG, "onMemberJoined() memberName: " + eMediaMember.memberName + ", extension: " + eMediaMember.extension);
            EMConferenceMember eMConferenceMember = EMConferenceManager.this.memberContains(eMediaMember.memberName);
            if (null != eMConferenceMember) {
                EMConferenceManager.this.memberList.remove(eMConferenceMember);
            }
            EMConferenceMember eMConferenceMember2 = EMConferenceMember.from(eMediaMember);
            EMConferenceManager.this.memberList.add(eMConferenceMember2);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMemberJoined(eMConferenceMember2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void exitMember(EMediaSession eMediaSession, EMediaEntities.EMediaMember eMediaMember) {
            EMLog.d(EMConferenceManager.this.TAG, "onMemberExited() memberName: " + eMediaMember.memberName + ", extension: " + eMediaMember.extension);
            EMConferenceMember eMConferenceMember = EMConferenceManager.this.memberContains(eMediaMember.memberName);
            if (null != eMConferenceMember) {
                EMConferenceManager.this.memberList.remove(eMConferenceMember);
            }
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onMemberExited(EMConferenceMember.from(eMediaMember));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamAdded() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = new EMConferenceStream();
            eMConferenceStream.init(eMediaStream);
            EMConferenceManager.this.availableStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamAdded(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamRemoved() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = null;
            if (EMConferenceManager.this.availableStreamMap.containsKey(eMediaStream.streamId)) {
                eMConferenceStream = (EMConferenceStream)EMConferenceManager.this.availableStreamMap.get(eMediaStream.streamId);
                EMConferenceManager.this.availableStreamMap.remove(eMediaStream.streamId);
            } else if (EMConferenceManager.this.subscribedStreamMap.containsKey(eMediaStream.streamId)) {
                eMConferenceStream = (EMConferenceStream)EMConferenceManager.this.subscribedStreamMap.get(eMediaStream.streamId);
                EMConferenceManager.this.subscribedStreamMap.remove(eMediaStream.streamId);
            } else {
                eMConferenceStream = new EMConferenceStream();
            }
            eMConferenceStream.init(eMediaStream);
            EMConferenceManager.this.mediaManager.unsubscribe(eMediaSession, eMediaStream.streamId, null);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamRemoved(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateStream(EMediaSession eMediaSession, EMediaStream eMediaStream) {
            EMLog.d(EMConferenceManager.this.TAG, "onStreamUpdate() memberName: " + eMediaStream.memberName + ", extension: " + eMediaStream.extension + ", streamId: " + eMediaStream.streamId + ", streamName: " + eMediaStream.streamName + ", streamType: " + (Object)((Object)eMediaStream.streamType) + ", audioOff: " + eMediaStream.audioOff + ", videoOff: " + eMediaStream.videoOff);
            EMConferenceStream eMConferenceStream = null;
            eMConferenceStream = EMConferenceManager.this.availableStreamMap.containsKey(eMediaStream.streamId) ? (EMConferenceStream)EMConferenceManager.this.availableStreamMap.get(eMediaStream.streamId) : (EMConferenceManager.this.subscribedStreamMap.containsKey(eMediaStream.streamId) ? (EMConferenceStream)EMConferenceManager.this.subscribedStreamMap.get(eMediaStream.streamId) : new EMConferenceStream());
            eMConferenceStream.init(eMediaStream);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onStreamUpdate(eMConferenceStream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void passiveCloseReason(EMediaSession eMediaSession, int n, String string) {
            EMLog.d(EMConferenceManager.this.TAG, "onPassiveLeave() code: " + n + ", reason: " + string);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onPassiveLeave(n, string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notice(EMediaSession eMediaSession, EMediaDefines.EMediaNoticeCode eMediaNoticeCode, String string, String string2, Object object) {
            EMLog.d(EMConferenceManager.this.TAG, "Notice code: " + (Object)((Object)eMediaNoticeCode) + ", arg1=" + string + ", arg2=" + string2 + ", arg3=" + object);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    EMConferenceListener.ConferenceState conferenceState = EMConferenceManager.this.stateMap(eMediaNoticeCode.noticeCode);
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_PUBLISH_SETUP) {
                        eMConferenceListener.onStreamSetup(string);
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_SUBSCRIBE_SETUP) {
                        eMConferenceListener.onStreamSetup(string);
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_STATISTICS) {
                        EMLog.d(EMConferenceManager.this.TAG, "Notice state: " + (Object)((Object)conferenceState) + ", arg1=" + string + ", arg2=" + string2 + ", arg3=" + object);
                        eMConferenceListener.onStreamStatistics(new EMStreamStatistics(string2, (RtcConnection.RtcStatistics)object));
                        continue;
                    }
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_CUSTOM_MSG || conferenceState == EMConferenceListener.ConferenceState.STATE_P2P_PEER_EXIT || conferenceState == EMConferenceListener.ConferenceState.STATE_TAKE_CAMERA_PICTURE) continue;
                    if (conferenceState == EMConferenceListener.ConferenceState.STATE_AUDIO_TALKERS) {
                        Map map = (Map)object;
                        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
                        eMConferenceListener.onSpeakers(arrayList);
                        continue;
                    }
                    eMConferenceListener.onConferenceState(conferenceState);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void changeRole(EMediaSession eMediaSession) {
            int n = eMediaSession.role;
            EMLog.i(EMConferenceManager.this.TAG, "updateRole: " + n);
            List list = EMConferenceManager.this.conferenceListeners;
            synchronized (list) {
                for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners.subList(0, EMConferenceManager.this.conferenceListeners.size())) {
                    eMConferenceListener.onRoleChanged(EMConferenceRole.from(n));
                }
            }
        }
    };

    protected EMConferenceManager(EMACallManager eMACallManager) {
        this.emaCallManager = eMACallManager;
        if (!EMediaManager.isInit()) {
            EMediaManager.initGlobal(EMClient.getInstance().getContext());
        }
        this.mediaManager = EMediaManager.getInstance();
        this.executorService = Executors.newCachedThreadPool();
        this.emaCallManager.setCallConferenceListener(new EMACallConferenceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveInvite(String string, String string2, String string3) {
                List list = EMConferenceManager.this.conferenceListeners;
                synchronized (list) {
                    try {
                        for (EMConferenceListener eMConferenceListener : EMConferenceManager.this.conferenceListeners) {
                            eMConferenceListener.onReceiveInvite(string, string2, string3);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.setSubscribeAudioMixEnable();
    }

    public void addConferenceListener(EMConferenceListener eMConferenceListener) {
        if (eMConferenceListener != null && !this.conferenceListeners.contains(eMConferenceListener)) {
            this.conferenceListeners.add(eMConferenceListener);
        }
    }

    public void removeConferenceListener(EMConferenceListener eMConferenceListener) {
        if (eMConferenceListener != null) {
            this.conferenceListeners.remove(eMConferenceListener);
        }
    }

    public void getConferenceInfo(final String string, final String string2, final EMValueCallBack<EMConference> eMValueCallBack) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("confrId", string);
                    hashMap.put("password", string2);
                    String string3 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string22 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(4, string3, eMAError);
                    if (eMAError.errCode() != 0) {
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject(string22);
                        JSONObject jSONObject2 = jSONObject.optJSONObject("confr");
                        EMConference eMConference = new EMConference();
                        eMConference.setPassword(string2);
                        eMConference.setConferenceId(jSONObject2.optString("id"));
                        eMConference.setConferenceType(EMConferenceType.from(jSONObject2.optInt("type")));
                        eMConference.setMemberNum(jSONObject2.optInt("memTotal"));
                        JSONArray jSONArray = jSONObject2.optJSONArray("admins");
                        String[] stringArray = new String[jSONArray.length()];
                        for (int k = 0; k < jSONArray.length(); ++k) {
                            stringArray[k] = jSONArray.getString(k);
                        }
                        eMConference.setAdmins(stringArray);
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onSuccess(eMConference);
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block6;
                        eMValueCallBack.onError(1, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void createAndJoinConference(EMConferenceType eMConferenceType, String string, EMValueCallBack<EMConference> eMValueCallBack) {
        this.createAndJoinConference(eMConferenceType, string, null, eMValueCallBack);
    }

    @Deprecated
    public void createAndJoinConference(final EMConferenceType eMConferenceType, final String string, final EMStreamParam eMStreamParam, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "createAndJoinConference");
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("uid", EasyUtils.getMediaRequestUid(EMClient.getInstance().getOptions().getAppKey(), EMClient.getInstance().getCurrentUser()));
                    hashMap.put("token", EMClient.getInstance().getAccessToken());
                    hashMap.put("confrType", eMConferenceType.code);
                    hashMap.put("password", string);
                    EMConferenceManager.this.addCommonParams(hashMap);
                    String string4 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(0, string4, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "requestMediaFromServer failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    final EMConference eMConference = new EMConference();
                    try {
                        JSONObject jSONObject = new JSONObject(string2);
                        String string3 = jSONObject.optString("ticket");
                        eMConference.setConferenceId(jSONObject.optString("confrId"));
                        eMConference.setPassword(string);
                        eMConference.setConferenceType(eMConferenceType);
                        EMLog.d(EMConferenceManager.this.TAG, "Join conference");
                        EMConferenceManager.this.role.update(EMConferenceRole.Admin, jSONObject.optString("roleToken"));
                        EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string3, "{'extension':'creator'}", EMConferenceManager.this.sessionDelegate);
                        EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference success!");
                                    if (eMConferenceType == EMConferenceType.LiveStream) {
                                        eMConference.setConferenceRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    } else {
                                        eMConference.setConferenceRole(EMConferenceRole.Admin);
                                    }
                                    eMConference.setPubStreamId((String)object, EMConferenceStream.StreamType.NORMAL);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess(eMConference);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block4;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void joinConference(String string, String string2, EMValueCallBack<EMConference> eMValueCallBack) {
        this.joinConference(string, string2, null, eMValueCallBack);
    }

    @Deprecated
    public void joinConference(final String string, final String string2, final EMStreamParam eMStreamParam, final EMValueCallBack<EMConference> eMValueCallBack) {
        EMLog.d(this.TAG, "joinConference");
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block4: {
                    EMAError eMAError = new EMAError();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("uid", EasyUtils.getMediaRequestUid(EMClient.getInstance().getOptions().getAppKey(), EMClient.getInstance().getCurrentUser()));
                    hashMap.put("token", EMClient.getInstance().getAccessToken());
                    hashMap.put("confrId", string);
                    hashMap.put("password", string2);
                    EMConferenceManager.this.addCommonParams(hashMap);
                    String string4 = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                    String string22 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(0, string4, eMAError);
                    if (eMAError.errCode() != 0) {
                        EMLog.d(EMConferenceManager.this.TAG, "requestMediaFromServer failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                        if (eMValueCallBack != null) {
                            eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                        }
                        return;
                    }
                    final EMConference eMConference = new EMConference();
                    eMConference.setConferenceId(string);
                    eMConference.setPassword(string2);
                    try {
                        JSONObject jSONObject = new JSONObject(string22);
                        String string3 = jSONObject.optString("ticket");
                        eMConference.setConferenceType(EMConferenceType.from(jSONObject.optInt("type")));
                        EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string3, "{'extension':'member'}", EMConferenceManager.this.sessionDelegate);
                        EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference success!");
                                    if (eMConference.getConferenceType() == EMConferenceType.LiveStream) {
                                        eMConference.setConferenceRole(EMConferenceRole.from(((EMConferenceManager)EMConferenceManager.this).mediaSession.role));
                                    } else {
                                        eMConference.setConferenceRole(EMConferenceRole.Admin);
                                    }
                                    eMConference.setPubStreamId((String)object, EMConferenceStream.StreamType.NORMAL);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess(eMConference);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block4;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void joinConferenceWithTicket(final String string, final EMStreamParam eMStreamParam, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "joinConferenceWithTicket");
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        EMLog.d(EMConferenceManager.this.TAG, "Join conference");
                        EMConferenceManager.this.mediaSession = EMConferenceManager.this.mediaManager.newSessionWithTicket(string, "{'extension':'member'}", EMConferenceManager.this.sessionDelegate);
                        EMConferenceManager.this.mediaManager.setSession(EMConferenceManager.this.mediaSession, EMClient.getInstance().getCurrentUser());
                        EMConferenceManager.this.mediaManager.join(EMConferenceManager.this.mediaSession, EMConferenceManager.this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

                            @Override
                            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                                if (eMediaError != null) {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference with ticket failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                                    }
                                } else {
                                    EMLog.d(EMConferenceManager.this.TAG, "Join conference with ticket success!");
                                    if (eMValueCallBack != null) {
                                        eMValueCallBack.onSuccess((String)object);
                                    }
                                }
                            }
                        });
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        if (eMValueCallBack == null) break block2;
                        eMValueCallBack.onError(804, jSONException.getMessage());
                    }
                }
            }
        });
    }

    public void inviteUserToJoinConference(final String string, final String string2, final String string3, final String string4, final EMValueCallBack eMValueCallBack) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "inviteUserToJoinConference");
                EMAError eMAError = new EMAError();
                EMConferenceManager.this.emaCallManager.inviteUserToJoinConference(string, string2, string3, string4, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "inviteUserToJoinConference failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    return;
                }
                eMValueCallBack.onSuccess(null);
            }
        });
    }

    public void grantRole(String string, final EMConferenceMember eMConferenceMember, final EMConferenceRole eMConferenceRole, final EMValueCallBack<String> eMValueCallBack) {
        if (this.role.getRole() != EMConferenceRole.Admin) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.d(EMConferenceManager.this.TAG, "grantRole, " + eMConferenceMember.memberName);
                EMAError eMAError = new EMAError();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("uids", new Object[]{eMConferenceMember.memberName});
                hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                hashMap.put("role", eMConferenceRole.code);
                EMConferenceManager.this.addCommonParams(hashMap);
                String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(1, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "grantRole failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "grantRole success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(string2);
                    }
                }
            }
        });
    }

    protected void addCommonParams(Map<String, Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("os", "Android");
        hashMap.put("version", "3.5.0");
        map.put("terminal", hashMap);
    }

    public void destroyConference(final EMValueCallBack eMValueCallBack) {
        EMLog.d(this.TAG, "destroyConference");
        if (this.role.getRole() != EMConferenceRole.Admin) {
            return;
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                EMAError eMAError = new EMAError();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("roleToken", EMConferenceManager.this.role.getRoleToken());
                String string = EMConferenceManager.convertMapToJSONObject(hashMap).toString();
                String string2 = EMConferenceManager.this.emaCallManager.requestMediaFromServer(3, string, eMAError);
                if (eMAError.errCode() != 0) {
                    EMLog.d(EMConferenceManager.this.TAG, "destroyConference failed " + eMAError.errCode() + ", " + eMAError.errMsg());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "destroyConference success!");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(null);
                    }
                }
            }
        });
    }

    public void exitConference(final EMValueCallBack eMValueCallBack) {
        EMLog.d(this.TAG, "Exit conference - async");
        this.mediaManager.exit(this.mediaSession, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Exit conference failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Exit conference success");
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess(null);
                    }
                }
                EMConferenceManager.this.memberList.clear();
                EMConferenceManager.this.subscribedStreamMap.clear();
                EMConferenceManager.this.availableStreamMap.clear();
            }
        });
    }

    public void publish(EMStreamParam eMStreamParam, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Publish local stream");
        this.mediaManager.publish(this.mediaSession, this.configWrap(eMStreamParam), new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Publish failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Publish success Stream id - " + object);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void unpublish(String string, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "UNPublish local stream - async");
        this.mediaManager.unpublish(this.mediaSession, string, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Unpublish failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Unpublish success Stream id - " + object);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void subscribe(final EMConferenceStream eMConferenceStream, EMCallSurfaceView eMCallSurfaceView, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Subscribe stream - async " + eMConferenceStream.toString());
        VideoViewRenderer videoViewRenderer = eMCallSurfaceView != null ? eMCallSurfaceView.getRenderer() : null;
        this.mediaManager.subscribe(this.mediaSession, eMConferenceStream.getStreamId(), videoViewRenderer, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Subscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Subscribe success Stream id - " + object);
                    EMConferenceManager.this.subscribedStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.availableStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void updateSubscribe(final EMConferenceStream eMConferenceStream, EMCallSurfaceView eMCallSurfaceView, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "Update subscribe stream - async " + eMConferenceStream.toString());
        VideoViewRenderer videoViewRenderer = eMCallSurfaceView != null ? eMCallSurfaceView.getRenderer() : null;
        this.mediaManager.updateSubscribe(this.mediaSession, eMConferenceStream.getStreamId(), videoViewRenderer, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Update subscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Update subscribe success Stream id - " + object);
                    EMConferenceManager.this.subscribedStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.availableStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void unsubscribe(final EMConferenceStream eMConferenceStream, final EMValueCallBack<String> eMValueCallBack) {
        EMLog.d(this.TAG, "UNSubscribe stream - async " + eMConferenceStream.toString());
        this.mediaManager.unsubscribe(this.mediaSession, eMConferenceStream.getStreamId(), new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                if (eMediaError != null) {
                    EMLog.d(EMConferenceManager.this.TAG, "Unsubscribe failed code=" + (Object)((Object)eMediaError.code) + ", desc=" + eMediaError.errorDescription);
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onError(EMConferenceManager.this.errorMap(eMediaError.code.errorcode), eMediaError.errorDescription);
                    }
                } else {
                    EMLog.d(EMConferenceManager.this.TAG, "Unsubscribe success Stream id - " + object);
                    EMConferenceManager.this.availableStreamMap.put(eMConferenceStream.getStreamId(), eMConferenceStream);
                    EMConferenceManager.this.subscribedStreamMap.remove(eMConferenceStream.getStreamId());
                    if (eMValueCallBack != null) {
                        eMValueCallBack.onSuccess((String)object);
                    }
                }
            }
        });
    }

    public void inputExternalVideoData(Bitmap bitmap) {
        this.mediaManager.inputExternalVideoData(bitmap);
    }

    public void inputExternalVideoData(byte[] byArray, int n, int n2, int n3) {
        this.mediaManager.inputExternalVideoData(byArray, n, n2, n3);
    }

    public void startMonitorSpeaker(int n) {
        this.mediaManager.setAudioTalkerInterval(n, new EMediaEntities.EMediaIdBlockType(){

            @Override
            public void onDone(Object object, EMediaEntities.EMediaError eMediaError) {
                EMLog.d(EMConferenceManager.this.TAG, "error: " + (Object)((Object)eMediaError.code) + " desc:" + eMediaError.errorDescription);
            }
        });
    }

    public void stopMonitorSpeaker() {
        this.mediaManager.stopAudioTalker();
    }

    public void setConferenceMode(EMConferenceListener.ConferenceMode conferenceMode) {
        this.conferenceMode = conferenceMode;
        this.setSubscribeAudioMixEnable();
    }

    private void setSubscribeAudioMixEnable() {
        if (this.conferenceMode == EMConferenceListener.ConferenceMode.LARGE) {
            this.mediaManager.setSubscribeAudioMixEnabled(false);
        } else {
            this.mediaManager.setSubscribeAudioMixEnabled(true);
        }
    }

    public void setLocalSurfaceView(EMCallSurfaceView eMCallSurfaceView) {
        VideoViewRenderer videoViewRenderer = null;
        if (eMCallSurfaceView != null) {
            videoViewRenderer = eMCallSurfaceView.getRenderer();
        }
        this.mediaManager.setLocalPreviewView(videoViewRenderer);
    }

    public void updateLocalSurfaceView(EMCallSurfaceView eMCallSurfaceView) {
        this.mediaManager.setVideoViews(null, eMCallSurfaceView.getRenderer(), null, true);
    }

    public void updateRemoteSurfaceView(String string, EMCallSurfaceView eMCallSurfaceView) {
        this.mediaManager.setVideoViews(string, null, eMCallSurfaceView.getRenderer(), false);
    }

    public int getCameraId() {
        return this.mediaManager.getCameraFacing();
    }

    public void switchCamera() {
        this.mediaManager.switchCamera();
    }

    public void closeVideoTransfer() {
        this.mediaManager.setVideoEnabled(false);
    }

    public void openVideoTransfer() {
        this.mediaManager.setVideoEnabled(true);
    }

    public void closeVoiceTransfer() {
        this.mediaManager.setMuteEnabled(true);
    }

    public void openVoiceTransfer() {
        this.mediaManager.setMuteEnabled(false);
    }

    public void enableStatistics(boolean bl) {
        if (this.mediaSession != null) {
            this.mediaManager.enableStatistics(this.mediaSession, bl);
        } else {
            EMLog.e(this.TAG, "Conference no start");
        }
    }

    public List<EMConferenceMember> getConferenceMemberList() {
        return this.memberList;
    }

    public Map<String, EMConferenceStream> getAvailableStreamMap() {
        return this.availableStreamMap;
    }

    public Map<String, EMConferenceStream> getSubscribedStreamMap() {
        return this.subscribedStreamMap;
    }

    private EMediaPublishConfiguration configWrap(EMStreamParam eMStreamParam) {
        EMediaPublishConfiguration eMediaPublishConfiguration = null;
        if (eMStreamParam == null) {
            return eMediaPublishConfiguration;
        }
        eMediaPublishConfiguration = eMStreamParam.streamType == EMConferenceStream.StreamType.NORMAL ? (this.conferenceMode == EMConferenceListener.ConferenceMode.LARGE ? EMediaPublishConfiguration.initAudioMixConfig() : EMediaPublishConfiguration.initNormalConfig()) : EMediaPublishConfiguration.initDesktopConfig();
        eMediaPublishConfiguration.setExtension(eMStreamParam.extension);
        eMediaPublishConfiguration.setMute(eMStreamParam.audioOff);
        eMediaPublishConfiguration.setVideoOff(eMStreamParam.videoOff);
        eMediaPublishConfiguration.setVwidth(eMStreamParam.videoWidth);
        eMediaPublishConfiguration.setVheight(eMStreamParam.videoHeight);
        eMediaPublishConfiguration.setPubView(eMStreamParam.shareView);
        eMediaPublishConfiguration.setUseBackCamera(eMStreamParam.useBackCamera);
        eMediaPublishConfiguration.setMaxVideoKbps(eMStreamParam.maxVideoKbps);
        eMediaPublishConfiguration.setMaxAudioKbps(eMStreamParam.maxAudioKbps);
        RtcConnection.enableFixedVideoResolution(eMStreamParam.enableFixedVideoResolution);
        RtcConnection.setMinVideoKbps(eMStreamParam.minVideoKbps);
        RtcConnection.setAudioSampleRate(eMStreamParam.audioSampleRate);
        return eMediaPublishConfiguration;
    }

    private static JSONObject convertMapToJSONObject(Map<String, Object> map) {
        JSONObject jSONObject = new JSONObject();
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            Object object;
            Object object2 = entry.getValue();
            if (object2 instanceof Map) {
                object = EMConferenceManager.convertMapToJSONObject((Map)object2);
            } else if (object2 instanceof List) {
                object = new JSONArray();
                for (Object e2 : (List)object2) {
                    ((JSONArray)object).put(e2);
                }
            } else if (object2 instanceof Object[]) {
                object = new JSONArray();
                for (Object object3 : (Object[])object2) {
                    ((JSONArray)object).put(object3);
                }
            } else {
                object = object2;
            }
            try {
                jSONObject.put(entry.getKey(), object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    private EMConferenceMember memberContains(String string) {
        for (EMConferenceMember eMConferenceMember : this.memberList) {
            if (!eMConferenceMember.memberName.equals(string)) continue;
            return eMConferenceMember;
        }
        return null;
    }

    private int errorMap(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case -1: {
                n2 = 1;
                break;
            }
            case -102: {
                n2 = 818;
                break;
            }
            case -106: {
                n2 = 805;
                break;
            }
            case -108: {
                n2 = 2;
                break;
            }
            case -109: {
                n2 = 803;
                break;
            }
            case -112: {
                n2 = 819;
                break;
            }
            case -113: {
                n2 = 820;
                break;
            }
            case -122: {
                n2 = 806;
                break;
            }
            case -123: {
                n2 = 807;
                break;
            }
            case -124: {
                n2 = 808;
                break;
            }
            case -142: {
                n2 = 809;
                break;
            }
            case -143: {
                n2 = 810;
                break;
            }
            case -144: {
                n2 = 811;
                break;
            }
            case -145: {
                n2 = 812;
                break;
            }
            case -404: {
                n2 = 803;
                break;
            }
            case -410: {
                n2 = 821;
                break;
            }
            case -411: {
                n2 = 822;
                break;
            }
            case -500: {
                n2 = 813;
                break;
            }
            case -502: {
                n2 = 814;
                break;
            }
            case -504: {
                n2 = 815;
                break;
            }
            case -506: {
                n2 = 816;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private EMConferenceListener.ConferenceState stateMap(int n) {
        EMConferenceListener.ConferenceState conferenceState;
        switch (n) {
            case 0: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NORMAL;
                break;
            }
            case 100: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_STATISTICS;
                break;
            }
            case 120: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_DISCONNECTION;
                break;
            }
            case 121: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_RECONNECTION;
                break;
            }
            case 122: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_POOR_QUALITY;
                break;
            }
            case 123: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_PUBLISH_SETUP;
                break;
            }
            case 124: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_SUBSCRIBE_SETUP;
                break;
            }
            case 125: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_TAKE_CAMERA_PICTURE;
                break;
            }
            case 126: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_CUSTOM_MSG;
                break;
            }
            case 131: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_AUDIO_TALKERS;
                break;
            }
            case 181: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_P2P_PEER_EXIT;
                break;
            }
            case 201: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_OPEN_CAMERA_FAIL;
                break;
            }
            case 202: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_OPEN_MIC_FAIL;
                break;
            }
            default: {
                conferenceState = EMConferenceListener.ConferenceState.STATE_NORMAL;
            }
        }
        return conferenceState;
    }

    public static enum EMConferenceType {
        SmallCommunication(10),
        LargeCommunication(11),
        LiveStream(12);

        public int code;

        private EMConferenceType(int n2) {
            this.code = n2;
        }

        static EMConferenceType from(int n) {
            switch (n) {
                case 10: {
                    return SmallCommunication;
                }
                case 11: {
                    return LargeCommunication;
                }
                case 12: {
                    return LiveStream;
                }
            }
            return null;
        }
    }

    public static enum EMConferenceRole {
        Admin(7),
        Talker(3),
        Audience(1);

        public int code;

        private EMConferenceRole(int n2) {
            this.code = n2;
        }

        static EMConferenceRole from(int n) {
            switch (n) {
                case 1: {
                    return Audience;
                }
                case 3: {
                    return Talker;
                }
                case 7: {
                    return Admin;
                }
            }
            return null;
        }
    }

    static class Role {
        private EMConferenceRole role = EMConferenceRole.Audience;
        private String roleToken;

        Role() {
        }

        public Role updateRole(EMConferenceRole eMConferenceRole) {
            this.role = eMConferenceRole;
            return this;
        }

        public Role updateToken(String string) {
            this.roleToken = string;
            return this;
        }

        public void update(EMConferenceRole eMConferenceRole, String string) {
            this.role = eMConferenceRole;
            this.roleToken = string;
        }

        public EMConferenceRole getRole() {
            return this.role;
        }

        public String getRoleToken() {
            return this.roleToken;
        }
    }
}

