/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.annotation.SuppressLint;
import com.hyphenate.chat.EMPushHelper.EMPushType;
import com.hyphenate.util.EMLog;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.IBinder;

import com.hyphenate.chat.EMPushHelper.EMPushType;
import com.hyphenate.util.EMLog;

/**
 * \~chinese
 * sdk keep alive service
 *
 * \~english
 * sdk keep alive service
 */
@SuppressLint("Registered")
public class EMChatService extends Service {

	private final static String TAG = "chatservice";

	public class LocalBinder extends Binder {
		EMChatService getService() {
			return EMChatService.this;
		}
	}

	public void onCreate() {
		super.onCreate();
		EMLog.i(TAG, "chat service created");
	}


	public int onStartCommand(Intent _intent, int flags, int startId) {
        final Intent intent = _intent;

		if(intent != null){
			if (EMPushHelper.getInstance().getPushType() == EMPushType.NORMAL) {
				if(!EMMonitor.getInstance().isStarted()){
				    //直接在runnable里getname得到的是匿名内部类
				    final String serviceName = getClass().getName();
					//避免频繁创建线程
					new Thread(new Runnable() {
						@Override
						public void run() {
							try {
								String reason = "";
								if(intent.hasExtra("reason")){
								    reason = intent.getStringExtra("reason");
								}
								//start方法里已做重复start的判断
								EMMonitor.getInstance().start(EMChatService.this, getPackageName() + "/" + serviceName);

								EMMonitor.getInstance().startWakeup(EMChatService.this, reason);
							} catch (Exception e) {
								e.printStackTrace();
							}
						}
					}).start();
				}
			}
		}

		if(EMPushHelper.getInstance().getPushType() == EMPushType.FCM){
		    //考虑到现在实时通话还不支持推送消息，尽量保持service
			EMLog.d(TAG, "start not sticky!");
			return Service.START_NOT_STICKY;
		} else {
			EMLog.d(TAG, "start sticky!");
			return Service.START_STICKY;
		}
	}

	@Override
	public void onDestroy() {
		EMLog.d(TAG, "onDestroy");

		if(EMPushHelper.getInstance().getPushType() == EMPushType.NORMAL){
			new Thread(new Runnable() {

				@Override
				public void run() {
					try {
						if(!EMClient.getInstance().stopService){
							EMClient.getInstance().doStartService();
						}
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}).start();
		}
	}
	
	@Override
	public IBinder onBind(Intent intent) {
		EMLog.d(TAG, "onBind");
		return mBinder;
	}

	@Override
	public boolean onUnbind(Intent intent) {
		return true;
	}

	// This is the object that receives interactions from clients. See
	// RemoteService for a more complete example.
	private final IBinder mBinder = new LocalBinder();

}
