/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime;

import internal.org.apache.http.entity.mime.Header;
import internal.org.apache.http.entity.mime.MinimalField;
import internal.org.apache.http.entity.mime.content.ContentBody;

public class FormBodyPart {
    private final String name;
    private final Header header;
    private final ContentBody body;

    public FormBodyPart(String string, ContentBody contentBody) {
        if (string == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        if (contentBody == null) {
            throw new IllegalArgumentException("Body may not be null");
        }
        this.name = string;
        this.body = contentBody;
        this.header = new Header();
        this.generateContentDisp(contentBody);
        this.generateContentType(contentBody);
        this.generateTransferEncoding(contentBody);
    }

    public String getName() {
        return this.name;
    }

    public ContentBody getBody() {
        return this.body;
    }

    public Header getHeader() {
        return this.header;
    }

    public void addField(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Field name may not be null");
        }
        this.header.addField(new MinimalField(string, string2));
    }

    protected void generateContentDisp(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("form-data; name=\"");
        stringBuilder.append(this.getName());
        stringBuilder.append("\"");
        if (contentBody.getFilename() != null) {
            stringBuilder.append("; filename=\"");
            stringBuilder.append(contentBody.getFilename());
            stringBuilder.append("\"");
        }
        this.addField("Content-Disposition", stringBuilder.toString());
    }

    protected void generateContentType(ContentBody contentBody) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(contentBody.getMimeType());
        if (contentBody.getCharset() != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(contentBody.getCharset());
        }
        this.addField("Content-Type", stringBuilder.toString());
    }

    protected void generateTransferEncoding(ContentBody contentBody) {
        this.addField("Content-Transfer-Encoding", contentBody.getTransferEncoding());
    }
}

