/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import com.superrtc.call.Logging;
import com.superrtc.call.NetworkMonitorAutoDetect;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetworkMonitor {
    private static final String TAG = "NetworkMonitor";
    private static NetworkMonitor instance;
    private final Context applicationContext;
    private final ArrayList<Long> nativeNetworkObservers;
    private final ArrayList<NetworkObserver> networkObservers;
    private NetworkMonitorAutoDetect autoDetector;
    private NetworkMonitorAutoDetect.ConnectionType currentConnectionType = NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN;

    private NetworkMonitor(Context context) {
        NetworkMonitor.assertIsTrue(context != null);
        this.applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        this.nativeNetworkObservers = new ArrayList();
        this.networkObservers = new ArrayList();
    }

    public static NetworkMonitor init(Context context) {
        if (!NetworkMonitor.isInitialized()) {
            instance = new NetworkMonitor(context);
        }
        return instance;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static NetworkMonitor getInstance() {
        return instance;
    }

    public static void setAutoDetectConnectivityState(boolean bl) {
        NetworkMonitor.getInstance().setAutoDetectConnectivityStateInternal(bl);
    }

    private static void assertIsTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected to be true");
        }
    }

    private void startMonitoring(long l) {
        Logging.d(TAG, "Start monitoring from native observer " + l);
        this.nativeNetworkObservers.add(l);
        this.setAutoDetectConnectivityStateInternal(true);
    }

    private void stopMonitoring(long l) {
        Logging.d(TAG, "Stop monitoring from native observer " + l);
        this.setAutoDetectConnectivityStateInternal(false);
        this.nativeNetworkObservers.remove(l);
    }

    private NetworkMonitorAutoDetect.ConnectionType getCurrentConnectionType() {
        return this.currentConnectionType;
    }

    private int getCurrentDefaultNetId() {
        return this.autoDetector == null ? -1 : this.autoDetector.getDefaultNetId();
    }

    private void destroyAutoDetector() {
        if (this.autoDetector != null) {
            this.autoDetector.destroy();
            this.autoDetector = null;
        }
    }

    private void setAutoDetectConnectivityStateInternal(boolean bl) {
        if (!bl) {
            this.destroyAutoDetector();
            return;
        }
        if (this.autoDetector == null) {
            this.autoDetector = new NetworkMonitorAutoDetect(new NetworkMonitorAutoDetect.Observer(){

                @Override
                public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                    NetworkMonitor.this.updateCurrentConnectionType(connectionType);
                }

                @Override
                public void onNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
                    NetworkMonitor.this.notifyObserversOfNetworkConnect(networkInformation);
                }

                @Override
                public void onNetworkDisconnect(int n) {
                    NetworkMonitor.this.notifyObserversOfNetworkDisconnect(n);
                }
            }, this.applicationContext);
            NetworkMonitorAutoDetect.NetworkState networkState = this.autoDetector.getCurrentNetworkState();
            this.updateCurrentConnectionType(NetworkMonitorAutoDetect.getConnectionType(networkState));
            this.updateActiveNetworkList();
        }
    }

    private void updateCurrentConnectionType(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        this.currentConnectionType = connectionType;
        this.notifyObserversOfConnectionTypeChange(connectionType);
    }

    private void notifyObserversOfConnectionTypeChange(NetworkMonitorAutoDetect.ConnectionType connectionType) {
        Iterator<Object> iterator = this.nativeNetworkObservers.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            this.nativeNotifyConnectionTypeChanged(l);
        }
        for (NetworkObserver networkObserver : this.networkObservers) {
            networkObserver.onConnectionTypeChanged(connectionType);
        }
    }

    private void notifyObserversOfNetworkConnect(NetworkMonitorAutoDetect.NetworkInformation networkInformation) {
        for (long l : this.nativeNetworkObservers) {
            this.nativeNotifyOfNetworkConnect(l, networkInformation);
        }
    }

    private void notifyObserversOfNetworkDisconnect(int n) {
        for (long l : this.nativeNetworkObservers) {
            this.nativeNotifyOfNetworkDisconnect(l, n);
        }
    }

    private void updateActiveNetworkList() {
        List<NetworkMonitorAutoDetect.NetworkInformation> list = this.autoDetector.getActiveNetworkList();
        if (list == null || list.size() == 0) {
            return;
        }
        NetworkMonitorAutoDetect.NetworkInformation[] networkInformationArray = new NetworkMonitorAutoDetect.NetworkInformation[list.size()];
        networkInformationArray = list.toArray(networkInformationArray);
        for (long l : this.nativeNetworkObservers) {
            this.nativeNotifyOfActiveNetworkList(l, networkInformationArray);
        }
    }

    public static void addNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().addNetworkObserverInternal(networkObserver);
    }

    private void addNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.add(networkObserver);
    }

    public static void removeNetworkObserver(NetworkObserver networkObserver) {
        NetworkMonitor.getInstance().removeNetworkObserverInternal(networkObserver);
    }

    private void removeNetworkObserverInternal(NetworkObserver networkObserver) {
        this.networkObservers.remove(networkObserver);
    }

    public static boolean isOnline() {
        NetworkMonitorAutoDetect.ConnectionType connectionType = NetworkMonitor.getInstance().getCurrentConnectionType();
        return connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_UNKNOWN && connectionType != NetworkMonitorAutoDetect.ConnectionType.CONNECTION_NONE;
    }

    private native void nativeNotifyConnectionTypeChanged(long var1);

    private native void nativeNotifyOfNetworkConnect(long var1, NetworkMonitorAutoDetect.NetworkInformation var3);

    private native void nativeNotifyOfNetworkDisconnect(long var1, int var3);

    private native void nativeNotifyOfActiveNetworkList(long var1, NetworkMonitorAutoDetect.NetworkInformation[] var3);

    static void resetInstanceForTests(Context context) {
        instance = new NetworkMonitor(context);
    }

    public static NetworkMonitorAutoDetect getAutoDetectorForTest() {
        return NetworkMonitor.getInstance().autoDetector;
    }

    public static interface NetworkObserver {
        public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType var1);
    }
}

