/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.Process;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.hyphenate.EMCallBack;
import com.hyphenate.EMClientListener;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMMultiDeviceListener;
import com.hyphenate.a.a;
import com.hyphenate.analytics.EMTimeTag;
import com.hyphenate.chat.EMCallManager;
import com.hyphenate.chat.EMChatManager;
import com.hyphenate.chat.EMChatRoomManager;
import com.hyphenate.chat.EMChatService;
import com.hyphenate.chat.EMCheckType;
import com.hyphenate.chat.EMConferenceManager;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMContactManager;
import com.hyphenate.chat.EMDeviceInfo;
import com.hyphenate.chat.EMEncryptProvider;
import com.hyphenate.chat.EMExtraService;
import com.hyphenate.chat.EMGroupManager;
import com.hyphenate.chat.EMJobService;
import com.hyphenate.chat.EMMonitor;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.EMPushHelper;
import com.hyphenate.chat.EMPushManager;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMSmartHeartBeat;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAConnectionListener;
import com.hyphenate.chat.adapter.EMADeviceInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAMultiDeviceListener;
import com.hyphenate.chat.adapter.EMANetCallback;
import com.hyphenate.chat.core.EMAdvanceDebugManager;
import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.chat.core.EMDBManager;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.CryptoUtils;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.Utils;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class EMClient {
    public static final String TAG = "EMClient";
    private static EMClient instance = null;
    static boolean libraryLoaded = false;
    private EMGroupManager groupManager;
    private EMChatRoomManager chatroomManager;
    private EMChatManager chatManager;
    private EMContactManager contactManager;
    private EMCallManager callManager;
    private EMConferenceManager conferenceManager;
    private EMPushManager pushManager;
    private EMAChatClient emaObject;
    private Context mContext;
    private ExecutorService executor = null;
    private ExecutorService mainQueue = Executors.newSingleThreadExecutor();
    private ExecutorService sendQueue = Executors.newSingleThreadExecutor();
    private EMEncryptProvider encryptProvider = null;
    private CryptoUtils cryptoUtils = new CryptoUtils();
    private boolean sdkInited = false;
    private EMChatConfigPrivate mChatConfigPrivate;
    private List<EMConnectionListener> connectionListeners = Collections.synchronizedList(new ArrayList());
    private MyConnectionListener connectionListener = new MyConnectionListener();
    private EMSmartHeartBeat smartHeartbeat = null;
    private List<EMClientListener> clientListeners = Collections.synchronizedList(new ArrayList());
    private List<EMMultiDeviceListener> multiDeviceListeners = Collections.synchronizedList(new ArrayList());
    private MyMultiDeviceListener multiDeviceListenerImpl = new MyMultiDeviceListener();
    private PowerManager.WakeLock wakeLock;
    private ConnectivityManager connManager;
    private EMAChatClient.EMANetwork currentNetworkType = EMAChatClient.EMANetwork.NETWORK_NONE;
    public static final String VERSION = "3.4.2";
    private static final int JOB_ID = 11;
    private static final int JOB_INTERVAL = 60000;
    boolean stopService;
    private BroadcastReceiver connectivityBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int n;
            String string = intent.getAction();
            if (!string.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                EMLog.d(EMClient.TAG, "skip no connectivity action");
                return;
            }
            EMLog.d(EMClient.TAG, "connectivity receiver onReceiver");
            EMAChatClient.EMANetwork eMANetwork = EMAChatClient.EMANetwork.NETWORK_NONE;
            NetworkInfo networkInfo = EMClient.this.connManager.getActiveNetworkInfo();
            EMLog.i(EMClient.TAG, "Active Network info: " + (networkInfo == null ? "null" : networkInfo.toString()));
            if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                n = networkInfo.getType();
                if (n == 1) {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_WIFI;
                } else if (n == 0) {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_MOBILE;
                } else if (n == 9) {
                    eMANetwork = EMAChatClient.EMANetwork.NETWORK_CABLE;
                }
            }
            n = EMClient.this.currentNetworkType != EMAChatClient.EMANetwork.NETWORK_NONE ? 1 : 0;
            int n2 = eMANetwork != EMAChatClient.EMANetwork.NETWORK_NONE ? 1 : 0;
            EMClient.this.currentNetworkType = eMANetwork;
            if (n == n2) {
                EMLog.i(EMClient.TAG, "Network availability no change, just return. " + (Object)((Object)EMClient.this.currentNetworkType));
                return;
            }
            EMLog.i(EMClient.TAG, "Network availability changed, notify... " + (Object)((Object)EMClient.this.currentNetworkType));
            EMClient.this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.emaObject.onNetworkChanged(EMClient.this.currentNetworkType);
                }
            });
        }
    };
    private AppStateListener appStateListener;
    private int activitySize = 0;
    private boolean duringChecking = false;

    private EMClient() {
    }

    public static EMClient getInstance() {
        if (instance == null) {
            EMClient.loadLibrary();
            instance = new EMClient();
        }
        return instance;
    }

    public void init(Context context, EMOptions eMOptions) {
        if (this.sdkInited) {
            return;
        }
        final EMTimeTag eMTimeTag = new EMTimeTag();
        eMTimeTag.start();
        this.mContext = context.getApplicationContext();
        this.connManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.registerActivityLifecycleCallbacks();
        this.mChatConfigPrivate = new EMChatConfigPrivate();
        this.mChatConfigPrivate.a(context, eMOptions);
        eMOptions.setConfig(this.mChatConfigPrivate);
        DeviceUuidFactory deviceUuidFactory = new DeviceUuidFactory(EMClient.getInstance().getContext());
        this.getChatConfigPrivate().f(deviceUuidFactory.getDeviceUuid().toString());
        this.getChatConfigPrivate().g(Build.MANUFACTURER + Build.MODEL);
        this.emaObject = EMAChatClient.create(this.mChatConfigPrivate.a);
        this.emaObject.addConnectionListener(this.connectionListener);
        this.emaObject.addMultiDeviceListener(this.multiDeviceListenerImpl);
        this.executor = Executors.newCachedThreadPool();
        this.cryptoUtils.init(1);
        this.initManagers();
        final String string = EMSessionManager.getInstance().getLastLoginUser();
        EMLog.e(TAG, "is autoLogin : " + eMOptions.getAutoLogin());
        EMLog.e(TAG, "lastLoginUser : " + string);
        EMLog.e(TAG, "hyphenate SDK is initialized with version : " + this.getChatConfigPrivate().e());
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        this.wakeLock = powerManager.newWakeLock(1, "emclient");
        this.sdkInited = true;
        if (eMOptions.getAutoLogin() && this.isLoggedInBefore()) {
            final String string2 = EMSessionManager.getInstance().getLastLoginToken();
            final String string3 = EMSessionManager.getInstance().getLastLoginPwd();
            EMSessionManager.getInstance().currentUser = new EMContact(string);
            final EMCallBack eMCallBack = new EMCallBack(){

                @Override
                public void onSuccess() {
                    EMSessionManager.getInstance().currentUser = new EMContact(string);
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onSuccess");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onError(int n, String string2) {
                    Log.d((String)EMClient.TAG, (String)"hyphenate login onError");
                    eMTimeTag.stop();
                    EMLog.d(EMClient.TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
                }

                @Override
                public void onProgress(int n, String string2) {
                }
            };
            this.execute(new Runnable(){

                @Override
                public void run() {
                    EMClient.this.getChatConfigPrivate().b(string);
                    EMClient.this.groupManager().loadAllGroups();
                    EMClient.this.chatManager().loadAllConversationsFromDB();
                    EMClient.this._login(string, EMSessionManager.getInstance().isLastLoginWithToken() ? string2 : string3, eMCallBack, true, EMSessionManager.getInstance().isLastLoginWithToken());
                }
            });
        } else {
            eMTimeTag.stop();
            EMLog.d(TAG, "[Collector][sdk init]init time is : " + eMTimeTag.timeStr());
        }
    }

    public void createAccount(String string, String string2) throws HyphenateException {
        string = string.toLowerCase();
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]+$");
        boolean bl = pattern.matcher(string).find();
        if (!bl) {
            throw new HyphenateException(205, "illegal user name");
        }
        EMAError eMAError = this.emaObject.createAccount(string, string2);
        this.handleError(eMAError);
    }

    public void login(String string, String string2, EMCallBack eMCallBack) throws IllegalArgumentException {
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().l())) {
            throw new IllegalArgumentException("please setup your appkey either in AndroidManifest.xml or through the EMOptions");
        }
        if (!this.sdkInited) {
            eMCallBack.onError(1, "sdk not initialized");
            return;
        }
        string = string.toLowerCase();
        this._login(string, string2, eMCallBack, false, false);
    }

    public void loginWithToken(String string, String string2, EMCallBack eMCallBack) {
        if (TextUtils.isEmpty((CharSequence)this.getChatConfigPrivate().l())) {
            throw new RuntimeException("please setup your appkey either in AndroidManifest.xml or through the EMOptions");
        }
        if (eMCallBack == null) {
            throw new IllegalArgumentException("callback is null!");
        }
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            throw new IllegalArgumentException("username or password is null or empty!");
        }
        if (!this.sdkInited) {
            eMCallBack.onError(1, "sdk not initialized");
            return;
        }
        string = string.toLowerCase();
        this._login(string, string2, eMCallBack, false, true);
    }

    public int logout(boolean bl) {
        try {
            EMPushHelper.getInstance().onDestroy(bl);
        }
        catch (HyphenateException hyphenateException) {
            hyphenateException.printStackTrace();
            return 212;
        }
        this.logout();
        return 0;
    }

    void logout() {
        EMLog.d(TAG, " SDK Logout");
        try {
            if (this.connectivityBroadcastReceiver != null) {
                this.mContext.unregisterReceiver(this.connectivityBroadcastReceiver);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EMSessionManager.getInstance().clearLastLoginUser();
        EMSessionManager.getInstance().clearLastLoginToken();
        if (this.smartHeartbeat != null) {
            this.smartHeartbeat.stop();
        }
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
        if (this.emaObject != null) {
            this.emaObject.logout();
        }
        if (this.chatManager != null) {
            this.chatManager.onLogout();
        }
        if (this.groupManager != null) {
            this.groupManager.onLogout();
        }
        if (this.contactManager != null) {
            this.contactManager.onLogout();
        }
        if (this.chatroomManager != null) {
            this.chatroomManager.onLogout();
        }
        try {
            EMAdvanceDebugManager.a().f();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (EMChatConfigPrivate.a()) {
            a.c();
        }
        if (this.mContext != null) {
            EMMonitor.getInstance().getMonitorDB().b(this.mContext.getPackageName());
        }
        this.cancelJob();
        this.doStopService();
    }

    public void logout(final boolean bl, final EMCallBack eMCallBack) {
        new Thread(){

            @Override
            public void run() {
                int n = EMClient.this.logout(bl);
                if (n != 0) {
                    if (eMCallBack != null) {
                        eMCallBack.onError(n, "faild to unbind device token");
                    }
                } else if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        }.start();
    }

    void logout(final EMCallBack eMCallBack) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (eMCallBack != null) {
                    eMCallBack.onProgress(0, null);
                }
                EMClient.this.logout();
                if (eMCallBack != null) {
                    eMCallBack.onSuccess();
                }
            }
        };
        thread.setPriority(9);
        thread.start();
    }

    public void changeAppkey(String string) throws HyphenateException {
        EMAError eMAError = this.emaObject.changeAppkey(string);
        if (eMAError.errCode() == 0) {
            this.getOptions().updatePath(string);
        }
        this.handleError(eMAError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(final EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            if (!this.connectionListeners.contains(eMConnectionListener)) {
                this.connectionListeners.add(eMConnectionListener);
            }
        }
        this.execute(new Runnable(){

            @Override
            public void run() {
                if (EMClient.this.isConnected()) {
                    eMConnectionListener.onConnected();
                } else {
                    eMConnectionListener.onDisconnected(2);
                }
            }
        });
    }

    public void addClientListener(EMClientListener eMClientListener) {
        this.clientListeners.add(eMClientListener);
    }

    public void removeClientListener(EMClientListener eMClientListener) {
        this.clientListeners.remove(eMClientListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(EMConnectionListener eMConnectionListener) {
        if (eMConnectionListener == null) {
            return;
        }
        List<EMConnectionListener> list = this.connectionListeners;
        synchronized (list) {
            this.connectionListeners.remove(eMConnectionListener);
        }
    }

    public EMGroupManager groupManager() {
        if (this.groupManager == null) {
            this.groupManager = new EMGroupManager(this, this.emaObject.getGroupManager());
        }
        return this.groupManager;
    }

    public EMPushManager pushManager() {
        if (this.pushManager == null) {
            this.pushManager = new EMPushManager(this, this.emaObject.getPushMnager());
        }
        return this.pushManager;
    }

    public EMChatRoomManager chatroomManager() {
        if (this.chatroomManager == null) {
            this.chatroomManager = new EMChatRoomManager(this, this.emaObject.getChatRoomManager());
        }
        return this.chatroomManager;
    }

    public EMChatManager chatManager() {
        if (this.chatManager == null) {
            this.chatManager = new EMChatManager(this, this.emaObject.getChatManager());
        }
        return this.chatManager;
    }

    public EMContactManager contactManager() {
        if (this.contactManager == null) {
            this.contactManager = new EMContactManager(this, this.emaObject.getContactManager());
        }
        return this.contactManager;
    }

    public EMCallManager callManager() {
        if (this.callManager == null) {
            this.callManager = new EMCallManager(this, this.emaObject.getCallManager());
        }
        return this.callManager;
    }

    public EMConferenceManager conferenceManager() {
        if (this.conferenceManager == null) {
            this.conferenceManager = new EMConferenceManager(this.emaObject.getCallManager());
        }
        return this.conferenceManager;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getCurrentUser() {
        if (EMSessionManager.getInstance().currentUser == null || EMSessionManager.getInstance().currentUser.username == null || EMSessionManager.getInstance().currentUser.username.equals("")) {
            return EMSessionManager.getInstance().getLastLoginUser();
        }
        return EMSessionManager.getInstance().currentUser.username;
    }

    public boolean isLoggedInBefore() {
        EMSessionManager eMSessionManager = EMSessionManager.getInstance();
        String string = eMSessionManager.getLastLoginUser();
        String string2 = eMSessionManager.getLastLoginPwd();
        String string3 = eMSessionManager.getLastLoginToken();
        return string != null && !string.isEmpty() && (string2 != null && !string2.isEmpty() || string3 != null && !string3.isEmpty());
    }

    public boolean isConnected() {
        return this.emaObject.isConnected();
    }

    public void setDebugMode(boolean bl) {
        String string;
        if (this.sdkInited && (string = EMAdvanceDebugManager.a().e()) != null) {
            bl = Boolean.parseBoolean(string);
        }
        EMLog.debugMode = bl;
        this.getChatConfigPrivate().c(bl);
    }

    @Deprecated
    public boolean updateCurrentUserNick(String string) {
        return this.pushManager().updatePushNickname(string);
    }

    public void uploadLog(EMCallBack eMCallBack) {
        this.chatManager().emaObject.uploadLog();
    }

    public List<EMContact> getRobotsFromServer() throws HyphenateException {
        return EMExtraService.getInstance().getRobotsFromServer();
    }

    public EMOptions getOptions() {
        return this.mChatConfigPrivate.b();
    }

    public String compressLogs() throws HyphenateException {
        EMAError eMAError = new EMAError();
        String string = this.emaObject.compressLogs(eMAError);
        this.handleError(eMAError);
        return string;
    }

    public void addMultiDeviceListener(EMMultiDeviceListener eMMultiDeviceListener) {
        this.multiDeviceListeners.add(eMMultiDeviceListener);
    }

    public void removeMultiDeviceListener(EMMultiDeviceListener eMMultiDeviceListener) {
        this.multiDeviceListeners.remove(eMMultiDeviceListener);
    }

    public List<EMDeviceInfo> getLoggedInDevicesFromServer(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMADeviceInfo> list = this.emaObject.getLoggedInDevicesFromServer(string, string2, eMAError);
        this.handleError(eMAError);
        ArrayList<EMDeviceInfo> arrayList = new ArrayList<EMDeviceInfo>();
        for (EMADeviceInfo eMADeviceInfo : list) {
            arrayList.add(new EMDeviceInfo(eMADeviceInfo));
        }
        return arrayList;
    }

    public void kickDevice(String string, String string2, String string3) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickDevice(string, string2, string3, eMAError);
        this.handleError(eMAError);
    }

    public void kickAllDevices(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.kickAllDevices(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void sendFCMTokenToServer(String string) {
        String string2;
        EMLog.i(TAG, "sendFCMTokenToServer: " + string);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        String string3 = EMPushHelper.getInstance().getFCMPushToken();
        if (!string.equals(string3)) {
            EMPushHelper.getInstance().setFCMPushToken(string);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.getCurrentUser()))) {
            EMLog.i(TAG, "No user login currently, stop upload the token.");
            return;
        }
        boolean bl = EMPushHelper.getInstance().checkAvailablePushService();
        EMLog.i(TAG, "pushServiceAvailable: " + bl);
        if (bl) {
            boolean bl2 = EMPushHelper.getInstance().getPushType() == EMPushHelper.EMPushType.FCM;
            EMLog.i(TAG, "isFCMPush: " + bl2);
            if (bl2) {
                EMPushHelper.getInstance().sendDeviceTokenToServer(string);
            }
        } else {
            String string4 = EMPushHelper.getInstance().getHWAppId();
            String string5 = EMPushHelper.getInstance().getHMSToken();
            if (TextUtils.isEmpty((CharSequence)string4) || TextUtils.isEmpty((CharSequence)string5)) {
                this.sendEmptyToken();
            }
        }
    }

    public void sendHMSPushTokenToServer(String string, String string2) {
        if (!this.isFCMAvailable()) {
            EMPushHelper.getInstance().setPushType(EMPushHelper.EMPushType.HUAWEIPUSH);
            EMPushHelper.getInstance().setHWAppId(string);
            EMPushHelper.getInstance().setHMSToken(string2);
            EMPushHelper.getInstance().sendDeviceTokenToServer(string2);
        }
    }

    private void initManagers() {
        EMHttpClient.getInstance().onInit(this.mChatConfigPrivate);
        this.chatManager();
        this.contactManager();
        this.groupManager();
        this.chatroomManager();
        this.setNatvieNetworkCallback();
    }

    void _login(final String string, final String string2, final EMCallBack eMCallBack, final boolean bl, final boolean bl2) {
        if (this.getChatConfigPrivate() == null || !this.sdkInited) {
            eMCallBack.onError(1, "");
            return;
        }
        EMLog.e(TAG, "emchat manager login in process:" + Process.myPid());
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMLog.e(EMClient.TAG, "emchat manager login in process:" + Process.myPid() + " threadName:" + Thread.currentThread().getName() + " ID:" + Thread.currentThread().getId());
                if (string == null) {
                    eMCallBack.onError(101, "Invalid user name");
                    return;
                }
                EMAError eMAError = new EMAError();
                EMClient.this.emaObject.login(string, string2, bl, bl2, eMAError);
                if (eMAError.errCode() == 0) {
                    EMSessionManager.getInstance().setLastLoginUser(string);
                    EMAError eMAError2 = new EMAError();
                    if (eMAError2.errCode() == 0) {
                        if (EMClient.this.mChatConfigPrivate.G() || bl2) {
                            String string3 = EMClient.this.emaObject.getUserToken(false, eMAError2);
                            EMSessionManager.getInstance().setLastLoginToken(string3);
                            EMSessionManager.getInstance().setLastLoginWithToken(true);
                            EMSessionManager.getInstance().clearLastLoginPwd();
                        } else {
                            EMSessionManager.getInstance().setLastLoginPwd(string2);
                            EMSessionManager.getInstance().setLastLoginWithToken(false);
                            EMSessionManager.getInstance().clearLastLoginToken();
                        }
                    }
                    EMClient.this.onNewLogin();
                    EMClient.this.checkPushAvailable();
                    eMCallBack.onSuccess();
                } else {
                    EMClient.this.doStopService();
                    eMCallBack.onError(eMAError.errCode(), eMAError.errMsg());
                }
                if (eMAError.errCode() == 0) {
                    EMClient.this.setPresence(EMClient.this.getLocationString(bl));
                }
                if (eMAError.errCode() == 202) {
                    EMSessionManager.getInstance().clearLastLoginPwd();
                    EMSessionManager.getInstance().clearLastLoginToken();
                }
            }
        });
    }

    void checkPushAvailable() {
        if (this.isFCMAvailable()) {
            String string = EMPushHelper.getInstance().getFCMPushToken();
            this.sendFCMTokenToServer(string);
        } else if (EMPushHelper.getInstance().getPushType() == EMPushHelper.EMPushType.MIPUSH) {
            EMPushHelper.getInstance().sendDeviceTokenToServer();
        } else {
            String string = EMPushHelper.getInstance().getHWAppId();
            String string2 = EMPushHelper.getInstance().getHMSToken();
            if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
                EMPushHelper.getInstance().setPushType(EMPushHelper.EMPushType.HUAWEIPUSH);
                EMPushHelper.getInstance().sendDeviceTokenToServer(string2);
            } else {
                this.sendEmptyToken();
            }
        }
    }

    public boolean isFCMAvailable() {
        return EMPushHelper.getInstance().checkAvailablePushService() && EMPushHelper.getInstance().getPushType() == EMPushHelper.EMPushType.FCM;
    }

    private void sendEmptyToken() {
        for (int k = 0; k < 3; ++k) {
            boolean bl = EMPushHelper.getInstance().sendTokenToServer("");
            if (!bl) continue;
            return;
        }
    }

    void onNewLogin() {
        EMLog.d(TAG, "on new login created");
        String string = EMSessionManager.getInstance().getLastLoginUser();
        PathUtil.getInstance().initDirs(this.getChatConfigPrivate().l(), string, this.mContext);
        EMDBManager.a(string, this.mChatConfigPrivate);
        EMDBManager.a().a(new EMDBManager.a(){

            @Override
            public void onMigrationFinish(final boolean bl) {
                EMClient.this.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (EMClient.this.clientListeners != null) {
                            List list = EMClient.this.clientListeners;
                            synchronized (list) {
                                for (EMClientListener eMClientListener : EMClient.this.clientListeners) {
                                    eMClientListener.onMigrate2x(bl);
                                }
                            }
                        }
                    }
                });
            }
        });
        EMDBManager.a().c();
        this.saveAppname();
        EMPushHelper.getInstance().onInit();
        EMAdvanceDebugManager.a().a(this.mChatConfigPrivate);
        this.mContext.registerReceiver(this.connectivityBroadcastReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        if (this.smartHeartbeat == null) {
            this.smartHeartbeat = EMSmartHeartBeat.create(this.mContext);
        }
        this.smartHeartbeat.onInit();
        if (this.getChatConfigPrivate().a.hasHeartBeatCustomizedParams()) {
            this.smartHeartbeat.setCustomizedParams(this.getChatConfigPrivate().a.getWifiHeartBeatCustomizedParams(), this.getChatConfigPrivate().a.getMobileHeartBeatCustomizedParams());
        }
        this.doStartService();
        this.scheduleJob();
    }

    @TargetApi(value=21)
    void scheduleJob() {
        if (Build.VERSION.SDK_INT >= 21) {
            if ((Build.MANUFACTURER.toUpperCase().equals("OPPO") || Build.MANUFACTURER.toUpperCase().equals("VIVO")) && Build.VERSION.SDK_INT <= 22) {
                return;
            }
            try {
                Intent intent = new Intent(this.getContext(), EMJobService.class);
                this.mContext.startService(intent);
                JobInfo.Builder builder = new JobInfo.Builder(11, new ComponentName(this.getContext(), EMJobService.class));
                builder.setPeriodic(60000L);
                builder.setRequiredNetworkType(1);
                builder.setPersisted(true);
                JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
                jobScheduler.schedule(builder.build());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @TargetApi(value=21)
    void cancelJob() {
        if (Utils.isSdk21()) {
            if ((Build.MANUFACTURER.toUpperCase().equals("OPPO") || Build.MANUFACTURER.toUpperCase().equals("VIVO")) && Build.VERSION.SDK_INT <= 22) {
                return;
            }
            try {
                JobScheduler jobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
                jobScheduler.cancel(11);
                this.mContext.stopService(new Intent(this.mContext, EMJobService.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getAccessToken() {
        return this.getChatConfigPrivate().n();
    }

    private static boolean _loadLibrary(String string, boolean bl) {
        try {
            System.loadLibrary(string);
            return true;
        }
        catch (Throwable throwable) {
            if (bl) {
                throwable.printStackTrace();
            }
            return false;
        }
    }

    private static boolean _loadLibrary(String string) {
        return EMClient._loadLibrary(string, true);
    }

    private static void loadLibrary() {
        if (!libraryLoaded) {
            EMClient._loadLibrary("sqlite");
            EMClient._loadLibrary("hyphenate_av");
            EMClient._loadLibrary("hyphenate_av_recorder");
            System.loadLibrary("hyphenate");
            libraryLoaded = true;
        }
    }

    CryptoUtils getCryptoUtils() {
        return this.cryptoUtils;
    }

    void doStartService() {
        if (this.mContext == null) {
            return;
        }
        EMLog.d(TAG, "do start service: context:" + this.mContext);
        this.stopService = false;
        try {
            Intent intent = new Intent(this.mContext, EMChatService.class);
            this.mContext.startService(intent);
        }
        catch (Exception exception) {
            EMLog.d(TAG, "exception in start service, e: " + exception.getMessage());
        }
    }

    void doStopService() {
        try {
            if (this.mContext == null) {
                EMLog.w(TAG, "applicationContext is null, the server is not started before");
                return;
            }
            EMLog.d(TAG, "do stop service");
            this.stopService = true;
            Intent intent = new Intent(this.mContext, EMChatService.class);
            this.mContext.stopService(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveAppname() {
        EMMonitor.getInstance().getMonitorDB().a(this.mContext.getPackageName());
    }

    void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    void executeOnMainQueue(Runnable runnable) {
        this.mainQueue.submit(runnable);
    }

    void executeOnSendQueue(Runnable runnable) {
        this.sendQueue.submit(runnable);
    }

    EMChatConfigPrivate getChatConfigPrivate() {
        return this.mChatConfigPrivate;
    }

    void setNatvieNetworkCallback() {
        EMANetCallback eMANetCallback = new EMANetCallback(){

            @Override
            public int getNetState() {
                if (!NetUtils.hasDataConnection(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
                }
                if (NetUtils.isWifiConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_WIFI.ordinal();
                }
                if (NetUtils.isMobileConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_MOBILE.ordinal();
                }
                if (NetUtils.isEthernetConnected(EMClient.this.mContext)) {
                    return EMAChatClient.EMANetwork.NETWORK_CABLE.ordinal();
                }
                return EMAChatClient.EMANetwork.NETWORK_NONE.ordinal();
            }
        };
        this.mChatConfigPrivate.a.setNetCallback(eMANetCallback);
    }

    void setEncryptProvider(EMEncryptProvider eMEncryptProvider) {
        this.encryptProvider = eMEncryptProvider;
    }

    EMEncryptProvider getEncryptProvider() {
        if (this.encryptProvider == null) {
            EMLog.d(TAG, "encrypt provider is not set, create default");
            this.encryptProvider = new EMEncryptProvider(){

                @Override
                public byte[] encrypt(byte[] byArray, String string) {
                    try {
                        return EMClient.this.cryptoUtils.encrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }

                @Override
                public byte[] decrypt(byte[] byArray, String string) {
                    try {
                        return EMClient.this.cryptoUtils.decrypt(byArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return byArray;
                    }
                }
            };
        }
        return this.encryptProvider;
    }

    boolean sendPing(boolean bl, long l) {
        return this.emaObject.sendPing(bl, l);
    }

    void forceReconnect() {
        this.disconnect();
        this.reconnect();
    }

    void reconnect() {
        this.wakeLock.acquire();
        this.emaObject.reconnect();
        if (this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    void disconnect() {
        this.emaObject.disconnect();
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    void onNetworkChanged() {
        try {
            if (NetUtils.isWifiConnected(this.mContext)) {
                EMLog.d(TAG, "has wifi connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_WIFI);
                return;
            }
            if (NetUtils.isMobileConnected(this.mContext)) {
                EMLog.d(TAG, "has mobile connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_MOBILE);
                return;
            }
            if (NetUtils.isEthernetConnected(this.mContext)) {
                EMLog.d(TAG, "has ethernet connection");
                this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_CABLE);
                return;
            }
            EMLog.d(TAG, "no data connection");
            this.emaObject.onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    void onNetworkChanged(EMAChatClient.EMANetwork eMANetwork) {
        this.emaObject.onNetworkChanged(eMANetwork);
    }

    void setAppStateListener(AppStateListener appStateListener) {
        this.appStateListener = appStateListener;
    }

    @TargetApi(value=14)
    private void registerActivityLifecycleCallbacks() {
        if (Utils.isSdk14()) {
            Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

                public void onActivityStopped(Activity activity) {
                    EMClient.this.activitySize--;
                    if (EMClient.this.activitySize == 0 && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onBackground();
                    }
                }

                public void onActivityResumed(Activity activity) {
                    EMClient.this.activitySize++;
                    if (EMClient.this.activitySize == 1 && EMClient.this.appStateListener != null) {
                        EMClient.this.appStateListener.onForeground();
                    }
                }

                public void onActivityCreated(Activity activity, Bundle bundle) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityDestroyed(Activity activity) {
                }
            };
            ((Application)this.mContext).registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
    }

    void setPresence(final String string) {
        this.execute(new Runnable(){

            @Override
            public void run() {
                EMClient.this.emaObject.setPresence(string);
            }
        });
    }

    private String getLocationString(boolean bl) {
        GsmCellLocation gsmCellLocation;
        String string;
        JSONObject jSONObject = null;
        jSONObject = !bl ? this.getDeviceInfo() : new JSONObject();
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        String string2 = null;
        String string3 = null;
        int n = 0;
        try {
            string = telephonyManager.getSubscriberId();
            if (string != null) {
                string2 = string.substring(0, 3);
                string3 = string.substring(3, 5);
            }
            if ((gsmCellLocation = (GsmCellLocation)telephonyManager.getCellLocation()) != null) {
                n = gsmCellLocation.getCid();
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        string = (LocationManager)this.mContext.getSystemService("location");
        gsmCellLocation = null;
        try {
            gsmCellLocation = string.getLastKnownLocation("network");
            if (gsmCellLocation == null) {
                gsmCellLocation = string.getLastKnownLocation("gps");
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        try {
            if (gsmCellLocation != null && gsmCellLocation.getLongitude() != 0.0 && gsmCellLocation.getLatitude() != 0.0) {
                jSONObject.put("lon", gsmCellLocation.getLongitude()).put("lat", gsmCellLocation.getLatitude());
            }
            if (n != 0) {
                jSONObject.put("cellid", n);
            }
            jSONObject.put("wifissid", (Object)NetUtils.getWiFiSSID(this.mContext));
            if (string3 != null) {
                jSONObject.put("mnc", (Object)string3);
            }
            if (string2 != null) {
                jSONObject.put("mcc", (Object)string2);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject.toString();
    }

    public JSONObject getDeviceInfo() {
        Object object;
        WindowManager windowManager;
        Object object2;
        JSONObject jSONObject;
        block13: {
            jSONObject = new JSONObject();
            try {
                object2 = (TelephonyManager)this.mContext.getSystemService("phone");
                jSONObject.put("imei", (Object)object2.getDeviceId());
            }
            catch (Exception exception) {
                if (exception == null) break block13;
                EMLog.d(TAG, exception.getMessage());
            }
        }
        object2 = null;
        try {
            windowManager = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : windowManager) {
                if (!networkInterface.getName().equalsIgnoreCase("wlan0")) continue;
                byte[] byArray = networkInterface.getHardwareAddress();
                if (byArray == null) {
                    object2 = null;
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (Object object3 : (Object)byArray) {
                    stringBuilder.append(Integer.toHexString(object3 & 0xFF) + ":");
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                }
                object2 = stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        windowManager = (WindowManager)this.mContext.getSystemService("window");
        int n = 0;
        int n2 = 0;
        double d2 = 0.0;
        try {
            object = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics((DisplayMetrics)object);
            n = ((DisplayMetrics)object).widthPixels;
            n2 = ((DisplayMetrics)object).heightPixels;
            d2 = ((DisplayMetrics)object).densityDpi;
        }
        catch (Exception exception) {
            EMLog.d(TAG, exception.getMessage());
        }
        object = new DeviceUuidFactory(this.mContext);
        String string = ((DeviceUuidFactory)object).getDeviceUuid().toString();
        String string2 = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"android_id");
        try {
            jSONObject.put("deviceid", (Object)string);
            jSONObject.put("android-id", (Object)string2);
            jSONObject.put("app-id", (Object)this.mContext.getPackageName());
            jSONObject.put("hid", (Object)EMClient.getInstance().getCurrentUser());
            jSONObject.put("os", (Object)"android");
            jSONObject.put("os-version", (Object)Build.VERSION.RELEASE);
            jSONObject.put("manufacturer", (Object)Build.MANUFACTURER);
            jSONObject.put("model", (Object)Build.MODEL);
            jSONObject.put("width", n);
            jSONObject.put("height", n2);
            jSONObject.put("dpi", d2);
            if (object2 != null) {
                jSONObject.put("wifi-mac-address", object2);
            }
        }
        catch (JSONException jSONException) {
            EMLog.d(TAG, jSONException.getMessage());
        }
        return jSONObject;
    }

    public void check(String string, String string2, CheckResultListener checkResultListener) {
        Object object;
        if (this.duringChecking) {
            EMLog.i("EMServiceChecker", "During service checking, please hold on...");
            return;
        }
        this.duringChecking = true;
        if (this.isLoggedInBefore()) {
            string = this.getCurrentUser();
            object = EMSessionManager.getInstance();
            string2 = ((EMSessionManager)object).getLastLoginPwd();
        }
        object = string;
        String string3 = string2;
        new Thread(new Runnable((String)object, string3, checkResultListener){
            final /* synthetic */ String val$finalUser;
            final /* synthetic */ String val$finalPwd;
            final /* synthetic */ CheckResultListener val$listener;
            {
                this.val$finalUser = string;
                this.val$finalPwd = string2;
                this.val$listener = checkResultListener;
            }

            @Override
            public void run() {
                EMClient.this.emaObject.check(this.val$finalUser, this.val$finalPwd, new EMAChatClient.CheckResultListener(){

                    @Override
                    public void onResult(int n, int n2, String string) {
                        EMLog.i("EMServiceChecker", "type: " + n + ", result: " + n2 + ", desc: " + string);
                        EMClient.this.notifyCheckResult(val$listener, n, n2, string);
                        if (n2 != 0) {
                            EMClient.this.duringChecking = false;
                            return;
                        }
                        if (n == 3) {
                            EMClient.this.checkLogout(val$listener);
                        }
                    }
                });
            }
        }).start();
    }

    private void checkLogout(CheckResultListener checkResultListener) {
        if (!this.isLoggedInBefore()) {
            this.logout();
            this.notifyCheckResult(checkResultListener, 5, 0, "");
        }
        this.duringChecking = false;
    }

    private void notifyCheckResult(CheckResultListener checkResultListener, @EMCheckType.CheckType int n, int n2, String string) {
        if (checkResultListener == null) {
            return;
        }
        checkResultListener.onResult(n, n2, string);
    }

    public static interface CheckResultListener {
        public void onResult(@EMCheckType.CheckType int var1, int var2, String var3);
    }

    static interface AppStateListener {
        public void onForeground();

        public void onBackground();
    }

    class MyMultiDeviceListener
    extends EMAMultiDeviceListener {
        MyMultiDeviceListener() {
        }

        @Override
        public void onContactEvent(final int n, final String string, final String string2) {
            EMLog.d(EMClient.TAG, "onContactEvent:" + n + " target:" + string + " ext:" + string2);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.multiDeviceListeners;
                    synchronized (list) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onContactEvent(n, string, string2);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onGroupEvent(final int n, final String string, final List<String> list) {
            EMLog.d(EMClient.TAG, "onGroupEvent:" + n + " target:" + string + " usernames:" + list);
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list2 = EMClient.this.multiDeviceListeners;
                    synchronized (list2) {
                        try {
                            for (EMMultiDeviceListener eMMultiDeviceListener : EMClient.this.multiDeviceListeners) {
                                eMMultiDeviceListener.onGroupEvent(n, string, list);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }

    class MyConnectionListener
    extends EMAConnectionListener {
        MyConnectionListener() {
        }

        @Override
        public void onConnected() {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onConnected();
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final int n) {
            EMClient.this.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = EMClient.this.connectionListeners;
                    synchronized (list) {
                        if (n == 207) {
                            EMSessionManager.getInstance().clearLastLoginUser();
                            EMSessionManager.getInstance().clearLastLoginToken();
                        } else if (n == 206 || n == 305 || n == 216 || n == 217) {
                            EMSessionManager.getInstance().clearLastLoginToken();
                        }
                        try {
                            for (EMConnectionListener eMConnectionListener : EMClient.this.connectionListeners) {
                                eMConnectionListener.onDisconnected(n);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
            });
        }
    }
}

