/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.cloud;

import android.content.res.AssetManager;
import android.util.Log;

import com.hyphenate.chat.EMClient;
import com.hyphenate.util.EMLog;

import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;

import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;

public class HttpClientConfig {
	private static final String EASEMOB_USERSERVER_DOMAIN_ID = "hyphenate.com";
	private static final String EASEMOB_PLATFORM="Android";
	public static String EM_TIME_OUT_KEY = "em_timeout";
	public static int 	EM_DEFAULT_TIMEOUT = 60*1000;

	/**
	 * if is hyphenate server , https replace http, because http is quickly than
	 * https
	 */
	public static String getEaseMobUserServerDomainId() {
		return EASEMOB_USERSERVER_DOMAIN_ID;
	}

	/**
	 * 为每个HttpClient添加User-Agent
	 * @return
	 */
	private static String getDefaultUserAgent() {
		String sb = "Easemob-SDK(" +
				HttpClientConfig.EASEMOB_PLATFORM +
				") " +
				EMClient.getInstance().VERSION;
		return sb;
	}
	
	
	/**
	 * DefaultHttpClient
	 * @return  httpclient
	 */
	public static DefaultHttpClient getDefaultHttpClient(){
		return getDefaultHttpClient("", EM_DEFAULT_TIMEOUT);
	}

	public static DefaultHttpClient getDefaultHttpClient(String url, int timeout){
		// If url is IP based address, using self signed certificate
		boolean selfSignedCertificate = false;
		int port = 443;
		if (url != null && url.toLowerCase().startsWith("https://")) {
			url = url.substring("https://".length());
			String[] ips = url.split("\\.");
			if (ips.length > 3) {
				try {
					int d = Integer.parseInt(ips[0]);
					if (!(0 <= d && d <= 255)) { throw new NumberFormatException(); }
					d = Integer.parseInt(ips[1]);
					if (!(0 <= d && d <= 255)) { throw new NumberFormatException(); }
					d = Integer.parseInt(ips[2]);
					if (!(0 <= d && d <= 255)) { throw new NumberFormatException(); }
					if (ips[3].indexOf(':') != -1) {
						String ip3 = ips[3].substring(0, ips[3].indexOf(':'));
						d = Integer.parseInt(ip3);
						if (!(0 <= d && d <= 255)) { throw new NumberFormatException(); }

						String portStr;
						String portTrailing = ips[3].substring(ips[3].indexOf(':') + 1);
						if (portTrailing.indexOf('/') != -1) {
							portStr = portTrailing.substring(0, portTrailing.indexOf('/'));
						} else {
							portStr = portTrailing;
						}
						try {
							port = Integer.parseInt(portStr);
						} catch (NumberFormatException e) {
							e.printStackTrace();
						}
					}

					selfSignedCertificate = true;
				} catch (NumberFormatException e) {
					e.printStackTrace();
				}
			}
		}
		return getDefaultHttpClient(timeout, selfSignedCertificate, port);
	}

	public static DefaultHttpClient getDefaultHttpClient(int timeout, boolean selfSignedCertificate, int port){
		HttpParams httpParameters=new BasicHttpParams();
		HttpConnectionParams.setConnectionTimeout(httpParameters, timeout);
		HttpConnectionParams.setSoTimeout(httpParameters, 60000);
		HttpConnectionParams.setTcpNoDelay(httpParameters, true);
		HttpProtocolParams.setUserAgent(httpParameters, getDefaultUserAgent());
		
		SchemeRegistry supportedSchemes = new SchemeRegistry();
	    SocketFactory sf = PlainSocketFactory.getSocketFactory();
	    supportedSchemes.register(new Scheme("http", sf, 80));
	    supportedSchemes.register(new Scheme("https",
			    selfSignedCertificate ? SSLCustomSocketFactory.getSocketFactory() : SSLSocketFactory.getSocketFactory(),
			    port));
		
		ClientConnectionManager ccm = new ThreadSafeClientConnManager(httpParameters, supportedSchemes);
		DefaultHttpClient httpClient=new DefaultHttpClient(ccm, httpParameters);
		httpClient.setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy());
		httpClient.setReuseStrategy(new DefaultConnectionReuseStrategy());
		return httpClient;
	}

	public static class SSLCustomSocketFactory extends SSLSocketFactory {
		private static final String TAG = "SSLCustomSocketFactory";
		private static final String KEY_PASS = "";
		static SSLContext  sslContext;
		static SSLSocketFactory mSocketFactory;


		public SSLCustomSocketFactory(KeyStore trustStore) throws Throwable {
			super(trustStore);
		}

		public static synchronized SSLSocketFactory getSocketFactory() {
			if (mSocketFactory == null) {
				try {
					CertificateFactory cf = CertificateFactory.getInstance("X.509");
					AssetManager am = EMClient.getInstance().getContext().getAssets();
					String[] certsPaths = am.list("hyphenate_certs");
					String keyStoreType = KeyStore.getDefaultType();
					KeyStore keyStore = KeyStore.getInstance(keyStoreType);
					keyStore.load(null, null);
					for (int i = 0; i < certsPaths.length; i++) {
						String certPath = certsPaths[i];
						InputStream caInput = null;
						try {
							caInput = am.open("hyphenate_certs/" + certPath);
							Certificate ca = cf.generateCertificate(caInput);
							System.out.println("ca=" + ((X509Certificate) ca).getSubjectDN());
							keyStore.setCertificateEntry("ca" + i, ca);
						} catch (Exception e) {
							e.printStackTrace();
						} finally {
							if (caInput != null) {
								caInput.close();
							}
						}
					}

					EMLog.d(TAG, "keystore type:" + keyStore.getType());

					SSLSocketFactory factory = new SSLCustomSocketFactory(keyStore);
					factory.setHostnameVerifier(new X509HostnameVerifier() {
						@Override
						public boolean verify(String s, SSLSession sslSession) {
							return true;
						}

						@Override
						public void verify(String s, SSLSocket sslSocket) throws IOException {
						}

						@Override
						public void verify(String s, X509Certificate x509Certificate) throws SSLException {
						}

						@Override
						public void verify(String s, String[] strings, String[] strings1) throws SSLException {
						}
					});

					sslContext = SSLContext.getInstance("TLS");
					String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
					TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
					tmf.init(keyStore);
					sslContext.init(null, tmf.getTrustManagers(), null);
					mSocketFactory = factory;
				} catch (Throwable e) {
					Log.d(TAG, e.getMessage());
					e.printStackTrace();
				}
			}
			return mSocketFactory;
		}

		@Override
		public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
			javax.net.ssl.SSLSocketFactory socketfactory = sslContext.getSocketFactory();
			SSLSocket sslSocket = (SSLSocket) socketfactory.createSocket(s, host, port, autoClose);
			// TODO: check support TLS1.2
//			sslSocket.setEnabledProtocols(new String[]{"TLS1.1"});
			return sslSocket;
		}
	}

	/**
	 * 检测remoteFilePath是完整的url还是uuid，如果是uuid则需要拼接成真正的url
	 * @param remoteFilePath
	 * @return
	 */
	public static String getFileRemoteUrl(String remoteFilePath) {
		if (remoteFilePath.startsWith("http")) {
			return remoteFilePath;
		}
		String remoteUrl = getFileDirRemoteUrl();
		remoteUrl += remoteFilePath;
		return remoteUrl;
	}
	
	/**
	 * get upload download remote-url eg.image audio ect.
	 * @return
	 */
	public static String getFileDirRemoteUrl() {
		String remoteUrl = getBaseUrlByAppKey();
		remoteUrl += "/chatfiles/";
		return remoteUrl;
	}
	
	/**
	 * the base remote url with appkey
	 * @return
	 */
	public static String getBaseUrlByAppKey(){
	    return EMHttpClient.getInstance().chatConfig().getBaseUrl();
	}

	public static int getTimeout(Map<String,String> headers){
        int timeout = HttpClientConfig.EM_DEFAULT_TIMEOUT;
    	
    	if(headers != null && headers.get(HttpClientConfig.EM_TIME_OUT_KEY) != null){
    		timeout = Integer.valueOf(headers.get(HttpClientConfig.EM_TIME_OUT_KEY));
    		headers.remove(HttpClientConfig.EM_TIME_OUT_KEY);
    	}
    	
    	return timeout;
	}
}
