package com.hyphenate.chat.adapter;

import android.util.Base64;

import com.hyphenate.util.EMLog;

import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import static android.util.Base64.decode;
import static com.hyphenate.chat.adapter.EMAREncryptUtils.B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP;


/**
 * Created by linan on 17/6/6.
 */

public class EMAREncryptUtils {

    enum B64_ENCODE_FLAG {
        ONESDK_B64_DEFAULT,
        ONESDK_B64_NO_WRAP
    }

    public static final String TAG = "EMAREncryptUtils";

    Cipher cipher;
    Cipher decipher;

    public static byte[] generateAESKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void initAES(byte[] keyBytes) {
        initAEScbc(keyBytes);
    }

    public void unInitAES() {
    }

    public void initAESecb(byte[] keyBytes) {
        try {
            SecretKeySpec spec = new SecretKeySpec(keyBytes, "AES");
            cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, spec);
            decipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            decipher.init(Cipher.DECRYPT_MODE, spec);
            EMLog.d("encrypt", "init for AES ecb");
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
    }

    public void initAEScbc(byte[] keyBytes) {
        try {
            SecretKeySpec spec = new SecretKeySpec(keyBytes, "AES");

            IvParameterSpec ive = new IvParameterSpec("0000000000000000".getBytes());
            IvParameterSpec ivd = new IvParameterSpec("0000000000000000".getBytes());

            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(Cipher.ENCRYPT_MODE, spec, ive);
            decipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            decipher.init(Cipher.DECRYPT_MODE, spec, ivd);
            EMLog.d("encrypt", "init for AES cbc");
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
    }

    public static String b64Encode(byte[] data, int b64Flag) {
        return Base64.encodeToString(data, 0, data.length, b64Flag == ONESDK_B64_NO_WRAP.ordinal() ? Base64.NO_WRAP : Base64.DEFAULT);
    }

    public static byte[] b64Decode(String encryptedMsg) {
        return decode(encryptedMsg, Base64.DEFAULT);
    }

    public String aesEncrypt(String plainMsg, int b64Flag) {
        try {
            byte[] stringBytes = plainMsg.getBytes("UTF-8");
            byte[] encryptedBytes = cipher.doFinal(stringBytes);
            return b64Encode(encryptedBytes, b64Flag);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
        return null;
    }

    public String aesDecrypt(String encryptedMsg) {
        try {
            byte[] b64Out = b64Decode(encryptedMsg);
            byte[] decryptedBytes = decipher.doFinal(b64Out);
            return new String(decryptedBytes);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
        return null;
    }

    public byte[] aesEncryptInner(byte[]in) {
        try {
             return cipher.doFinal(in);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
        return null;
    }

    public byte[] aesDecryptInner(byte[]in) {
        try {
            return decipher.doFinal(in);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
        return null;
    }

    /**
     * publicKey is b64 encode string
     * data is raw data to be encrypted
     * return is b64 encode string
     */
    public static byte[] encryptByRSAPublicKey(final String key_, final byte[] data, AtomicBoolean success) {

        String key = key_;
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        key = key.replace("\n", "");

        byte[] keyBytes = Base64.decode(key.getBytes(), Base64.NO_WRAP);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            /**
             * java default implementation is RSA/ECB/PKCS1Padding,
             * but if you directly refer algorithm "RSA／ECB/PKCS1Padding" from KeyFactory,
             * it will report "KeyFactory RSA/ECB/PKCS1Padding implementation not found"
             */
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key publicKey = keyFactory.generatePublic(x509KeySpec);
            EMLog.d(TAG, "publicKey.getFormat:" + publicKey.getFormat());

            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            byte[] result = cipher.doFinal(data);
            success.set(true);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, e.getStackTrace().toString());
        }
        return null;
    }

    /**
     * MessageDigest, default using MD5
     * @param type
     * @param data
     * @return
     */
    public static String messageDigest(int type, final byte[] data) {
        MessageDigest md5 = null;
        try{
            md5 = MessageDigest.getInstance("MD5");
        }catch(Exception e){
            e.printStackTrace();
        }
        byte[] digest = md5.digest(data);
        // to hex
        StringBuffer buff = new StringBuffer();
        for(int i = 0; i < digest.length; i++){
            int num = ((int)digest[i]) & 0xff;
            if(num < 16)
                buff.append("0");
            buff.append(Integer.toHexString(num));
        }
        return buff.toString();
    }

}
