/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voice;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Process;
import com.superrtc.call.Logging;
import com.superrtc.voice.WebRtcAudioUtils;
import java.nio.ByteBuffer;

class WebRtcAudioTrack {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioTrack";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private final Context context;
    private final long nativeAudioTrack;
    private final AudioManager audioManager;
    private ByteBuffer byteBuffer;
    private AudioTrack audioTrack = null;
    private AudioTrackThread audioThread = null;

    WebRtcAudioTrack(Context context, long l) {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.context = context;
        this.nativeAudioTrack = l;
        this.audioManager = (AudioManager)context.getSystemService("audio");
    }

    private void initPlayout(int n, int n2) {
        Logging.d(TAG, "initPlayout(sampleRate=" + n + ", channels=" + n2 + ")");
        int n3 = n2 * 2;
        this.byteBuffer = ByteBuffer.allocateDirect(n3 * (n / 100));
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioTrack);
        int n4 = AudioTrack.getMinBufferSize((int)n, (int)4, (int)2);
        Logging.d(TAG, "AudioTrack.getMinBufferSize: " + n4);
        WebRtcAudioTrack.assertTrue(this.audioTrack == null);
        WebRtcAudioTrack.assertTrue(this.byteBuffer.capacity() < n4);
        try {
            this.audioTrack = new AudioTrack(0, n, 4, 2, n4, 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.d(TAG, illegalArgumentException.getMessage());
            return;
        }
        if (this.audioTrack.getState() != 1) {
            Logging.e(TAG, "AudioTrack init failed!");
            return;
        }
        WebRtcAudioTrack.assertTrue(this.audioTrack.getPlayState() == 1);
        WebRtcAudioTrack.assertTrue(this.audioTrack.getStreamType() == 0);
    }

    private boolean startPlayout() {
        Logging.d(TAG, "startPlayout");
        WebRtcAudioTrack.assertTrue(this.audioTrack != null);
        WebRtcAudioTrack.assertTrue(this.audioThread == null);
        this.audioThread = new AudioTrackThread("AudioTrackJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopPlayout() {
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(this.audioThread != null);
        this.audioThread.joinThread();
        this.audioThread = null;
        if (this.audioTrack != null) {
            this.audioTrack.release();
            this.audioTrack = null;
        }
        return true;
    }

    private int getStreamMaxVolume() {
        Logging.d(TAG, "getStreamMaxVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamMaxVolume(0);
    }

    private boolean setStreamVolume(int n) {
        Logging.d(TAG, "setStreamVolume(" + n + ")");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        if (this.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n, 0);
        return true;
    }

    @TargetApi(value=21)
    private boolean isVolumeFixed() {
        if (!WebRtcAudioUtils.runningOnLollipopOrHigher()) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    private int getStreamVolume() {
        Logging.d(TAG, "getStreamVolume");
        WebRtcAudioTrack.assertTrue(this.audioManager != null);
        return this.audioManager.getStreamVolume(0);
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeGetPlayoutData(int var1, long var2);

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            try {
                WebRtcAudioTrack.this.audioTrack.play();
                WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.play failed: " + illegalStateException.getMessage());
                return;
            }
            int n = WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                WebRtcAudioTrack.this.nativeGetPlayoutData(n, WebRtcAudioTrack.this.nativeAudioTrack);
                WebRtcAudioTrack.assertTrue(n <= WebRtcAudioTrack.this.byteBuffer.remaining());
                int n2 = 0;
                n2 = WebRtcAudioUtils.runningOnLollipopOrHigher() ? this.writeOnLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n) : this.writePreLollipop(WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                if (n2 != n) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write failed: " + n2);
                    if (n2 == -3) {
                        this.keepAlive = false;
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
            try {
                WebRtcAudioTrack.this.audioTrack.stop();
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
            }
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 1);
            WebRtcAudioTrack.this.audioTrack.flush();
        }

        @TargetApi(value=21)
        private int writeOnLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            return audioTrack.write(byteBuffer, n, 0);
        }

        private int writePreLollipop(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            return audioTrack.write(byteBuffer.array(), byteBuffer.arrayOffset(), n);
        }

        public void joinThread() {
            this.keepAlive = false;
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

