/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.superrtc.call.EglBase;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.GlUtil;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.ThreadUtils;
import com.superrtc.call.VideoRenderer;
import java.util.concurrent.CountDownLatch;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoRenderer.Callbacks {
    private static final String TAG = "SurfaceViewRenderer";
    private HandlerThread renderThread;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private EglBase eglBase;
    private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
    private RendererCommon.GlDrawer drawer;
    private int[] yuvTextures = null;
    private final Object frameLock = new Object();
    private VideoRenderer.I420Frame pendingFrame;
    private final Object layoutLock = new Object();
    private Point desiredLayoutSize = new Point();
    private final Point layoutSize = new Point();
    private final Point surfaceSize = new Point();
    private boolean isSurfaceCreated;
    private int frameWidth;
    private int frameHeight;
    private int frameRotation;
    private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
    private boolean mirror;
    private RendererCommon.RendererEvents rendererEvents;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long firstFrameTimeNs;
    private long renderTimeNs;
    private final Runnable renderFrameRunnable = new Runnable(){

        @Override
        public void run() {
            SurfaceViewRenderer.this.renderFrameOnRenderThread();
        }
    };
    private final Runnable makeBlackRunnable = new Runnable(){

        @Override
        public void run() {
            SurfaceViewRenderer.this.makeBlack();
        }
    };

    public SurfaceViewRenderer(Context context) {
        super(context);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public SurfaceViewRenderer(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        this.init(context, rendererEvents, EglBase.CONFIG_PLAIN, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.getResourceName() + "Already initialized");
            }
            Logging.d(TAG, this.getResourceName() + "Initializing.");
            this.rendererEvents = rendererEvents;
            this.drawer = glDrawer;
            this.renderThread = new HandlerThread(TAG);
            this.renderThread.start();
            this.eglBase = EglBase.create(context, nArray);
            this.renderThreadHandler = new Handler(this.renderThread.getLooper());
        }
        this.tryCreateEglSurface();
    }

    public void tryCreateEglSurface() {
        this.runOnRenderThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = SurfaceViewRenderer.this.layoutLock;
                synchronized (object) {
                    if (SurfaceViewRenderer.this.isSurfaceCreated && !SurfaceViewRenderer.this.eglBase.hasSurface()) {
                        SurfaceViewRenderer.this.eglBase.createSurface(SurfaceViewRenderer.this.getHolder().getSurface());
                        SurfaceViewRenderer.this.eglBase.makeCurrent();
                        GLES20.glPixelStorei((int)3317, (int)1);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                Logging.d(TAG, this.getResourceName() + "Already released");
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    SurfaceViewRenderer.this.drawer.release();
                    SurfaceViewRenderer.this.drawer = null;
                    if (SurfaceViewRenderer.this.yuvTextures != null) {
                        GLES20.glDeleteTextures((int)3, (int[])SurfaceViewRenderer.this.yuvTextures, (int)0);
                        SurfaceViewRenderer.access$602(SurfaceViewRenderer.this, null);
                    }
                    SurfaceViewRenderer.this.makeBlack();
                    SurfaceViewRenderer.this.eglBase.release();
                    SurfaceViewRenderer.this.eglBase = null;
                    countDownLatch.countDown();
                }
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(countDownLatch);
        this.renderThread.quit();
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                VideoRenderer.renderFrameDone(this.pendingFrame);
                this.pendingFrame = null;
            }
        }
        ThreadUtils.joinUninterruptibly((Thread)this.renderThread);
        this.renderThread = null;
        object = this.layoutLock;
        synchronized (object) {
            this.frameWidth = 0;
            this.frameHeight = 0;
            this.frameRotation = 0;
            this.rendererEvents = null;
        }
        this.resetStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.firstFrameTimeNs = 0L;
            this.renderTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean bl) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.scalingType = scalingType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderFrame(VideoRenderer.I420Frame i420Frame) {
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                Logging.d(TAG, this.getResourceName() + "Dropping frame - Not initialized or already released.");
                VideoRenderer.renderFrameDone(i420Frame);
                return;
            }
            Object object2 = this.frameLock;
            synchronized (object2) {
                if (this.pendingFrame != null) {
                    Object object3 = this.statisticsLock;
                    synchronized (object3) {
                        ++this.framesDropped;
                    }
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                }
                this.pendingFrame = i420Frame;
                this.updateFrameDimensionsAndReportEvents(i420Frame);
                this.renderThreadHandler.post(this.renderFrameRunnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Point getDesiredLayoutSize(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            int n3 = SurfaceViewRenderer.getDefaultSize((int)Integer.MAX_VALUE, (int)n);
            int n4 = SurfaceViewRenderer.getDefaultSize((int)Integer.MAX_VALUE, (int)n2);
            Point point = RendererCommon.getDisplaySize(this.scalingType, this.frameAspectRatio(), n3, n4);
            if (View.MeasureSpec.getMode((int)n) == 0x40000000) {
                point.x = n3;
            }
            if (View.MeasureSpec.getMode((int)n2) == 0x40000000) {
                point.y = n4;
            }
            return point;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int n, int n2) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth == 0 || this.frameHeight == 0) {
                super.onMeasure(n, n2);
                return;
            }
            this.desiredLayoutSize = this.getDesiredLayoutSize(n, n2);
            if (this.desiredLayoutSize.x != this.getMeasuredWidth() || this.desiredLayoutSize.y != this.getMeasuredHeight()) {
                Object object2 = this.handlerLock;
                synchronized (object2) {
                    if (this.renderThreadHandler != null) {
                        this.renderThreadHandler.postAtFrontOfQueue(this.makeBlackRunnable);
                    }
                }
            }
            this.setMeasuredDimension(this.desiredLayoutSize.x, this.desiredLayoutSize.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutSize.x = n3 - n;
            this.layoutSize.y = n4 - n2;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, this.getResourceName() + "Surface created.");
        Object object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = true;
        }
        this.tryCreateEglSurface();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        Logging.d(TAG, this.getResourceName() + "Surface destroyed.");
        Object object = this.layoutLock;
        synchronized (object) {
            this.isSurfaceCreated = false;
            this.surfaceSize.x = 0;
            this.surfaceSize.y = 0;
        }
        this.runOnRenderThread(new Runnable(){

            @Override
            public void run() {
                SurfaceViewRenderer.this.eglBase.releaseSurface();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        Logging.d(TAG, this.getResourceName() + "Surface changed: " + n2 + "x" + n3);
        Object object = this.layoutLock;
        synchronized (object) {
            this.surfaceSize.x = n2;
            this.surfaceSize.y = n3;
        }
        this.runOnRenderThread(this.renderFrameRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOnRenderThread(Runnable runnable) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(runnable);
            }
        }
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId()) + ": ";
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void makeBlack() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException(this.getResourceName() + "Wrong thread.");
        }
        if (this.eglBase != null && this.eglBase.hasSurface()) {
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GLES20.glClear((int)16384);
            this.eglBase.swapBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConsistentLayout() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException(this.getResourceName() + "Wrong thread.");
        }
        Object object = this.layoutLock;
        synchronized (object) {
            return this.layoutSize.equals((Object)this.desiredLayoutSize) && this.surfaceSize.equals((Object)this.layoutSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void renderFrameOnRenderThread() {
        if (Thread.currentThread() != this.renderThread) {
            throw new IllegalStateException(this.getResourceName() + "Wrong thread.");
        }
        Object object = this.frameLock;
        // MONITORENTER : object
        if (this.pendingFrame == null) {
            // MONITOREXIT : object
            return;
        }
        VideoRenderer.I420Frame i420Frame = this.pendingFrame;
        this.pendingFrame = null;
        // MONITOREXIT : object
        if (this.eglBase == null || !this.eglBase.hasSurface()) {
            Logging.d(TAG, this.getResourceName() + "No surface to draw on");
            VideoRenderer.renderFrameDone(i420Frame);
            return;
        }
        if (!this.checkConsistentLayout()) {
            this.makeBlack();
            VideoRenderer.renderFrameDone(i420Frame);
            return;
        }
        object = this.layoutLock;
        // MONITORENTER : object
        if (this.eglBase.surfaceWidth() != this.surfaceSize.x || this.eglBase.surfaceHeight() != this.surfaceSize.y) {
            this.makeBlack();
        }
        // MONITOREXIT : object
        long l = System.nanoTime();
        Object object2 = this.layoutLock;
        // MONITORENTER : object2
        Object object3 = RendererCommon.rotateTextureMatrix(i420Frame.samplingMatrix, i420Frame.rotationDegree);
        float[] fArray = RendererCommon.getLayoutMatrix(this.mirror, this.frameAspectRatio(), (float)this.layoutSize.x / (float)this.layoutSize.y);
        float[] fArray2 = RendererCommon.multiplyMatrices(object3, fArray);
        // MONITOREXIT : object2
        GLES20.glClear((int)16384);
        if (i420Frame.yuvFrame) {
            if (this.yuvTextures == null) {
                this.yuvTextures = new int[3];
                for (int k = 0; k < 3; ++k) {
                    this.yuvTextures[k] = GlUtil.generateTexture(3553);
                }
            }
            this.yuvUploader.uploadYuvData(this.yuvTextures, i420Frame.width, i420Frame.height, i420Frame.yuvStrides, i420Frame.yuvPlanes);
            this.drawer.drawYuv(this.yuvTextures, fArray2, 0, 0, this.surfaceSize.x, this.surfaceSize.y);
        } else {
            this.drawer.drawOes(i420Frame.textureId, fArray2, 0, 0, this.surfaceSize.x, this.surfaceSize.y);
        }
        this.eglBase.swapBuffers();
        VideoRenderer.renderFrameDone(i420Frame);
        object2 = this.statisticsLock;
        // MONITORENTER : object2
        if (this.framesRendered == 0) {
            this.firstFrameTimeNs = l;
            Object object4 = this.layoutLock;
            object3 = object4;
            // MONITORENTER : object4
            Logging.d(TAG, this.getResourceName() + "Reporting first rendered frame.");
            if (this.rendererEvents != null) {
                this.rendererEvents.onFirstFrameRendered();
            }
            // MONITOREXIT : object3
        }
        ++this.framesRendered;
        this.renderTimeNs += System.nanoTime() - l;
        if (this.framesRendered % 300 == 0) {
            this.logStatistics();
        }
        // MONITOREXIT : object2
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float frameAspectRatio() {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth == 0 || this.frameHeight == 0) {
                return 0.0f;
            }
            return this.frameRotation % 180 == 0 ? (float)this.frameWidth / (float)this.frameHeight : (float)this.frameHeight / (float)this.frameWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(VideoRenderer.I420Frame i420Frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.frameWidth != i420Frame.width || this.frameHeight != i420Frame.height || this.frameRotation != i420Frame.rotationDegree) {
                Logging.d(TAG, this.getResourceName() + "Reporting frame resolution changed to " + i420Frame.width + "x" + i420Frame.height + " with rotation " + i420Frame.rotationDegree);
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
                }
                this.frameWidth = i420Frame.width;
                this.frameHeight = i420Frame.height;
                this.frameRotation = i420Frame.rotationDegree;
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        SurfaceViewRenderer.this.requestLayout();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        Object object = this.statisticsLock;
        synchronized (object) {
            Logging.d(TAG, this.getResourceName() + "Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                long l = System.nanoTime() - this.firstFrameTimeNs;
                Logging.d(TAG, this.getResourceName() + "Duration: " + (int)((double)l / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l);
                Logging.d(TAG, this.getResourceName() + "Average render time: " + (int)(this.renderTimeNs / (long)(1000 * this.framesRendered)) + " us.");
            }
        }
    }

    static /* synthetic */ int[] access$602(SurfaceViewRenderer surfaceViewRenderer, int[] nArray) {
        surfaceViewRenderer.yuvTextures = nArray;
        return nArray;
    }
}

