/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.util;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import android.widget.Toast;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FileUtils {
    public static String[] fileTypes = new String[] { "apk", "avi", "bmp", "chm", "dll", "doc", "docx", "dos", "gif",
        "html", "jpeg", "jpg", "movie", "mp3","dat", "mp4", "mpe", "mpeg", "mpg", "pdf", "png", "ppt", "pptx", "rar",
        "txt", "wav", "wma", "wmv", "xls", "xlsx", "xml", "zip" };
    
    public static File[] loadFiles(File directory){
        File[] listFiles = directory.listFiles();
        if(listFiles == null)
            listFiles = new File[]{};
        
        ArrayList<File> tempFolder = new ArrayList<File>();
        ArrayList<File> tempFile = new ArrayList<File>();
        for (File file : listFiles) {
            if (file.isDirectory()) {
                tempFolder.add(file);
            } else if (file.isFile()) {
                tempFile.add(file);
            }
        }
        // sort list
        Comparator<File> comparator = new MyComparator();
        Collections.sort(tempFolder, comparator);
        Collections.sort(tempFile, comparator);

        File[] datas = new File[tempFolder.size() + tempFile.size()];
        System.arraycopy(tempFolder.toArray(new File[tempFolder.size()]), 0, datas, 0, tempFolder.size());
        System.arraycopy(tempFile.toArray(new File[tempFile.size()]), 0, datas, tempFolder.size(), tempFile.size());

        return datas;
    }
    
    /**
     * Determine the type of file
     * @param f
     * @return
     */
    public static String getMIMEType(File f) {
        String type = "";
        String fName = f.getName();

        String end = fName.substring(fName.lastIndexOf(".") + 1, fName.length()).toLowerCase();
        type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(end);
        return type;
    }
    
    public static String getMIMEType(String fileName) {
        String type = "";

        String end = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()).toLowerCase();
        type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(end);
        return type;
    }
    
    /**
     * open file
     * @param f
     * @param context
     */
    public static void openFile(File f,Activity context) {
        Intent intent = new Intent();
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setAction(android.content.Intent.ACTION_VIEW);
        /* get MimeType */
        String type = FileUtils.getMIMEType(f);
        /* set intent's file and MimeType */
        intent.setDataAndType(Uri.fromFile(f), type);
        try {
            context.startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(context, "Can't find proper app to open this file", Toast.LENGTH_LONG).show();
        }
    }
    
    public static void openFile(Uri uri,String type,Activity context) {
        Intent intent = new Intent();
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.setAction(android.content.Intent.ACTION_VIEW);
        /* get MimeType */
        /* set intent's file and MimeType */
        intent.setDataAndType(uri, type);
        try {
            context.startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(context, "Can't find proper app to open this file", Toast.LENGTH_LONG).show();
        }
    }
    
 // custom comparator
    public static class MyComparator implements Comparator<File> {
        @Override
        public int compare(File lhs, File rhs) {
            return lhs.getName().compareTo(rhs.getName());
        }

    }
    
  
    public static synchronized void saveObjectToFile(Object object,File toSaveFile) throws Exception{
		ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(toSaveFile));
		out.writeObject(object);
		out.flush();
		out.close();
    	
    }
    
    public static synchronized Object readObjectFromFile(File toReadFile) throws Exception{
    	ObjectInputStream in = new ObjectInputStream(new FileInputStream(toReadFile));
    	return in.readObject();
    }
    
    
}
