/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;
import com.hyphenate.chat.EMCallManager;
import com.hyphenate.util.EMLog;
import com.superrtc.sdk.RtcConnection;

import org.json.JSONException;
import org.json.JSONObject;

public class EMACallRtcImpl implements EMACallRtcInterface {
    public static final String TAG = "EMACallRtcImpl";
    
    RtcConnection rtcConnection;
    EMCallManager callManager;
    
    EMACallRtcImpl() {
    }
    
    public void setRtcConnection(EMCallManager call, RtcConnection rtc) {
        callManager = call;
        rtcConnection = rtc;
    }
    
    public RtcConnection getConnection() {
        return rtcConnection;
    }

    @Override
    public String getRtcId() {
        return rtcConnection.getName();
    }

    /* calltype */
    @Override
    public String getDefaultConfig(int typeOridinal) {

        JSONObject initjson = new JSONObject();
        return "{}";
    }
    
    @Override
    public String getRtcReport() {
        try {
            return rtcConnection.getReportString();
        } catch (JSONException e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    @Override
    public String getSubConfig() {
        return "{}";
    }

    @Override
    public void createOffer() {
        rtcConnection.createOffer();
    }

    @Override
    public void answer() {
        rtcConnection.answer();
    }

    @Override
    public void hangup() {
        EMLog.d(TAG, "hangup");
        rtcConnection.hangup();
        if (callManager != null) {
            callManager.clearRtcConnection();
        }
    }

    @Override
    public void setStatsEnable(boolean statsEnable) {
        rtcConnection.setStatsEnable(statsEnable);
    }

    @Override
    public void setConfigJson(String config) {
//        EMLog.d(TAG, "setConfigJson:" + config);
        if (config == null || config.isEmpty()) {
//            EMLog.d(TAG, "setConfigJson is empty");
//            return;
        }
        rtcConnection.setConfigure(config);
    }

    @Override
    public void setRemoteJson(String jsonStr) {
        try {
//            EMLog.d(TAG, "setRemoteJson:" + jsonStr);
            rtcConnection.setRemoteJson(new String(jsonStr));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
