/*
 * Decompiled with CFR 0.152.
 */
package internal.org.java_websocket.a;

import internal.org.java_websocket.WebSocket;
import internal.org.java_websocket.b.d;
import internal.org.java_websocket.b.f;
import internal.org.java_websocket.drafts.Draft;
import internal.org.java_websocket.drafts.c;
import internal.org.java_websocket.exceptions.InvalidHandshakeException;
import internal.org.java_websocket.framing.Framedata;
import internal.org.java_websocket.h;
import internal.org.java_websocket.i;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public abstract class b
extends internal.org.java_websocket.a
implements WebSocket,
Runnable {
    protected URI c = null;
    private h e = null;
    private Socket f = null;
    private InputStream g;
    private OutputStream h;
    private Proxy i = Proxy.NO_PROXY;
    private Thread j;
    private Draft k;
    private Map<String, String> l;
    private CountDownLatch m = new CountDownLatch(1);
    private CountDownLatch n = new CountDownLatch(1);
    private int o = 0;

    public b(URI uRI) {
        this(uRI, new c());
    }

    public b(URI uRI, Draft draft) {
        this(uRI, draft, null, 0);
    }

    public b(URI uRI, Draft draft, Map<String, String> map, int n) {
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        if (draft == null) {
            throw new IllegalArgumentException("null as draft is permitted for `WebSocketServer` only!");
        }
        this.c = uRI;
        this.k = draft;
        this.l = map;
        this.o = n;
        this.setTcpNoDelay(false);
        this.e = new h((i)this, draft);
    }

    public URI a() {
        return this.c;
    }

    @Override
    public Draft getDraft() {
        return this.k;
    }

    public Socket b() {
        return this.f;
    }

    public void c() {
        if (this.j != null) {
            throw new IllegalStateException("WebSocketClient objects are not reuseable");
        }
        this.j = new Thread(this);
        this.j.start();
    }

    public boolean d() throws InterruptedException {
        this.c();
        this.m.await();
        return this.e.isOpen();
    }

    @Override
    public void close() {
        if (this.j != null) {
            this.e.close(1000);
        }
    }

    public void e() throws InterruptedException {
        this.close();
        this.n.await();
    }

    @Override
    public void send(String string) throws NotYetConnectedException {
        this.e.send(string);
    }

    @Override
    public void send(byte[] byArray) throws NotYetConnectedException {
        this.e.send(byArray);
    }

    @Override
    protected Collection<WebSocket> connections() {
        return Collections.singletonList(this.e);
    }

    @Override
    public void sendPing() throws NotYetConnectedException {
        this.e.sendPing();
    }

    @Override
    public void run() {
        try {
            if (this.f == null) {
                this.f = new Socket(this.i);
            } else if (this.f.isClosed()) {
                throw new IOException();
            }
            this.f.setTcpNoDelay(this.isTcpNoDelay());
            if (!this.f.isBound()) {
                this.f.connect(new InetSocketAddress(this.c.getHost(), this.g()), this.o);
            }
            this.f.isConnected();
            this.g = this.f.getInputStream();
            this.h = this.f.getOutputStream();
            this.h();
        }
        catch (Exception exception) {
            this.onWebsocketError(this.e, exception);
            this.e.closeConnection(-1, exception.getMessage());
            return;
        }
        this.j = new Thread(new a());
        this.j.start();
        byte[] byArray = new byte[internal.org.java_websocket.h.c];
        try {
            int n;
            while (!this.isClosing() && !this.isClosed() && (n = this.g.read(byArray)) != -1) {
                this.e.a(ByteBuffer.wrap(byArray, 0, n));
            }
            this.e.b();
        }
        catch (IOException iOException) {
            this.e.b();
        }
        catch (RuntimeException runtimeException) {
            this.a(runtimeException);
            this.e.closeConnection(1006, runtimeException.getMessage());
        }
        assert (this.f.isClosed());
    }

    private int g() {
        int n = this.c.getPort();
        if (n == -1) {
            String string = this.c.getScheme();
            if (string.equals("wss")) {
                return 443;
            }
            if (string.equals("ws")) {
                return 80;
            }
            throw new RuntimeException("unknown scheme: " + string);
        }
        return n;
    }

    private void h() throws InvalidHandshakeException {
        String string = this.c.getRawPath();
        String string2 = this.c.getRawQuery();
        String string3 = string == null || string.length() == 0 ? "/" : string;
        if (string2 != null) {
            string3 = string3 + "?" + string2;
        }
        int n = this.g();
        String string4 = this.c.getHost() + (n != 80 ? ":" + n : "");
        d d2 = new d();
        d2.a(string3);
        d2.a("Host", string4);
        if (this.l != null) {
            for (Map.Entry<String, String> entry : this.l.entrySet()) {
                d2.a(entry.getKey(), entry.getValue());
            }
        }
        this.e.a(d2);
    }

    @Override
    public WebSocket.READYSTATE getReadyState() {
        return this.e.getReadyState();
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, String string) {
        this.a(string);
    }

    @Override
    public final void onWebsocketMessage(WebSocket webSocket, ByteBuffer byteBuffer) {
        this.a(byteBuffer);
    }

    @Override
    public void onWebsocketMessageFragment(WebSocket webSocket, Framedata framedata) {
        this.a(framedata);
    }

    @Override
    public final void onWebsocketOpen(WebSocket webSocket, f f2) {
        this.startConnectionLostTimer();
        this.a((internal.org.java_websocket.b.h)f2);
        this.m.countDown();
    }

    @Override
    public final void onWebsocketClose(WebSocket webSocket, int n, String string, boolean bl) {
        this.stopConnectionLostTimer();
        if (this.j != null) {
            this.j.interrupt();
        }
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        catch (IOException iOException) {
            this.onWebsocketError(this, iOException);
        }
        this.b(n, string, bl);
        this.m.countDown();
        this.n.countDown();
    }

    @Override
    public final void onWebsocketError(WebSocket webSocket, Exception exception) {
        this.a(exception);
    }

    @Override
    public final void onWriteDemand(WebSocket webSocket) {
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket webSocket, int n, String string) {
        this.a(n, string);
    }

    @Override
    public void onWebsocketClosing(WebSocket webSocket, int n, String string, boolean bl) {
        this.a(n, string, bl);
    }

    public void a(int n, String string) {
    }

    public void a(int n, String string, boolean bl) {
    }

    public WebSocket f() {
        return this.e;
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket webSocket) {
        if (this.f != null) {
            return (InetSocketAddress)this.f.getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket webSocket) {
        if (this.f != null) {
            return (InetSocketAddress)this.f.getRemoteSocketAddress();
        }
        return null;
    }

    public abstract void a(internal.org.java_websocket.b.h var1);

    public abstract void a(String var1);

    public abstract void b(int var1, String var2, boolean var3);

    public abstract void a(Exception var1);

    public void a(ByteBuffer byteBuffer) {
    }

    public void a(Framedata framedata) {
    }

    public void a(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException();
        }
        this.i = proxy;
    }

    public void a(Socket socket) {
        if (this.f != null) {
            throw new IllegalStateException("socket has already been set");
        }
        this.f = socket;
    }

    @Override
    public void sendFragmentedFrame(Framedata.Opcode opcode, ByteBuffer byteBuffer, boolean bl) {
        this.e.sendFragmentedFrame(opcode, byteBuffer, bl);
    }

    @Override
    public boolean isOpen() {
        return this.e.isOpen();
    }

    @Override
    public boolean isFlushAndClose() {
        return this.e.isFlushAndClose();
    }

    @Override
    public boolean isClosed() {
        return this.e.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.e.isClosing();
    }

    @Override
    public boolean isConnecting() {
        return this.e.isConnecting();
    }

    @Override
    public boolean hasBufferedData() {
        return this.e.hasBufferedData();
    }

    @Override
    public void close(int n) {
        this.e.close();
    }

    @Override
    public void close(int n, String string) {
        this.e.close(n, string);
    }

    @Override
    public void closeConnection(int n, String string) {
        this.e.closeConnection(n, string);
    }

    @Override
    public void send(ByteBuffer byteBuffer) throws IllegalArgumentException, NotYetConnectedException {
        this.e.send(byteBuffer);
    }

    @Override
    public void sendFrame(Framedata framedata) {
        this.e.sendFrame(framedata);
    }

    @Override
    public InetSocketAddress getLocalSocketAddress() {
        return this.e.getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return this.e.getRemoteSocketAddress();
    }

    @Override
    public String getResourceDescriptor() {
        return this.c.getPath();
    }

    private class a
    implements Runnable {
        private a() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("WebsocketWriteThread");
            try {
                while (!Thread.interrupted()) {
                    ByteBuffer byteBuffer = ((b)b.this).e.e.take();
                    b.this.h.write(byteBuffer.array(), 0, byteBuffer.limit());
                    b.this.h.flush();
                }
            }
            catch (IOException iOException) {
                b.this.e.b();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

