/*
 * Decompiled with CFR 0.152.
 */
package internal.org.apache.http.entity.mime;

import internal.org.apache.http.entity.mime.FormBodyPart;
import internal.org.apache.http.entity.mime.HttpMultipart;
import internal.org.apache.http.entity.mime.HttpMultipartMode;
import internal.org.apache.http.entity.mime.content.ContentBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

public class MultipartEntity
implements HttpEntity {
    private static final char[] MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private HttpMultipart multipart;
    private Header contentType;
    private long length;
    private volatile boolean dirty;

    public MultipartEntity(HttpMultipartMode httpMultipartMode, String string, Charset charset) {
        if (string == null) {
            string = MultipartEntity.generateBoundary();
        }
        if (httpMultipartMode == null) {
            httpMultipartMode = HttpMultipartMode.STRICT;
        }
        this.multipart = new HttpMultipart("form-data", charset, string, httpMultipartMode);
        this.contentType = new BasicHeader("Content-Type", this.generateContentType(string, charset));
        this.dirty = true;
    }

    public MultipartEntity(HttpMultipartMode httpMultipartMode) {
        this(httpMultipartMode, null, null);
    }

    public MultipartEntity() {
        this(HttpMultipartMode.STRICT, null, null);
    }

    protected String generateContentType(String string, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("multipart/form-data; boundary=");
        stringBuilder.append(string);
        if (charset != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(charset.name());
        }
        return stringBuilder.toString();
    }

    public static String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n = random.nextInt(11) + 30;
        for (int k = 0; k < n; ++k) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        return stringBuilder.toString();
    }

    public void addPart(FormBodyPart formBodyPart) {
        this.multipart.addBodyPart(formBodyPart);
        this.dirty = true;
    }

    public void addPart(String string, ContentBody contentBody) {
        this.addPart(new FormBodyPart(string, contentBody));
    }

    public boolean isRepeatable() {
        for (FormBodyPart formBodyPart : this.multipart.getBodyParts()) {
            ContentBody contentBody = formBodyPart.getBody();
            if (contentBody.getContentLength() >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        if (this.dirty) {
            this.length = this.multipart.getTotalLength();
            this.dirty = false;
        }
        return this.length;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Multipart form entity does not implement #getContent()");
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.multipart.writeTo(outputStream);
    }

    public Header getContentEncoding() {
        return null;
    }

    public Header getContentType() {
        return this.contentType;
    }
}

