/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.superrtc.call.EglBase;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

final class EglBase10
extends EglBase {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private final EGL10 egl;
    private EGLContext eglContext;
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;

    EglBase10(Context context, int[] nArray) {
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.getEglDisplay();
        this.eglConfig = this.getEglConfig(this.eglDisplay, nArray);
        this.eglContext = this.createEglContext(context, this.eglDisplay, this.eglConfig);
    }

    @Override
    public void createSurface(Surface surface) {
        class FakeSurfaceHolder
        implements SurfaceHolder {
            private final Surface surface;

            FakeSurfaceHolder(Surface surface) {
                this.surface = surface;
            }

            public void addCallback(SurfaceHolder.Callback callback) {
            }

            public void removeCallback(SurfaceHolder.Callback callback) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int n) {
            }

            public void setFixedSize(int n, int n2) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int n) {
            }

            public void setKeepScreenOn(boolean bl) {
            }

            public Canvas lockCanvas() {
                return null;
            }

            public Canvas lockCanvas(Rect rect) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas canvas) {
            }

            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        this.createSurfaceInternal(new FakeSurfaceHolder(surface));
    }

    @Override
    public void createSurface(SurfaceTexture surfaceTexture) {
        this.createSurfaceInternal(surfaceTexture);
    }

    private void createSurfaceInternal(Object object) {
        if (!(object instanceof SurfaceHolder) && !(object instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] nArray = new int[]{12344};
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, object, nArray);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface");
        }
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int n, int n2) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] nArray = new int[]{12375, n, 12374, n2, 12344};
        this.eglSurface = this.egl.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, nArray);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create pixel buffer surface");
        }
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, nArray);
        return nArray[0];
    }

    @Override
    public int surfaceHeight() {
        int[] nArray = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, nArray);
        return nArray[0];
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY || this.eglContext == EGL10.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
        this.egl.eglTerminate(this.eglDisplay);
        this.eglContext = EGL10.EGL_NO_CONTEXT;
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    @Override
    public void detachCurrent() {
        if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
            throw new RuntimeException("eglMakeCurrent failed");
        }
    }

    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay eGLDisplay = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (eGLDisplay == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL10 display");
        }
        int[] nArray = new int[2];
        if (!this.egl.eglInitialize(eGLDisplay, nArray)) {
            throw new RuntimeException("Unable to initialize EGL10");
        }
        return eGLDisplay;
    }

    private EGLConfig getEglConfig(EGLDisplay eGLDisplay, int[] nArray) {
        EGLConfig[] eGLConfigArray = new EGLConfig[1];
        int[] nArray2 = new int[1];
        if (!this.egl.eglChooseConfig(eGLDisplay, nArray, eGLConfigArray, eGLConfigArray.length, nArray2)) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        return eGLConfigArray[0];
    }

    private EGLContext createEglContext(Context context, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
        int[] nArray;
        if (context != null && context.eglContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        EGLContext eGLContext = context == null ? EGL10.EGL_NO_CONTEXT : context.eglContext;
        EGLContext eGLContext2 = this.egl.eglCreateContext(eGLDisplay, eGLConfig, eGLContext, nArray = new int[]{12440, 2, 12344});
        if (eGLContext2 == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Failed to create EGL context");
        }
        return eGLContext2;
    }

    public static class Context
    extends EglBase.Context {
        private final EGLContext eglContext;

        public Context(EGLContext eGLContext) {
            this.eglContext = eGLContext;
        }
    }
}

