/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FileUtils {
    public static String[] fileTypes = new String[]{"apk", "avi", "bmp", "chm", "dll", "doc", "docx", "dos", "gif", "html", "jpeg", "jpg", "movie", "mp3", "dat", "mp4", "mpe", "mpeg", "mpg", "pdf", "png", "ppt", "pptx", "rar", "txt", "wav", "wma", "wmv", "xls", "xlsx", "xml", "zip"};

    public static File[] loadFiles(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            if (!file2.isFile()) continue;
            arrayList2.add(file2);
        }
        MyComparator myComparator = new MyComparator();
        Collections.sort(arrayList, myComparator);
        Collections.sort(arrayList2, myComparator);
        File[] fileArray2 = new File[arrayList.size() + arrayList2.size()];
        System.arraycopy(arrayList.toArray(new File[arrayList.size()]), 0, fileArray2, 0, arrayList.size());
        System.arraycopy(arrayList2.toArray(new File[arrayList2.size()]), 0, fileArray2, arrayList.size(), arrayList2.size());
        return fileArray2;
    }

    public static String getMIMEType(File file) {
        String string = "";
        String string2 = file.getName();
        String string3 = string2.substring(string2.lastIndexOf(".") + 1, string2.length()).toLowerCase();
        string = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string;
    }

    public static String getMIMEType(String string) {
        String string2 = "";
        String string3 = string.substring(string.lastIndexOf(".") + 1, string.length()).toLowerCase();
        string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
        return string2;
    }

    public static void openFile(File file, Activity activity) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        String string = FileUtils.getMIMEType(file);
        intent.setDataAndType(Uri.fromFile((File)file), string);
        try {
            activity.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)"Can't find proper app to open this file", (int)1).show();
        }
    }

    public static void openFile(Uri uri, String string, Activity activity) {
        Intent intent = new Intent();
        intent.addFlags(0x10000000);
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(uri, string);
        try {
            activity.startActivity(intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toast.makeText((Context)activity, (CharSequence)"Can't find proper app to open this file", (int)1).show();
        }
    }

    public static synchronized void saveObjectToFile(Object object, File file) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public static synchronized Object readObjectFromFile(File file) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        return objectInputStream.readObject();
    }

    public static class MyComparator
    implements Comparator<File> {
        @Override
        public int compare(File file, File file2) {
            return file.getName().compareTo(file2.getName());
        }
    }
}

