/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.text.TextUtils;
import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMPushConfigs;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAPushConfigs;
import com.hyphenate.chat.adapter.EMAPushManager;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class EMPushManager {
    private static final String TAG = EMPushManager.class.getSimpleName();
    EMClient mClient;
    EMAPushManager emaObject;

    EMPushManager(EMClient eMClient, EMAPushManager eMAPushManager) {
        this.emaObject = eMAPushManager;
        this.mClient = eMClient;
    }

    public void enableOfflinePush() throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.enableOfflineNotification(eMAError);
        this.handleError(eMAError);
    }

    public void disableOfflinePush(int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.disableOfflineNotification(n, n2, eMAError);
        this.handleError(eMAError);
    }

    public EMPushConfigs getPushConfigs() {
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigs();
        if (eMAPushConfigs == null) {
            return null;
        }
        return new EMPushConfigs(eMAPushConfigs);
    }

    public EMPushConfigs getPushConfigsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAPushConfigs eMAPushConfigs = this.emaObject.getPushConfigsFromServer(eMAError);
        this.handleError(eMAError);
        return new EMPushConfigs(eMAPushConfigs);
    }

    public void updatePushServiceForGroup(List<String> list, boolean bl) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.updatePushServiceForGroup(list, bl, eMAError);
        this.handleError(eMAError);
    }

    public List<String> getNoPushGroups() {
        return this.emaObject.getNoPushGroups();
    }

    public boolean updatePushNickname(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            EMLog.e(TAG, "nick name is null or empty");
            return false;
        }
        String string2 = EMClient.getInstance().getCurrentUser();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            EMLog.e(TAG, "currentUser is null or empty");
            return false;
        }
        String string3 = EMClient.getInstance().getAccessToken();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            EMLog.e(TAG, "token is null or empty");
            return false;
        }
        String string4 = EMClient.getInstance().getChatConfigPrivate().f();
        StringBuilder stringBuilder = new StringBuilder(string4);
        stringBuilder.append("/");
        stringBuilder.append("users/");
        stringBuilder.append(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + string3);
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("nickname", (Object)string);
            Pair<Integer, String> pair = EMHttpClient.getInstance().sendRequest(stringBuilder.toString(), hashMap, jSONObject.toString(), EMHttpClient.PUT);
            String string5 = (String)pair.second;
            if (string5.contains("error")) {
                EMLog.e(TAG, "response error : " + string5);
                return false;
            }
        }
        catch (Exception exception) {
            EMLog.e(TAG, "error:" + exception.getMessage());
            return false;
        }
        return true;
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }
}

