/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.media;

import android.content.Context;
import android.util.AttributeSet;
import com.superrtc.sdk.VideoView;
import com.superrtc.sdk.VideoViewRenderer;

/*!
 * Created by lzan13 on 2017/5/10.
 *
 * \~chinese
 * 视频通话UI显示视图，
 * 这里将原来的 EMLocalSurfaceView 和 EMOppositeSurfaceView 合并，方便 App 层面切换通话视图
 *
 * \~english
 * The video call UI displays the view,
 * Here the original EMLocalSurfaceView and EMOppositeSurfaceView merger, to facilitate the realization of UI size switch
 */
public class EMCallSurfaceView extends VideoView {
    private VideoViewRenderer renderer;

    public EMCallSurfaceView(Context context) {
        this(context, null);
    }

    public EMCallSurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EMCallSurfaceView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        renderer = new VideoViewRenderer(this, "CallView");
    }

    public VideoViewRenderer getRenderer() {
        return renderer;
    }

    public void release() {
        renderer = null;
    }
}
