package com.hyphenate.chat;

import com.superrtc.mediamanager.EMediaSession;

/**
 * Created by lzan13 on 2017/8/16.
 * \~chinese
 * 本地推流配置信息类
 *
 * \~english
 * Local publish stream config
 */
public class EMStreamParam extends EMediaSession.EMediaPublishConfiguration {

    public EMStreamParam() {
        videoOff = false;
        mute = false;
    }

    /**
     * \~chinese
     * 获取推流配置名称
     *
     * \~english
     * Get local publish stream name
     */
    public String getName() {
        return name;
    }

    /**
     * \~chinese
     * 设置本地推流名称
     *
     * \~english
     * Set local publish stream name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * \~chinese
     * 是否关闭视频
     *
     * \~english
     * Whether to turn off the video
     */
    public boolean isVideoOff() {
        return videoOff;
    }

    /**
     * \~chinese
     * 设置是否关闭视频
     *
     * \~english
     * Set whether to turn off the video
     */
    public void setVideoOff(boolean videoOff) {
        this.videoOff = videoOff;
    }

    /**
     * \~chinese
     * 是否静音
     *
     * \~english
     * Whether mute
     */
    public boolean isMute() {
        return mute;
    }

    /**
     * \~chinese
     * 设置静音
     *
     * \~english
     * Set whether mute
     */
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    /**
     * \~chinese
     * 获取推流扩展
     *
     * \~english
     * Get publish stream extension
     */
    public String getExtension() {
        return extension;
    }

    /**
     * \~chinese
     * 设置推流扩展信息
     *
     * \~english
     * Set local publish stream extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /**
     * \~chinese
     * 使用后置摄像头 默认为 false
     *
     * @param useBackCamera 使用后置摄像头
     *
     * \~english
     * Use back camera, default false
     *
     * @param useBackCamera Use back camera
     */
    public void setUseBackCamera(boolean useBackCamera) {
        this.useBackCamera = useBackCamera;
    }
}

