/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.mediamanager;

import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import com.superrtc.call.NetworkMonitorAutoDetect;
import com.superrtc.mediamanager.EMediaDefines;
import com.superrtc.mediamanager.EMediaEntities;
import com.superrtc.mediamanager.EMediaSession;
import com.superrtc.mediamanager.EMediaSessionInvoker;
import com.superrtc.mediamanager.EMediaStream;
import com.superrtc.mediamanager.RtcConnectionExt;
import com.superrtc.mediamanager.SRWebSocketExt;
import com.superrtc.mediamanager.XClientBridger;
import com.superrtc.mediamanager.XReachability;
import com.superrtc.sdk.RtcConnection;
import com.superrtc.sdk.VideoViewRenderer;
import com.superrtc.util.LooperExecutor;
import com.superrtc.util.RTCCallback;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class EMediaManager {
    private static final String TAG = "EMediaManager";
    private static LooperExecutor executor;
    private EMediaSession.EMediaSessionDelegate sessiondelegate;
    private String sessionticket;
    private static boolean iscreatemediamanager;
    public static EMediaManager instance;
    private ManagerData mgrData;
    private JSONObject ticketDict;
    private EMediaSession session;
    EMediaSessionInvoker invoker;
    static final String letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    static long idnum;
    private Timer timer;
    private SRWebSocketExt websockext;
    private static Context applicationContext;
    XReachability internetReachability;
    private static final String INVOKE_OP_CONN_OPEN = "connOpened";
    private static final String INVOKE_OP_CONN_FAIL = "connFail";
    private static final String INVOKE_OP_CONN_CLOSE = "connClosed";
    private static final String INVOKE_OP_TIMER = "timerCheck";
    private static final String INVOKE_OP_TRYTKT = "tryTicket";
    private static final String INVOKE_OP_EXITTKT = "exitTicket";
    private static final String INVOKE_OP_SUBSR = "subscribe";
    private static final String INVOKE_OP_USUBSR = "unsubscribe";
    private static final String INVOKE_OP_RTC_SETSDP = "setLocalSDP";
    private static final String INVOKE_OP_RTC_SETCAND = "setLocalCand";
    private static final String INVOKE_OP_RTC_CAND_DONE = "candDone";
    private static final String INVOKE_OP_RTC_SETUP = "rtcSetup";
    private static final String INVOKE_OP_RTC_RECONN = "rtcReconn";
    private static final String INVOKE_OP_RTC_DISCONN = "rtcDisconn";
    private static final String INVOKE_OP_RTC_CLOSED = "rtcClosed";
    private static final String INVOKE_OP_RTC_ERROR = "rtcError";
    private static final String INVOKE_OP_RTC_UPDATE = "rtcUpd";
    private static final String INVOKE_OP_RTC_STATIS = "rtcStatis";
    private static final String INVOKE_OP_PUBLISH = "publish";
    private static final String INVOKE_OP_UNPUBLISH = "unpublish";
    private static final String INVOKE_OP_CAMERACTRL = "cameraCtrl";
    private static final String INVOKE_OP_NETCHANGED = "netChanged";
    private static final String INVOKE_OP_ERR_DESC = "errDesc";
    private static final int XSESSION_EVENT_OPEN_CONN = 1002;
    private static final int XSESSION_EVENT_ENTER = 1004;
    private static final int XSESSION_EVENT_PASSIVE_EXIT = 1005;
    private static final int XSESSION_EVENT_CLOSE_CONN = 1008;
    private static final int XSESSION_EVENT_CALLING = 1010;
    private static final int XSESSION_EVENT_RINGING = 1012;
    private static final int XSESSION_EVENT_MEMBER_JOIN = 1020;
    private static final int XSESSION_EVENT_MEMBER_EXIT = 1022;
    private static final int XSESSION_EVENT_STREAM_PUB = 1030;
    private static final int XSESSION_EVENT_STREAM_UNPUB = 1032;
    private static final int XSESSION_EVENT_STREAM_UPDATE = 1034;
    private static final int XSESSION_EVENT_OPEN_RTC = 1040;
    private static final int XSESSION_EVENT_CLOSE_RTC = 1042;
    private static final int XSESSION_EVENT_SET_MYRTC = 1044;
    private static final int XSESSION_EVENT_SUBSR = 1046;
    private static final int XSESSION_EVENT_CREATE_OFFER = 1050;
    private static final int XSESSION_EVENT_REMOTE_SDP = 1053;
    private static final int XSESSION_EVENT_REMOTE_CAND = 1054;
    private static final int XSESSION_EVENT_CAMERACTRL = 1056;
    private static final int XSESSION_EVENT_NOTIFY = 1058;
    private static EMediaManagerListener managerListener;
    private static int cameraid;
    private boolean isunpub = false;
    private int unpubcameraid = -1;
    private RtcConnection.Listener rtclistener = new RtcConnection.Listener(){

        @Override
        public void onLocalSdp(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetLocalSdp")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("sdp", (Object)string);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETSDP);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onLocalCandidate(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetLocalCandidate")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("cand", (Object)string);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETCAND);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onConnected(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didReconnect")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_RECONN);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (managerListener != null) {
                        managerListener.onConnected(rtcConnection.name);
                    }
                }
            });
        }

        @Override
        public void onConnectionsetup(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didSetup")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_SETUP);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (managerListener != null) {
                        managerListener.onConnectionsetup(rtcConnection.name);
                    }
                }
            });
        }

        @Override
        public void onDisconnected(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didDisconnect")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_DISCONN);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (managerListener != null) {
                        managerListener.onDisconnected(rtcConnection.name);
                    }
                }
            });
        }

        @Override
        public void onCandidateCompleted(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didLocalCandidateComplete")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CAND_DONE);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onClosed(final RtcConnection rtcConnection) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didClose")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_CLOSED);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onStats(final RtcConnection rtcConnection, final RtcConnection.RtcStatistics rtcStatistics) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didGetStats")) {
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_STATIS);
                        jSONObject.put("rtt", rtcStatistics.localVideoRtt);
                        jSONObject.put("llostratev", rtcStatistics.localVideoPacketsLostrate);
                        jSONObject.put("llostratea", rtcStatistics.localAudioPacketsLostrate);
                        jSONObject.put("rlostratev", rtcStatistics.remoteVideoPacketsLostrate);
                        jSONObject.put("rlostratea", rtcStatistics.remoteAudioPacketsLostrate);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }

        @Override
        public void onError(final RtcConnection rtcConnection, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (!EMediaManager.this.checkExistSameRtc((RtcConnectionExt)rtcConnection, "didError")) {
                        return;
                    }
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "rtc error: [" + rtcConnection.name + "]->[" + string + "]");
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("rtcId", (Object)rtcConnection.name);
                        jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_ERROR);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                }
            });
        }
    };
    private SRWebSocketExt.SRWebSocketDelegate sockdelegate = new SRWebSocketExt.SRWebSocketDelegate(){

        @Override
        public void invokeConnWithWebsocket(final SRWebSocketExt sRWebSocketExt, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession eMediaSession = EMediaManager.this.checkExistSameWebsocket(sRWebSocketExt, string);
                    if (eMediaSession == null) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "non-exist session [" + sRWebSocketExt.name + "] for op [" + string + "]");
                        return;
                    }
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put("connId", (Object)eMediaSession.instanceId);
                        jSONObject.put("op", (Object)string);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    if (n != 0) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "invokeConnWithWebsocket : fail with " + n);
                    }
                }
            });
        }

        @Override
        public void webSocketDidOpen(SRWebSocketExt sRWebSocketExt) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: webSocketDidOpen " + sRWebSocketExt.name);
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_OPEN);
        }

        @Override
        public void didReceiveMessageWithString(final SRWebSocketExt sRWebSocketExt, final String string) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EMediaSession eMediaSession = EMediaManager.this.checkExistSameWebsocket(sRWebSocketExt, "recvString");
                    if (eMediaSession == null) {
                        return;
                    }
                    logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didReceiveMessageWithString " + sRWebSocketExt.name + " recvmesg:" + string);
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.jsonrecvstring(eMediaSession.instanceId, string);
                }
            });
        }

        @Override
        public void didReceiveMessageWithData(SRWebSocketExt sRWebSocketExt, byte[] byArray) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didReceiveMessageWithData");
        }

        @Override
        public void didFailWithError(SRWebSocketExt sRWebSocketExt, Exception exception) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "webSocket: didFailWithError, " + exception);
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_FAIL);
        }

        @Override
        public void didCloseWithCode(SRWebSocketExt sRWebSocketExt, int n, String string, boolean bl) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "webSocket: didCloseWithCode, code=[" + n + "], reason=[" + string + "], wasClean=[" + bl + "]");
            this.invokeConnWithWebsocket(sRWebSocketExt, EMediaManager.INVOKE_OP_CONN_CLOSE);
        }

        @Override
        public void didReceivePong(SRWebSocketExt sRWebSocketExt, byte[] byArray) {
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "WebSocket received pong, " + byArray);
        }
    };
    private XClientBridger.XClientBridgerDelegate xdelegate = new XClientBridger.XClientBridgerDelegate(){

        @Override
        public int onJsonSendWithConn(String string, String string2) {
            EMediaSession eMediaSession = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(string);
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "onJsonSendWithConn  send msg:" + string2);
            eMediaSession.websocket.send(string2);
            return 0;
        }

        public EMediaDefines.EMediaStreamType wrapStreamType(int n) {
            for (EMediaDefines.EMediaStreamType eMediaStreamType : EMediaDefines.EMediaStreamType.values()) {
                if (eMediaStreamType.val != n) continue;
                return eMediaStreamType;
            }
            throw new RuntimeException("Json str. error on = " + n);
        }

        @Override
        public JSONObject onJsonCallback(JSONObject jSONObject) throws JSONException, URISyntaxException {
            int n = 0;
            JSONObject jSONObject2 = new JSONObject();
            String string = jSONObject.optString("op");
            logcallback.onLog(logLevel.LS_INFO.ordinal(), "onJsonCallback dict::" + jSONObject.toString());
            if (string.equals("onEvent")) {
                long l = jSONObject.optInt("event");
                String string2 = jSONObject.optString("connId");
                final EMediaSession eMediaSession = ((EMediaManager)EMediaManager.this).mgrData.connDict.get(string2);
                if (eMediaSession == null) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "onEvent: can't find conn [" + string2 + "]");
                } else {
                    logcallback.onLog(logLevel.LS_INFO.ordinal(), "onEvent: connId=[" + string2 + "] event=[" + l + "]");
                    String string3 = null;
                    if (jSONObject.has("argStr")) {
                        string3 = jSONObject.getString("argStr");
                    }
                    int n2 = 0;
                    if (jSONObject.has("argInt")) {
                        n2 = jSONObject.getInt("argInt");
                    }
                    if (l == 1002L) {
                        String string4 = string3;
                        boolean bl = false;
                        if (eMediaSession.websocket != null) {
                            eMediaSession.websocket.close();
                            eMediaSession.websocket = null;
                            bl = true;
                        }
                        EMediaManager.this.websockext = new SRWebSocketExt(string4, EMediaManager.this.sockdelegate, eMediaSession.instanceId);
                        eMediaSession.websocket = EMediaManager.this.websockext;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + eMediaSession.instanceId + "] -> [" + eMediaSession.websocket.url + "]");
                        eMediaSession.websocket.open();
                        if (bl) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopening websocket [" + eMediaSession.instanceId + "][" + eMediaSession.websocket + "] -> [" + string4 + "%@]");
                        } else {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "opening websocket [" + eMediaSession.instanceId + "][" + eMediaSession.websocket + "] -> [" + string4 + "%@]");
                        }
                    } else if (l == 1004L) {
                        int n3 = 0;
                        if (n2 != 0) {
                            n3 = n2;
                        }
                        if (n3 == 0) {
                            EMediaManager.this.invoker.invokeBlock(eMediaSession.joinBlock, string3, null, eMediaSession);
                        } else {
                            EMediaManager.this.closeSession(eMediaSession);
                            EMediaEntities.EMediaError eMediaError = EMediaManager.this.newErrorWithCode(n3, string3);
                            EMediaManager.this.invoker.invokeBlock(eMediaSession.joinBlock, eMediaSession, eMediaError, eMediaSession);
                        }
                        eMediaSession.joinBlock = null;
                    } else if (l == 1005L) {
                        int n4 = n2;
                        EMediaManager.this.invoker.invokeOnExitConference(n4, string3, eMediaSession);
                    } else if (l == 1020L) {
                        EMediaEntities.EMediaMember eMediaMember = new EMediaEntities.EMediaMember(string3, jSONObject.optString("ext"));
                        EMediaManager.this.invoker.invokeOnMemberJoin(eMediaMember, eMediaSession);
                    } else if (l == 1022L) {
                        int n5 = 0;
                        if (n2 != 0) {
                            n5 = n2;
                        }
                        String string5 = null;
                        string5 = jSONObject.has("ext") ? jSONObject.getString("ext") : "";
                        EMediaEntities.EMediaMember eMediaMember = new EMediaEntities.EMediaMember(string3, string5);
                        EMediaManager.this.invoker.invokeOnMemberExit(eMediaMember, eMediaSession, n5);
                    } else if (l == 1030L || l == 1032L || l == 1034L) {
                        EMediaStream eMediaStream = new EMediaStream(string3, jSONObject.optString("memName"), this.wrapStreamType(jSONObject.optInt("streamType")), jSONObject.optString("streamName"), jSONObject.optInt("voff") != 0, jSONObject.optInt("aoff") != 0, jSONObject.optString("ext"));
                        if (l == 1030L) {
                            EMediaManager.this.invoker.invokeOnStreamPublish(eMediaStream, eMediaSession);
                        } else if (l == 1032L) {
                            EMediaManager.this.invoker.invokeOnStopStream(eMediaStream, eMediaSession);
                        } else {
                            EMediaManager.this.invoker.invokeOnUpdateStream(eMediaStream, eMediaSession);
                        }
                    } else if (l == 1044L) {
                        ((EMediaManager)EMediaManager.this).mgrData.myRtcId = string3;
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "set myRtcId: " + ((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null) {
                            RtcConnectionExt rtcConnectionExt;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = eMediaSession;
                            if (((EMediaManager)EMediaManager.this).mgrData.localViewRender != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string3)) != null) {
                                rtcConnectionExt.setListener(EMediaManager.this.rtclistener);
                                rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                    } else if (l == 1046L) {
                        String string6 = string3;
                        String string7 = jSONObject.optString("subsrId");
                        ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.put(string7, string6);
                        if (string6 != null) {
                            RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string6);
                            rtcConnectionExt.setListener(EMediaManager.this.rtclistener);
                            EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string7);
                            if (rtcConnectionExt != null && eMediaStreamSubscription != null && eMediaStreamSubscription.view != null) {
                                rtcConnectionExt.setViews(null, eMediaStreamSubscription.view);
                            }
                        } else {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string7);
                        }
                    } else if (l == 1040L) {
                        String string8 = string3;
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string8);
                        boolean bl = false;
                        VideoViewRenderer videoViewRenderer = null;
                        VideoViewRenderer videoViewRenderer2 = null;
                        if (rtcConnectionExt != null) {
                            videoViewRenderer = rtcConnectionExt.localViewRender;
                            videoViewRenderer2 = rtcConnectionExt.remoteViewRender;
                            rtcConnectionExt.hangup();
                            bl = true;
                        }
                        rtcConnectionExt = new RtcConnectionExt(string8);
                        rtcConnectionExt.ownConn = eMediaSession;
                        rtcConnectionExt.setListener(EMediaManager.this.rtclistener);
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.put(rtcConnectionExt.name, rtcConnectionExt);
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "new rtc " + rtcConnectionExt.name);
                        if (bl) {
                            logcallback.onLog(logLevel.LS_INFO.ordinal(), "reopen rtc " + rtcConnectionExt.name);
                            if (videoViewRenderer != null && videoViewRenderer2 != null) {
                                rtcConnectionExt.setViews(videoViewRenderer, videoViewRenderer2);
                            } else if (videoViewRenderer2 != null) {
                                rtcConnectionExt.setViews(null, videoViewRenderer2);
                            } else if (videoViewRenderer != null) {
                                rtcConnectionExt.setViews(videoViewRenderer, null);
                            }
                        }
                    } else if (l == 1042L) {
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string3);
                        if (rtcConnectionExt == null) {
                            return null;
                        }
                        rtcConnectionExt.hangup();
                        ((EMediaManager)EMediaManager.this).mgrData.rtcDict.remove(string3);
                        if (rtcConnectionExt.name == ((EMediaManager)EMediaManager.this).mgrData.myRtcId) {
                            ((EMediaManager)EMediaManager.this).mgrData.myRtcId = null;
                            ((EMediaManager)EMediaManager.this).mgrData.pubSession = null;
                        }
                    } else if (l == 1008L) {
                        EMediaManager.this.closeSession(eMediaSession);
                    } else if (l == 1050L) {
                        int n6;
                        int n7;
                        String string9 = jSONObject.optString("rtcId");
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string9);
                        String string10 = null;
                        if (jSONObject.has("config")) {
                            string10 = jSONObject.optString("config");
                        }
                        if (rtcConnectionExt == null) {
                            return null;
                        }
                        if (EMediaManager.this.isunpub) {
                            EMediaManager.this.isunpub = false;
                            if (EMediaManager.this.unpubcameraid != -1) {
                                RtcConnectionExt.setCameraFacing(EMediaManager.this.unpubcameraid);
                            }
                        } else {
                            RtcConnectionExt.setCameraFacing(cameraid);
                        }
                        if (string10 != null) {
                            rtcConnectionExt.setConfigure(string10);
                        }
                        if ((n7 = jSONObject.optInt("voff")) != 0 && (n6 = 1) != 0) {
                            rtcConnectionExt.stopCapture();
                        }
                        if ((n6 = jSONObject.optInt("aoff")) != 0) {
                            boolean bl = true;
                            rtcConnectionExt.setMute(bl);
                        }
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "creating offer...");
                        rtcConnectionExt.createOffer();
                    } else if (l == 1053L || l == 1054L) {
                        String string11 = null;
                        if (jSONObject.has("rtcId")) {
                            string11 = jSONObject.getString("rtcId");
                        }
                        String string12 = null;
                        if (jSONObject.has("sdp")) {
                            string12 = jSONObject.getString("sdp");
                        }
                        String string13 = null;
                        if (jSONObject.has("cand")) {
                            string13 = jSONObject.getString("cand");
                        }
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string11);
                        if (string12 != null && rtcConnectionExt != null) {
                            try {
                                rtcConnectionExt.setRemoteJson(string12);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        if (string13 != null && rtcConnectionExt != null) {
                            try {
                                rtcConnectionExt.setRemoteJson(string13);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else if (l == 1056L) {
                        String string14 = jSONObject.optString("rtcId");
                        int n8 = jSONObject.optInt("x");
                        int n9 = jSONObject.optInt("y");
                        int n10 = jSONObject.optInt("focus");
                        int n11 = jSONObject.optInt("expo");
                        int n12 = jSONObject.optInt("zoom");
                        int n13 = jSONObject.optInt("pic");
                        RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                        if (string14.endsWith(((EMediaManager)EMediaManager.this).mgrData.myRtcId) && rtcConnectionExt != null) {
                            if (n10 >= 0 || n11 >= 0) {
                                n10 = n10 > 0 ? 1 : 0;
                                n11 = n11 > 0 ? 1 : 0;
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: interestAt x=[" + n8 + "], y=[" + n9 + "], focus=" + n10 + ", expo=" + n11);
                                rtcConnectionExt.interestAt(n8, n9, n10, n11, true);
                            }
                            if (n12 >= 0) {
                                Float f2 = Float.valueOf((float)((double)n12 / 10000.0));
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "remote-camera: zoom factor [" + f2 + "]");
                                rtcConnectionExt.zoomWithFactor(f2);
                            }
                            if (n13 > 0) {
                                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- command --");
                                rtcConnectionExt.takeCameraPicture(new RTCCallback(){

                                    @Override
                                    public void onDone(Object object) {
                                        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "Take picture -- success --" + object);
                                        eMediaSession.delegate.notice(eMediaSession, EMediaDefines.EMediaNoticeCode.EMEDIA_NOTICE_TAKE_CAMERA_PICTURE, null, null, object);
                                    }
                                });
                            }
                        }
                    } else if (l == 1058L) {
                        String string15 = jSONObject.optString("arg2");
                        EMediaManager.this.invoker.invokeOnNotice(EMediaManager.wrapENoticeCode(n2), string3, string15, null, eMediaSession);
                    }
                }
            }
            jSONObject2.put("op", (Object)"rsp");
            jSONObject2.put("status", n);
            return jSONObject2;
        }
    };
    private static XClientBridger.Logcallbackfunc logcallback;

    public static void setManagerListener(EMediaManagerListener eMediaManagerListener) {
        managerListener = eMediaManagerListener;
    }

    public static EMediaDefines.EMediaNoticeCode wrapENoticeCode(int n) {
        for (EMediaDefines.EMediaNoticeCode eMediaNoticeCode : EMediaDefines.EMediaNoticeCode.values()) {
            if (eMediaNoticeCode.noticeCode != n) continue;
            return eMediaNoticeCode;
        }
        throw new RuntimeException("Json str. error on = " + n);
    }

    public void setVideoViews(final String string, final VideoViewRenderer videoViewRenderer, final VideoViewRenderer videoViewRenderer2, final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoViews ,streamId=[" + string + "] ,localview=[" + videoViewRenderer + "] ,remoteview=[" + videoViewRenderer2 + "] ,islocal=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (bl) {
                    RtcConnectionExt rtcConnectionExt;
                    ((EMediaManager)EMediaManager.this).mgrData.localViewRender = videoViewRenderer;
                    if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                        rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                    }
                } else {
                    String string3 = EMediaManager.this.getSubcribeId(string);
                    if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string3) != null) {
                        if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get((Object)string3).view != videoViewRenderer2) {
                            ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string3);
                            String string2 = ((EMediaManager)EMediaManager.this).mgrData.subscribidRtcid.get(string3);
                            if (string2 == null) {
                                logcallback.onLog(logLevel.LS_INFO.ordinal(), "rtcId is not exit");
                                return;
                            }
                            RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(string2);
                            if (rtcConnectionExt != null) {
                                rtcConnectionExt.setViews(null, videoViewRenderer2);
                                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                                eMediaStreamSubscription.subscribeId = string3;
                                eMediaStreamSubscription.view = videoViewRenderer2;
                                ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string3, eMediaStreamSubscription);
                            }
                        }
                    } else {
                        EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                        eMediaStreamSubscription.subscribeId = string3;
                        eMediaStreamSubscription.view = videoViewRenderer2;
                        ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string3, eMediaStreamSubscription);
                    }
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setVideoViews ");
            }
        });
    }

    private String generateString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int k = 0; k < n; ++k) {
            int n2 = Math.round(letters.length() - 1);
            stringBuilder.append(letters.charAt(n2));
        }
        return stringBuilder.toString();
    }

    private String generateRTCId() {
        return "rtc-" + ++idnum + "-" + this.generateString(3);
    }

    public EMediaSession newSessionWithTicket(String string, String string2, EMediaSession.EMediaSessionDelegate eMediaSessionDelegate) throws JSONException {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ newSessionWithTicket ,aTicket=[" + string + "]");
        if (string == null) {
            Log.i((String)TAG, (String)"ticket is null");
        }
        JSONTokener jSONTokener = new JSONTokener(string);
        JSONObject jSONObject = (JSONObject)jSONTokener.nextValue();
        this.session = new EMediaSession(this, string, jSONObject, string2);
        this.session.delegate = eMediaSessionDelegate;
        EMediaSession.delegateQueue = executor;
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- newSessionWithTicket ");
        return this.session;
    }

    public void setSession(final EMediaSession eMediaSession, final String string) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                eMediaSession.nickName = string;
            }
        });
    }

    public static EMediaManager getInstance() {
        if (instance == null) {
            instance = new EMediaManager();
        }
        return instance;
    }

    public static void initGlobal(Context context) {
        applicationContext = context;
        executor = new LooperExecutor();
        executor.requestStart();
        try {
            RtcConnection.initGlobal(context, executor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public EMediaManager() {
        this.mgrData = new ManagerData();
        this.mgrData.workQueue = executor;
        this.mgrData.bridger = new XClientBridger(this.xdelegate);
        this.mgrData.myRtcId = null;
        this.invoker = new EMediaSessionInvoker();
        this.setNetChangedDelegate();
    }

    public void setNetChangedDelegate() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.bridger != null) {
                    ((EMediaManager)EMediaManager.this).mgrData.bridger.setlogfunc(logcallback);
                }
                XReachability.init(applicationContext);
                XReachability.getInstance().addNetworkObserver(new XReachability.NetworkObserver(){

                    @Override
                    public void onConnectionTypeChanged(NetworkMonitorAutoDetect.ConnectionType connectionType) {
                        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "onConnectionTypeChanged connectionType:" + connectionType.name());
                        XReachability.XNetworkStatus xNetworkStatus = XReachability.getInstance().currentReachabilityStatus(connectionType);
                        logcallback.onLog(logLevel.LS_INFO.ordinal(), "onConnectionTypeChanged netStatus: " + xNetworkStatus.ordinal());
                        JSONObject jSONObject = new JSONObject();
                        try {
                            jSONObject.put("netStatus", xNetworkStatus.ordinal());
                            jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_NETCHANGED);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                        ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                    }
                });
                XReachability.getInstance().startMonitoring();
            }
        });
    }

    public static void setLoggerDelegate(XClientBridger.Logcallbackfunc logcallbackfunc) {
        logcallback = logcallbackfunc;
        RtcConnection.registerLogListener(new RtcConnection.LogListener(){

            @Override
            public void onLog(int n, String string) {
                logcallback.onLog(n, string);
            }
        });
    }

    public void setLocalPreviewView(final VideoViewRenderer videoViewRenderer) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setLocalPreviewView  ,localview=[" + videoViewRenderer + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                RtcConnectionExt rtcConnectionExt;
                ((EMediaManager)EMediaManager.this).mgrData.localViewRender = videoViewRenderer;
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId != null && (rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId)) != null) {
                    rtcConnectionExt.setViews(((EMediaManager)EMediaManager.this).mgrData.localViewRender, null);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setLocalPreviewView");
            }
        });
    }

    public void join(final EMediaSession eMediaSession, final EMediaSession.EMediaPublishConfiguration eMediaPublishConfiguration, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ join");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, false, "join")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                if (eMediaPublishConfiguration != null) {
                    EMediaManager.this.makePubArg(eMediaSession, eMediaPublishConfiguration, jSONObject);
                }
                eMediaSession.joinBlock = eMediaIdBlockType;
                ((EMediaManager)EMediaManager.this).mgrData.connDict.put(eMediaSession.instanceId, eMediaSession);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "startTimer");
                EMediaManager.this.startTimer();
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("ticket", (Object)eMediaSession.ticket);
                    if (eMediaSession.extension != null) {
                        jSONObject.put("ext", (Object)eMediaSession.extension);
                    }
                    if (eMediaSession.nickName != null) {
                        jSONObject.put("nickName", (Object)eMediaSession.nickName);
                    }
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_TRYTKT);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- join");
            }
        });
    }

    public void exit(final EMediaSession eMediaSession, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ exit");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "exit")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_EXITTKT);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invokeResult(eMediaSession, n, eMediaSession, eMediaIdBlockType);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- exit");
            }
        });
    }

    String getSubcribeId(String string) {
        return "rtc-" + string;
    }

    private boolean checkExistSession(EMediaSession eMediaSession, EMediaEntities.EMediaIdBlockType eMediaIdBlockType, boolean bl, String string) {
        if (eMediaSession == null) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "null  session , origin=" + string);
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_INVALID_ARG.errorcode, ""), eMediaSession);
            return false;
        }
        EMediaSession eMediaSession2 = this.mgrData.connDict.get(eMediaSession.instanceId);
        if (eMediaSession2 == null && bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NOT join session[" + eMediaSession.instanceId + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SESSION.errorcode, null), eMediaSession);
            return false;
        }
        if (eMediaSession2 != null && !bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already join session[" + eMediaSession.instanceId + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, null, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_JOIN.errorcode, null), eMediaSession);
            return false;
        }
        return true;
    }

    private boolean checkExistSubscribe(EMediaSession eMediaSession, EMediaEntities.EMediaIdBlockType eMediaIdBlockType, boolean bl, String string, String string2) {
        EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription = this.mgrData.subsrDict.get(string2);
        if (eMediaStreamSubscription != null && !bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "already subscribed, session[" + eMediaSession.instanceId + "], streamId[" + string + "], subsrId[" + string2 + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, eMediaSession, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_ALREADY_SUBSCRIBE.errorcode, null), eMediaSession);
            return false;
        }
        if (eMediaStreamSubscription == null && bl) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "NO subscribed, session[" + eMediaSession.instanceId + "], streamId[" + string + "], subsrId[" + string2 + "]");
            this.invoker.invokeBlock(eMediaIdBlockType, eMediaSession, this.newErrorWithCode(EMediaDefines.EMediaErrorCode.EMEDIA_ERROR_NO_SUBSCRIBE.errorcode, null), eMediaSession);
            return false;
        }
        return true;
    }

    public static EMediaDefines.EMediaErrorCode wrap(int n) {
        for (EMediaDefines.EMediaErrorCode eMediaErrorCode : EMediaDefines.EMediaErrorCode.values()) {
            if (eMediaErrorCode.errorcode != n) continue;
            return eMediaErrorCode;
        }
        throw new RuntimeException("Json str. error on = " + n);
    }

    private EMediaEntities.EMediaError newErrorWithCode(int n, String string) {
        Object object;
        if (string == null || string.length() == 0) {
            object = new JSONObject();
            try {
                object.put("code", n);
                object.put("op", (Object)INVOKE_OP_ERR_DESC);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            String[] stringArray = new String[1];
            this.mgrData.bridger.invokeWithDict(object.toString(), stringArray);
            JSONTokener jSONTokener = new JSONTokener(stringArray[0]);
            JSONObject jSONObject = null;
            try {
                jSONObject = (JSONObject)jSONTokener.nextValue();
                string = jSONObject.optString("desc");
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        object = EMediaEntities.EMediaError.newError(EMediaManager.wrap(n), string);
        return object;
    }

    private boolean invokeResult(EMediaSession eMediaSession, int n, Object object, EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        if (n != 0) {
            EMediaEntities.EMediaError eMediaError = EMediaEntities.EMediaError.newError(EMediaManager.wrap(n), null);
            this.invoker.invokeBlock(eMediaIdBlockType, null, eMediaError, eMediaSession);
            return false;
        }
        this.invoker.invokeBlock(eMediaIdBlockType, object, null, eMediaSession);
        return true;
    }

    private boolean checkExistSameRtc(RtcConnectionExt rtcConnectionExt, String string) {
        RtcConnectionExt rtcConnectionExt2 = this.mgrData.rtcDict.get(rtcConnectionExt.name);
        if (rtcConnectionExt2 == rtcConnectionExt) {
            return true;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same rtc [" + rtcConnectionExt.name + "], origin=[" + string + "%@]");
        return false;
    }

    private EMediaSession checkExistSameWebsocket(SRWebSocketExt sRWebSocketExt, String string) {
        EMediaSession eMediaSession = this.mgrData.connDict.get(sRWebSocketExt.name);
        if (eMediaSession != null && eMediaSession.websocket == sRWebSocketExt) {
            return eMediaSession;
        }
        logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "NOT same websocket [" + sRWebSocketExt.name + "], origin=[" + string + "%@]");
        return null;
    }

    public void makePubArg(EMediaSession eMediaSession, EMediaSession.EMediaPublishConfiguration eMediaPublishConfiguration, JSONObject jSONObject) {
        if (eMediaPublishConfiguration == null) {
            eMediaPublishConfiguration = new EMediaSession.EMediaPublishConfiguration();
        }
        try {
            jSONObject.put("pubtype", EMediaDefines.EMediaStreamType.EMSTREAM_TYPE_NORMAL.val);
            jSONObject.put("voff", eMediaPublishConfiguration.videoOff);
            jSONObject.put("aoff", eMediaPublishConfiguration.mute);
            if (eMediaPublishConfiguration.extension != null) {
                jSONObject.put("streamExt", (Object)eMediaPublishConfiguration.extension);
            }
            if (eMediaPublishConfiguration.name != null) {
                jSONObject.put("pubname", (Object)eMediaPublishConfiguration.name);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void closeSession(EMediaSession eMediaSession) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi] closeSession");
        this.mgrData.connDict.remove(eMediaSession.instanceId);
        if (eMediaSession.websocket != null) {
            logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "close websocket [" + eMediaSession.instanceId + "] -> [" + eMediaSession.websocket.url + "]");
            eMediaSession.websocket.close();
            eMediaSession.websocket = null;
        }
        if (eMediaSession == this.mgrData.pubSession) {
            this.mgrData.pubSession = null;
        }
        if (this.mgrData.connDict.size() == 0) {
            this.stopTimer();
        }
    }

    public void publish(final EMediaSession eMediaSession, final EMediaSession.EMediaPublishConfiguration eMediaPublishConfiguration, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ publish ,config=[" + eMediaPublishConfiguration + "]");
        if (!this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "pub")) {
            return;
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "publish connId:" + eMediaSession.instanceId);
                JSONObject jSONObject = new JSONObject();
                EMediaManager.this.makePubArg(eMediaSession, eMediaPublishConfiguration, jSONObject);
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_PUBLISH);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                String[] stringArray = new String[1];
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), stringArray);
                JSONTokener jSONTokener = new JSONTokener(stringArray[0]);
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2 = (JSONObject)jSONTokener.nextValue();
                    String string = null;
                    if (jSONObject2.has("pubId")) {
                        string = jSONObject2.getString("pubId");
                    }
                    EMediaManager.this.invokeResult(eMediaSession, n, string, eMediaIdBlockType);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- publish");
            }
        });
    }

    public void unpublish(final EMediaSession eMediaSession, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unpublish");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "unpub")) {
                    return;
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_UNPUBLISH);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt != null) {
                    EMediaManager.this.isunpub = true;
                    EMediaManager.this.unpubcameraid = rtcConnectionExt.getCameraFacing();
                }
                String[] stringArray = new String[1];
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), stringArray);
                JSONTokener jSONTokener = new JSONTokener(stringArray[0]);
                JSONObject jSONObject2 = new JSONObject();
                try {
                    jSONObject2 = (JSONObject)jSONTokener.nextValue();
                    EMediaManager.this.invokeResult(eMediaSession, n, jSONObject2.optString("pubId"), eMediaIdBlockType);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unpublish");
            }
        });
    }

    public void subscribe(final EMediaSession eMediaSession, final String string, final VideoViewRenderer videoViewRenderer, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ subscribe ,streamId=" + string + " ,remoteview=[" + videoViewRenderer + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                EMediaEntities.EMediaStreamSubscription eMediaStreamSubscription;
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "sub")) {
                    return;
                }
                String string2 = EMediaManager.this.getSubcribeId(string);
                logcallback.onLog(logLevel.LS_DEBUG.ordinal(), "subscribing stream [" + string + "]with subsrId[" + string2 + "]");
                if (!EMediaManager.this.checkExistSubscribe(eMediaSession, eMediaIdBlockType, false, string, string2)) {
                    return;
                }
                if (((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string2) == null) {
                    eMediaStreamSubscription = new EMediaEntities.EMediaStreamSubscription();
                    eMediaStreamSubscription.subscribeId = string2;
                    eMediaStreamSubscription.view = videoViewRenderer;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string2, eMediaStreamSubscription);
                } else {
                    eMediaStreamSubscription = ((EMediaManager)EMediaManager.this).mgrData.subsrDict.get(string2);
                    eMediaStreamSubscription.subscribeId = string2;
                    eMediaStreamSubscription.view = videoViewRenderer;
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.put(string2, eMediaStreamSubscription);
                }
                eMediaStreamSubscription = new JSONObject();
                try {
                    eMediaStreamSubscription.put("subsrId", string2);
                    eMediaStreamSubscription.put("connId", eMediaSession.instanceId);
                    eMediaStreamSubscription.put("streamId", string);
                    eMediaStreamSubscription.put("op", EMediaManager.INVOKE_OP_SUBSR);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(eMediaStreamSubscription.toString(), null);
                if (n != 0) {
                    ((EMediaManager)EMediaManager.this).mgrData.subsrDict.remove(string2);
                    EMediaManager.this.invokeResult(eMediaSession, n, null, eMediaIdBlockType);
                } else {
                    EMediaManager.this.invokeResult(eMediaSession, n, string2, eMediaIdBlockType);
                }
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- subscribe");
            }
        });
    }

    public void unsubscribe(final EMediaSession eMediaSession, final String string, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ unsubscribe ,streamId=[" + string + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "unsub")) {
                    return;
                }
                String string2 = EMediaManager.this.getSubcribeId(string);
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "unsubscribing  stream [" + string + "]with subsrId[" + string2 + "]");
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("subsrId", (Object)string2);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_USUBSR);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                EMediaManager.this.invokeResult(eMediaSession, n, string2, eMediaIdBlockType);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- unsubscribe");
            }
        });
    }

    public void switchCamera() {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchCamera");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.switchCamera();
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchCamera");
            }
        });
    }

    public static void setCameraFacing(final int n) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setCameraFacing");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (cameraid != n) {
                    cameraid = n;
                }
                RtcConnectionExt.setCameraFacing(n);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setCameraFacing");
            }
        });
    }

    public int getCameraFacing() {
        RtcConnectionExt rtcConnectionExt = this.mgrData.rtcDict.get(this.mgrData.myRtcId);
        return rtcConnectionExt.getCameraFacing();
    }

    public void setMuteEnabled(final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setMuteEnabled ,enable=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.setMute(bl);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("rtcId", (Object)rtcConnectionExt.name);
                    jSONObject.put("aoff", bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- setMuteEnabled");
            }
        });
    }

    public void setVideoEnabled(final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled ,enable=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                if (bl) {
                    rtcConnectionExt.startCapture();
                } else {
                    rtcConnectionExt.stopCapture();
                }
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("rtcId", (Object)rtcConnectionExt.name);
                    jSONObject.put("voff", !bl);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_RTC_UPDATE);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ setVideoEnabled");
            }
        });
    }

    public void switchTorchOn(final boolean bl) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ switchTorchOn ,on=[" + bl + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (((EMediaManager)EMediaManager.this).mgrData.myRtcId == null) {
                    return;
                }
                RtcConnectionExt rtcConnectionExt = ((EMediaManager)EMediaManager.this).mgrData.rtcDict.get(((EMediaManager)EMediaManager.this).mgrData.myRtcId);
                if (rtcConnectionExt == null) {
                    return;
                }
                rtcConnectionExt.switchTorchOn(bl);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- switchTorchOn");
            }
        });
    }

    public void remoteCamerafocus(final EMediaSession eMediaSession, final String string, final boolean bl, final boolean bl2, final Point point, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCamerafocus ,streamId=[" + string + "] ,focus=[" + bl + "] ,exposure=[" + bl2 + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "remote-focus")) {
                    return;
                }
                int n = point.x * 10000;
                int n2 = point.y * 10000;
                int n3 = bl ? 1 : 0;
                int n4 = bl2 ? 1 : 0;
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("x", n);
                    jSONObject.put("y", n2);
                    jSONObject.put("focus", n3);
                    jSONObject.put("expo", n4);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCamerafocus");
            }
        });
    }

    public void remoteCameraZoomWith(final EMediaSession eMediaSession, final String string, final float f2, final EMediaEntities.EMediaIdBlockType eMediaIdBlockType) {
        logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]++ remoteCameraZoomWith ,streamId=[" + string + "] ,zoomFactor=[" + f2 + "]");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!EMediaManager.this.checkExistSession(eMediaSession, eMediaIdBlockType, true, "remote-zoom")) {
                    return;
                }
                int n = (int)(f2 * 10000.0f);
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("zoom", n);
                    jSONObject.put("streamId", (Object)string);
                    jSONObject.put("connId", (Object)eMediaSession.instanceId);
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_CAMERACTRL);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                logcallback.onLog(logLevel.LS_ERROR.ordinal(), "[EMediaapi]-- remoteCameraZoomWith");
            }
        });
    }

    public void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer();
        }
        try {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            EMediaManager.this.timerDidFire();
                        }
                    });
                }
            }, 0L, 1000L);
        }
        catch (Exception exception) {
            logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: Can not schedule statistics timer " + exception);
        }
    }

    public void timerDidFire() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("op", (Object)EMediaManager.INVOKE_OP_TIMER);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                int n = ((EMediaManager)EMediaManager.this).mgrData.bridger.invokeWithDict(jSONObject.toString(), null);
                if (n != 0) {
                    logcallback.onLog(logLevel.LS_ERROR.ordinal(), "::: timerDidFire: fail with " + n);
                }
            }
        });
    }

    public void stopTimer() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                logcallback.onLog(logLevel.LS_INFO.ordinal(), "stop timer");
                if (EMediaManager.this.timer != null) {
                    EMediaManager.this.timer.cancel();
                    EMediaManager.this.timer.purge();
                    EMediaManager.this.timer = null;
                }
            }
        });
    }

    static {
        iscreatemediamanager = false;
        instance = null;
        idnum = 0L;
        managerListener = null;
        cameraid = -1;
        logcallback = new XClientBridger.Logcallbackfunc(){

            @Override
            public void onLog(int n, String string) {
                Log.i((String)EMediaManager.TAG, (String)string);
            }
        };
    }

    private class ManagerData {
        public String myRtcId;
        public VideoViewRenderer localViewRender;
        public XClientBridger bridger;
        public LooperExecutor workQueue;
        public Map<String, RtcConnectionExt> rtcDict = new HashMap<String, RtcConnectionExt>();
        public Map<String, EMediaSession> connDict = new HashMap<String, EMediaSession>();
        public Map<String, EMediaEntities.EMediaStreamSubscription> subsrDict = new HashMap<String, EMediaEntities.EMediaStreamSubscription>();
        public Map<String, String> subscribidRtcid = new HashMap<String, String>();
        public EMediaSession pubSession;
    }

    private static enum logLevel {
        LS_INFO,
        LS_DEBUG,
        LS_ERROR;

    }

    public static interface EMediaManagerListener {
        public void onConnected(String var1);

        public void onConnectionsetup(String var1);

        public void onDisconnected(String var1);
    }
}

