/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public class EMACallManager extends EMABase {

    public EMACallSession makeCall(String remoteName, EMACallSession.Type type, String ext, EMAError error) {
        return nativeMakeCall(remoteName, type.ordinal(), ext, error);
    }

    public EMACallSession makeCall(String remoteName, EMACallSession.Type type, EMAError error) {
        return nativeMakeCall(remoteName, type.ordinal(), "", error);
    }
    native EMACallSession nativeMakeCall(String remoteName, int type, String ext, EMAError error);
    
    public void answerCall(String sessionId, EMAError error) {
        nativeAnswerCall(sessionId, error);
    }
    native void nativeAnswerCall(String sessionId, EMAError error);
    
    public void endCall(String sessionId, EMACallSession.EndReason reason) {
        nativeEndCall(sessionId, reason.ordinal());
    }
    native void nativeEndCall(String sessionId, int reason);
    
    public void addListener(EMACallManagerListener listener) {
        nativeAddListener(listener);
    }
    native void nativeAddListener(EMACallManagerListener listener);
    
    void removeListener(EMACallManagerListener listener) {
        nativeRemoveListener(listener);
    }
    native void nativeRemoveListener(EMACallManagerListener listener);
    
    void clearListeners() {
        nativeClearListeners();
    }
    native void nativeClearListeners();   
    
    public void updateSessionInfo(String sessionId, int infoType){
        nativeUpdateSessionInfo(sessionId, infoType);
    }
    native void nativeUpdateSessionInfo(String sessionId, int infoType);

    public void updateCall(String callId, EMACallSession.StreamControlType type, EMAError error) {
        nativeUpdateCall(callId, type.ordinal(), error);
    }
    native void nativeUpdateCall(String callId, int type, EMAError emaError);
    
    public native String stopRecordVideo();
    public native void startRecordVideo(String dir);
    public native boolean capturePicture(String file);
    
    public void setIsSendPushIfOffline(boolean isSend) {
        nativeSetIsSendPushIfOffline(isSend);
    }
    native void nativeSetIsSendPushIfOffline(boolean isSend);
    
    public boolean getIsSendPushIfOffline() {
        return nativeGetIsSendPushIfOffline();
    }
    native boolean nativeGetIsSendPushIfOffline();
    
    public long getVideoResolutionWidth() {
        return nativeGetVideoResolutionWidth();
    }
    native long nativeGetVideoResolutionWidth();
    
    public long getVideoResolutionHeight() {
        return nativeGetVideoResolutionHeight();
    }
    native long nativeGetVideoResolutionHeight();
    
    public long getVideoKbps() {
        return nativeGetVideoKbps();
    }
    native long nativeGetVideoKbps();
    
    public void setVideoResolution(long width, long height) {
        nativeSetVideoResolution(width, height);
    }
    native void nativeSetVideoResolution(long width, long height);
    
    public void setVideoKbps(long kbps) {
        nativeSetVideoKbps(kbps);
    }
    native void nativeSetVideoKbps(long kbps);

    /**
     * ------------------------------------------  video conference interface ------------------------------------------
     */
    public void setCallConferenceListener(EMACallConferenceListener listener){
        nativeSetCallConferenceListener(listener);
    }
    native void nativeSetCallConferenceListener(EMACallConferenceListener listener);
    public void removeCallConferenceListener(){
        nativeRemoveCallConferenceListener();
    }
    native void nativeRemoveCallConferenceListener();

    public String creatorGetTicketFromServer(String confId, String password, EMAError error) {
        return nativeCreatorGetTicketFromServer(confId, password, error);
    }
    native String nativeCreatorGetTicketFromServer(String confId, String password, EMAError error);

    public String memberGetTicketFromServer(String confId, String password, EMAError error) {
        return nativeMemberGetTicketFromServer(confId, password, error);
    }
    native String nativeMemberGetTicketFromServer(String confId, String password, EMAError error);

    public void inviteUserToJoinConference(String confId, String password, String username, String ext, EMAError error){
        nativeInviteUserToJoinConference(confId, password, username, ext, error);
    }
    native void nativeInviteUserToJoinConference(String confId, String password, String username, String ext, EMAError error);
}
