/************************************************************
 *  * EaseMob CONFIDENTIAL 
 * __________________ 
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
 *  
 * NOTICE: All information contained herein is, and remains 
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material 
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;

import com.hyphenate.util.CryptoUtils;

class EMSessionManager {
	private static final String TAG = "Session";

	private Context appContext = null;

	private final static String PREF_KEY_LOGIN_USER = "easemob.chat.loginuser";
	private final static String PREF_KEY_LOGIN_PWD = "easemob.chat.loginpwd";
	private final static String PREF_KEY_LOGIN_TOKEN = "easemob.chat.login.token";
	private final static String PREF_KEY_LOGIN_WITH_TOKEN = "easemob.chat.login_with_token";


	/**
	 * the static variable for current login user
	 */
	public EMContact currentUser = null;
 
	private static EMSessionManager instance = new EMSessionManager();

	private String lastLoginUser = null;
	private String lastLoginPwd = null;
	private String lastLoginToken = null;

	
	static synchronized EMSessionManager getInstance(){
		if(instance.appContext == null){
			instance.appContext = EMClient.getInstance().getContext();
		}

		return instance;
	}

	/**
	 * get the username who has been logined successfully. this method will be
	 * called during sdk init.
	 * 
	 * @return
	 */
	String getLastLoginUser() {
		if (lastLoginUser == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			lastLoginUser = setting.getString(PREF_KEY_LOGIN_USER, "");
			currentUser = new EMContact(lastLoginUser);
		}
		return lastLoginUser;
	}

	void setLastLoginUser(String username) {
		if(username == null){
			return;
		}
		currentUser = new EMContact(username);
		lastLoginUser = username;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		editor.putString(PREF_KEY_LOGIN_USER, username);
		editor.apply();
	}

	String getLastLoginPwd() {
		if (lastLoginPwd == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			String encryptedPwd = setting.getString(PREF_KEY_LOGIN_PWD, "");
			
            if(encryptedPwd.equals("")){
                lastLoginPwd = "";
                return lastLoginPwd;
            }
            
			try {
				CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
				lastLoginPwd = crytoUtils.decryptBase64String(encryptedPwd);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return lastLoginPwd;
	}

	void setLastLoginPwd(String pwd) {
		if(pwd == null){
			return;
		}

		lastLoginPwd = pwd;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		// save password in encryption mode
		try {
			CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
			String encrypedPwd = crytoUtils.encryptBase64String(pwd);

			editor.putString(PREF_KEY_LOGIN_PWD, encrypedPwd);
			editor.apply();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	String getLastLoginToken() {
		if (lastLoginToken == null) {
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			String encryptedToken = setting.getString(PREF_KEY_LOGIN_TOKEN, "");

			if(encryptedToken.equals("")){
				lastLoginToken = "";
				return lastLoginToken;
			}

			try {
				CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
				lastLoginToken = crytoUtils.decryptBase64String(encryptedToken);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return lastLoginToken;
	}

	void setLastLoginToken(String token) {
		if(token == null){
			return;
		}

		lastLoginToken = token;
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		// save password in encryption mode
		try {
			CryptoUtils crytoUtils = EMClient.getInstance().getCryptoUtils();
			String encrypedToken = crytoUtils.encryptBase64String(token);

			editor.putString(PREF_KEY_LOGIN_TOKEN, encrypedToken);
			editor.apply();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	void clearLastLoginUser(){
		try{
			lastLoginUser = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_USER, lastLoginUser);
			editor.apply();
		}catch(Exception e){
		}
	}
	
	void clearLastLoginPwd(){
		try{
			lastLoginPwd = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_PWD, lastLoginPwd);
			editor.apply();
		}catch(Exception e){
			
		}
	}

	void clearLastLoginToken(){
		try{
			lastLoginToken = "";
			SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
			Editor editor = setting.edit();
			editor.putString(PREF_KEY_LOGIN_TOKEN, lastLoginToken);
			editor.apply();
		}catch(Exception e){

		}
	}

	/**
	 * whether last login with token
	 * this method will be called during sdk init.
	 *
	 * @return
	 */
	boolean isLastLoginWithToken() {
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		return setting.getBoolean(PREF_KEY_LOGIN_WITH_TOKEN, false);
	}

	void setLastLoginWithToken(boolean loginWithToken) {
		SharedPreferences setting = PreferenceManager.getDefaultSharedPreferences(appContext);
		Editor editor = setting.edit();
		editor.putBoolean(PREF_KEY_LOGIN_WITH_TOKEN, loginWithToken);
		editor.apply();
	}

	public String getLoginUserName() {
		return currentUser.username;
	}
}