/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import java.util.List;

import android.content.Context;
import android.content.Intent;

import com.hyphenate.util.EMLog;
import com.xiaomi.mipush.sdk.ErrorCode;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;

/**
 * \~chinese
 * 用于接收小米推送相关消息的的broadcast receiver
 * 
 * \~english
 * a broadcast receiver for mipush
 */
public class EMMipushReceiver extends PushMessageReceiver{
    private static final String TAG = EMMipushReceiver.class.getSimpleName();
    @Override
    public void onNotificationMessageClicked(Context context, MiPushMessage arg1) {
        super.onNotificationMessageClicked(context, arg1);
        EMLog.d(TAG, "mi push onNotificationMessageClicked");

        Intent msgIntent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
        msgIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(msgIntent);
    }
    
    @Override
    public void onReceiveRegisterResult(Context context, MiPushCommandMessage message) {
        super.onReceiveRegisterResult(context, message);
        String command = message.getCommand();
        if (MiPushClient.COMMAND_REGISTER.equals(command)) {
            List<String> arguments = message.getCommandArguments();
            String cmdArg1 = ((arguments != null && arguments.size() > 0) ? arguments.get(0) : null);
            if (message.getResultCode() == ErrorCode.SUCCESS) {
                EMLog.d(TAG, "mi push reigster success");
                String regId = cmdArg1;
                EMPushHelper.getInstance().onReceiveToken(regId);
            }else{
                EMLog.d(TAG, "mi push register fail");
                EMPushHelper.getInstance().onReceiveToken(null);
            }
        }
    }
    
}
