package com.hyphenate;

import com.hyphenate.chat.EMConferenceStream;

/**
 * Created by lzan13 on 2017/8/16.
 * \~chinese
 * 多人音视频会议回调接口
 *
 * \~english
 * Multi person conference callback interface
 */
public interface EMConferenceListener {

    /**
     * \~chinese
     * 成员加入会议
     *
     * \~english
     * Member join conference
     */
    void onMemberJoined(String username);

    /**
     * \~chinese
     * 成员离开会议
     *
     * \~english
     * Member exit conference
     */
    void onMemberExited(String username);

    /**
     * \~chinese
     * 有新的成员推流
     *
     * \~english
     * New member publish stream
     */
    void onStreamAdded(EMConferenceStream stream);

    /**
     * \~chinese
     * 成员停止推流
     *
     * \~english
     * Member stop publish stream
     */
    void onStreamRemoved(EMConferenceStream stream);

    /**
     * \~chinese
     * 有成员更新自己的推流，比如打开摄像头，静音等操作
     *
     * \~english
     * Members to update their own flow, such as open the camera, mute and other operations
     */
    void onStreamUpdate(EMConferenceStream stream);

    /**
     * \~chinese
     * 被动离开会议
     *
     * \~english
     * Passively leave the conference
     */
    void onPassiveLeave(int error, String message);

    /**
     * \~chinese
     * 会议状态通知回调
     *
     * \~english
     * Conference status notification callback
     */
    void onConferenceState(ConferenceState state);

    /**
     * \~chinese
     * 推本地流 或 订阅成员流 成功回调
     * @param streamId 本地流 或 成员流ID
     *
     * \~english
     * stream publish or subscribe setup
     * @param streamId publish or subscribe stream id
     */
    void onStreamSetup(String streamId);

    /**
     * \~chinese
     * 收到会议邀请
     *
     * @param confId 会议 id
     * @param password 会议密码
     * @param extension 邀请扩展内容
     *
     * \~english
     * Received a conference invitation
     * @param confId conference id
     * @param password conference password
     * @params extension invitation extension
     */
    void onReceiveInvite(String confId, String password, String extension);

    enum ConferenceType {
        CALL,   // 正常类型，音视频通话
        DESKTOP // 桌面共享，暂不支持
    }

    /**
     * |~chinese
     * 会议通知状态
     *
     * \~english
     * conference notification state
     */
    enum ConferenceState {
        STATE_NORMAL,   // 正常状态
        STATE_DISCONNECTION,   // 连接断开
        STATE_RECONNECTION,    // 重新连接
        STATE_POOR_QUALITY,    // 通话质量差
        STATE_PUBLISH_SETUP,   // 开始推流
        STATE_SUBSCRIBE_SETUP, // 开始订阅
        STATE_TAKE_CAMERA_PICTURE   // 捕获图片

    }
}
