/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.voice;

import android.annotation.TargetApi;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import com.superrtc.call.Logging;
import com.superrtc.voice.WebRtcAudioUtils;
import java.util.List;
import java.util.UUID;

class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_AUTOMATIC_GAIN_CONTROL = UUID.fromString("aa8130e0-66fc-11e0-bad0-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    private static Boolean canUseAcousticEchoCanceler = null;
    private static Boolean canUseAutomaticGainControl = null;
    private static Boolean canUseNoiseSuppressor = null;
    private AcousticEchoCanceler aec = null;
    private AutomaticGainControl agc = null;
    private NoiseSuppressor ns = null;
    private boolean shouldEnableAec = false;
    private boolean shouldEnableAgc = false;
    private boolean shouldEnableNs = false;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && AcousticEchoCanceler.isAvailable();
    }

    public static boolean isAutomaticGainControlSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && AutomaticGainControl.isAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioUtils.runningOnJellyBeanOrHigher() && NoiseSuppressor.isAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        List<String> list = WebRtcAudioUtils.getBlackListedModelsForAecUsage();
        boolean bl = list.contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, String.valueOf(Build.MODEL) + " is blacklisted for HW AEC usage!");
        }
        return bl;
    }

    public static boolean isAutomaticGainControlBlacklisted() {
        List<String> list = WebRtcAudioUtils.getBlackListedModelsForAgcUsage();
        boolean bl = list.contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, String.valueOf(Build.MODEL) + " is blacklisted for HW AGC usage!");
        }
        return bl;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        List<String> list = WebRtcAudioUtils.getBlackListedModelsForNsUsage();
        boolean bl = list.contains(Build.MODEL);
        if (bl) {
            Logging.w(TAG, String.valueOf(Build.MODEL) + " is blacklisted for HW NS usage!");
        }
        return bl;
    }

    @TargetApi(value=18)
    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        AudioEffect.Descriptor[] descriptorArray = AudioEffect.queryEffects();
        int n = descriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AudioEffect.Descriptor descriptor = descriptorArray[n2];
            if (descriptor.type.equals(AudioEffect.EFFECT_TYPE_AEC) && descriptor.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isAutomaticGainControlExcludedByUUID() {
        AudioEffect.Descriptor[] descriptorArray = AudioEffect.queryEffects();
        int n = descriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AudioEffect.Descriptor descriptor = descriptorArray[n2];
            if (descriptor.type.equals(AudioEffect.EFFECT_TYPE_AGC) && descriptor.uuid.equals(AOSP_AUTOMATIC_GAIN_CONTROL)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @TargetApi(value=18)
    private static boolean isNoiseSuppressorExcludedByUUID() {
        AudioEffect.Descriptor[] descriptorArray = AudioEffect.queryEffects();
        int n = descriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            AudioEffect.Descriptor descriptor = descriptorArray[n2];
            if (descriptor.type.equals(AudioEffect.EFFECT_TYPE_NS) && descriptor.uuid.equals(AOSP_NOISE_SUPPRESSOR)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean canUseAcousticEchoCanceler() {
        if (canUseAcousticEchoCanceler == null) {
            canUseAcousticEchoCanceler = new Boolean(WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted() && !WebRtcAudioEffects.isAcousticEchoCancelerExcludedByUUID());
            Logging.d(TAG, "canUseAcousticEchoCanceler: " + canUseAcousticEchoCanceler);
        }
        return canUseAcousticEchoCanceler;
    }

    public static boolean canUseAutomaticGainControl() {
        if (canUseAutomaticGainControl == null) {
            canUseAutomaticGainControl = new Boolean(WebRtcAudioEffects.isAutomaticGainControlSupported() && !WebRtcAudioUtils.useWebRtcBasedAutomaticGainControl() && !WebRtcAudioEffects.isAutomaticGainControlBlacklisted() && !WebRtcAudioEffects.isAutomaticGainControlExcludedByUUID());
            Logging.d(TAG, "canUseAutomaticGainControl: " + canUseAutomaticGainControl);
        }
        return canUseAutomaticGainControl;
    }

    public static boolean canUseNoiseSuppressor() {
        if (canUseNoiseSuppressor == null) {
            canUseNoiseSuppressor = new Boolean(WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted() && !WebRtcAudioEffects.isNoiseSuppressorExcludedByUUID());
            Logging.d(TAG, "canUseNoiseSuppressor: " + canUseNoiseSuppressor);
        }
        return canUseNoiseSuppressor;
    }

    static WebRtcAudioEffects create() {
        if (!WebRtcAudioUtils.runningOnJellyBeanOrHigher()) {
            Logging.w(TAG, "API level 16 or higher is required!");
            return null;
        }
        return new WebRtcAudioEffects();
    }

    private WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    public boolean setAEC(boolean bl) {
        Logging.d(TAG, "setAEC(" + bl + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setAGC(boolean bl) {
        Logging.d(TAG, "setAGC(" + bl + ")");
        if (!WebRtcAudioEffects.canUseAutomaticGainControl()) {
            Logging.w(TAG, "Platform AGC is not supported");
            this.shouldEnableAgc = false;
            return false;
        }
        if (this.agc != null && bl != this.shouldEnableAgc) {
            Logging.e(TAG, "Platform AGC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAgc = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d(TAG, "setNS(" + bl + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n) {
        Logging.d(TAG, "enable(audioSession=" + n + ")");
        WebRtcAudioEffects.assertTrue(this.aec == null);
        WebRtcAudioEffects.assertTrue(this.agc == null);
        WebRtcAudioEffects.assertTrue(this.ns == null);
        AudioEffect.Descriptor[] descriptorArray = AudioEffect.queryEffects();
        boolean bl = descriptorArray.length;
        boolean bl2 = false;
        while (bl2 < bl) {
            AudioEffect.Descriptor descriptor = descriptorArray[bl2];
            if (this.effectTypeIsVoIP(descriptor.type)) {
                Logging.d(TAG, "name: " + descriptor.name + ", " + "mode: " + descriptor.connectMode + ", " + "implementor: " + descriptor.implementor + ", " + "UUID: " + descriptor.uuid);
            }
            bl2 += 1;
        }
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            this.aec = AcousticEchoCanceler.create((int)n);
            if (this.aec != null) {
                boolean bl3 = this.aec.getEnabled();
                boolean bl4 = bl2 = this.shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                if (this.aec.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                Logging.d(TAG, "AcousticEchoCanceler: was " + (bl3 ? "enabled" : "disabled") + ", enable: " + bl2 + ", is now: " + (this.aec.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isAutomaticGainControlSupported()) {
            this.agc = AutomaticGainControl.create((int)n);
            if (this.agc != null) {
                boolean bl5 = this.agc.getEnabled();
                boolean bl6 = bl2 = this.shouldEnableAgc && WebRtcAudioEffects.canUseAutomaticGainControl();
                if (this.agc.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the AutomaticGainControl state");
                }
                Logging.d(TAG, "AutomaticGainControl: was " + (bl5 ? "enabled" : "disabled") + ", enable: " + bl2 + ", is now: " + (this.agc.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the AutomaticGainControl instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            this.ns = NoiseSuppressor.create((int)n);
            if (this.ns != null) {
                boolean bl7 = this.ns.getEnabled();
                boolean bl8 = bl2 = this.shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                if (this.ns.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                Logging.d(TAG, "NoiseSuppressor: was " + (bl7 ? "enabled" : "disabled") + ", enable: " + bl2 + ", is now: " + (this.ns.getEnabled() ? "enabled" : "disabled"));
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        if (this.aec != null) {
            this.aec.release();
            this.aec = null;
        }
        if (this.agc != null) {
            this.agc.release();
            this.agc = null;
        }
        if (this.ns != null) {
            this.ns.release();
            this.ns = null;
        }
    }

    @TargetApi(value=18)
    private boolean effectTypeIsVoIP(UUID uUID) {
        if (!WebRtcAudioUtils.runningOnJellyBeanMR2OrHigher()) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_AGC.equals(uUID) && WebRtcAudioEffects.isAutomaticGainControlSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean bl) {
        if (!bl) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }
}

