/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

public interface EMAContactListenerInterface {

	/**
	 * 增加联系人时回调此方法
   * 
   * this api will be called when there is any contact added
	 * @param username 增加的联系人
	 */
    void onContactAdded(String username);
    
    /**
     * 被删除时回调此方法
     *
     * this api will be called when some contacts of yours are deleted
     * @param username 删除的联系人
     */
    void onContactDeleted(String username);

    /**
     * 收到好友邀请
     *
     * this api will be called when you receive a friend application
     * @param username
     * @param reason
     */
    void onContactInvited(String username, String reason);
    
    /**
     * 好友请求被同意
     *
     * this api will be called when your application is accepted
     * @param username
     */
    void onContactAgreed(String username);
    
    /**
     * 好友请求被拒绝
     *
     * this api will be called when your application is refused
     * @param username
     */
    void onContactRefused(String username);
}
