/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.sdk;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SDPSsrcChanger {
    String streamLabel;
    String msidAudio;
    String msidVideo;
    String lastCNAME = null;
    long lastAudioSSRC = 0L;
    long lastVideoSSRC = 0L;
    static long ssrcInterval = 20L;

    public SDPSsrcChanger(String string) {
        this.streamLabel = string;
        this.msidAudio = String.valueOf(string) + "a0";
        this.msidVideo = String.valueOf(string) + "v0";
        this.reset();
    }

    public void reset() {
        this.lastCNAME = null;
        this.lastAudioSSRC = 0L;
        this.lastVideoSSRC = 0L;
    }

    public String processPranswer(String string) {
        String[] stringArray = SDPSsrcChanger.splitSDP2Medias(string);
        StringBuilder stringBuilder = new StringBuilder();
        long l = SDPSsrcChanger.getNextStartSSRC();
        int n = 0;
        while (n < stringArray.length) {
            long l2;
            String string2 = stringArray[n];
            this.lastCNAME = "cname" + l;
            if (string2.startsWith("m=audio")) {
                stringBuilder.append(string2);
                if (string2.indexOf("a=ssrc:") < 0) {
                    l2 = l + 0L;
                    stringBuilder.append("a=ssrc:" + l2 + " cname:" + this.lastCNAME + "\r\n");
                    stringBuilder.append("a=ssrc:" + l2 + " msid:" + this.streamLabel + " " + this.msidAudio + "\r\n");
                    stringBuilder.append("a=ssrc:" + l2 + " mslabel:" + this.streamLabel + "\r\n");
                    stringBuilder.append("a=ssrc:" + l2 + " label:" + this.msidAudio + "\r\n");
                    this.lastAudioSSRC = l2;
                }
            } else if (string2.startsWith("m=video")) {
                stringBuilder.append(string2);
                if (string2.indexOf("a=ssrc:") < 0) {
                    l2 = l + 10L;
                    stringBuilder.append("a=ssrc-group:FID " + (l2 + 0L) + " " + (l2 + 1L) + "\r\n");
                    int n2 = 0;
                    while (n2 < 2) {
                        stringBuilder.append("a=ssrc:" + (l2 + (long)n2) + " cname:" + this.lastCNAME + "\r\n");
                        stringBuilder.append("a=ssrc:" + (l2 + (long)n2) + " msid:" + this.streamLabel + " " + this.msidVideo + "\r\n");
                        stringBuilder.append("a=ssrc:" + (l2 + (long)n2) + " mslabel:" + this.streamLabel + "\r\n");
                        stringBuilder.append("a=ssrc:" + (l2 + (long)n2) + " label:" + this.msidVideo + "\r\n");
                        ++n2;
                    }
                    this.lastVideoSSRC = l2;
                }
            } else {
                stringBuilder.append(string2);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    private String changeMediaSSRC(String string, long l) {
        String string2 = "a=ssrc-group:FID(( \\d+)+)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        int n = 0;
        while (matcher.find()) {
            String[] stringArray;
            String string3 = matcher.group(1);
            String[] stringArray2 = stringArray = string3.trim().split(" ");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string4 = stringArray2[n3];
                string = string.replaceAll(string4, "" + (l + (long)n));
                ++n;
                ++n3;
            }
        }
        if (n == 0) {
            string = string.replaceAll("a=ssrc:(\\d+)", "a=ssrc:" + l);
        }
        return string;
    }

    public String changeSSRC(String string) {
        String[] stringArray = SDPSsrcChanger.splitSDP2Medias(string);
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string2.startsWith("m=audio") && this.lastAudioSSRC > 0L) {
                string2 = this.changeMediaSSRC(string2, this.lastAudioSSRC);
                stringBuilder.append(string2);
            } else if (string2.startsWith("m=video") && this.lastVideoSSRC > 0L) {
                string2 = this.changeMediaSSRC(string2, this.lastVideoSSRC);
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(string2);
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    static String[] splitSDP2Medias(String string) {
        String[] stringArray = string.split("\r\nm=");
        if (stringArray.length < 2) {
            return new String[]{string};
        }
        String[] stringArray2 = new String[stringArray.length];
        stringArray2[0] = String.valueOf(stringArray[0]) + "\r\n";
        int n = 1;
        while (n < stringArray.length) {
            stringArray2[n] = "m=" + stringArray[n];
            if (n != stringArray.length - 1) {
                int n2 = n;
                stringArray2[n2] = String.valueOf(stringArray2[n2]) + "\r\n";
            }
            ++n;
        }
        return stringArray2;
    }

    static long getNextStartSSRC() {
        long l = Math.abs(new Random().nextLong() % 100000000L);
        l -= l % ssrcInterval;
        return l;
    }
}

