/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.graphics.Rect;
import android.opengl.EGL14;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import com.superrtc.call.EglBase;
import com.superrtc.call.EglBase10;
import com.superrtc.call.EglBase14;
import com.superrtc.call.GlRectDrawer;
import com.superrtc.call.GlTextureFrameBuffer;
import com.superrtc.call.GlUtil;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.VideoRenderer;
import com.superrtc.call.VideoRendererGui;
import com.superrtc.sdk.VideoView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.opengles.GL10;

public class VideoRendererGui2
implements GLSurfaceView.Renderer {
    private Runnable eglContextReady = null;
    private static final String TAG = "VideoRendererGui2";
    private VideoView surface;
    private EglBase.Context eglContext = null;
    private boolean onSurfaceCreatedCalled;
    private int screenWidth;
    private int screenHeight;
    private final ArrayList<YuvImageRenderer> yuvImageRenderers;
    private Thread renderFrameThread;
    private Thread drawThread;
    private boolean renderEnabled = true;

    @SuppressLint(value={"NewApi"})
    public VideoRendererGui2(VideoView videoView, Runnable runnable) {
        this.surface = videoView;
        this.eglContextReady = runnable;
        videoView.setPreserveEGLContextOnPause(true);
        videoView.setEGLContextClientVersion(2);
        videoView.setRenderer(this);
        videoView.setRenderMode(0);
        this.yuvImageRenderers = new ArrayList();
    }

    public void setReadyCallback(Runnable runnable) {
        this.eglContextReady = runnable;
    }

    public int getframesReceived() {
        int n = 0;
        Iterator<YuvImageRenderer> iterator = this.yuvImageRenderers.iterator();
        if (iterator.hasNext()) {
            YuvImageRenderer yuvImageRenderer = iterator.next();
            n = yuvImageRenderer.framesReceived;
        }
        return n;
    }

    public synchronized EglBase.Context getEglBaseContext() {
        return this.eglContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            return;
        }
        Logging.d(TAG, "VideoRendererGui.dispose");
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : videoRendererGui2.yuvImageRenderers) {
                yuvImageRenderer.release();
            }
            videoRendererGui2.yuvImageRenderers.clear();
        }
        this.renderFrameThread = null;
        this.drawThread = null;
        videoRendererGui2.surface = null;
        this.eglContext = null;
        this.eglContextReady = null;
        videoRendererGui2 = null;
    }

    public VideoRenderer createGui(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) throws Exception {
        YuvImageRenderer yuvImageRenderer = this.create(n, n2, n3, n4, scalingType, bl);
        return new VideoRenderer(yuvImageRenderer);
    }

    public VideoRenderer.Callbacks createGuiRenderer(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        return this.create(n, n2, n3, n4, scalingType, bl);
    }

    public synchronized YuvImageRenderer create(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        return this.create(n, n2, n3, n4, scalingType, bl, new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized YuvImageRenderer create(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl, RendererCommon.GlDrawer glDrawer) {
        Object object;
        if (n < 0 || n > 100 || n2 < 0 || n2 > 100 || n3 < 0 || n3 > 100 || n4 < 0 || n4 > 100 || n + n3 > 100 || n2 + n4 > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        final VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            throw new RuntimeException("Attempt to create yuv renderer before setting GLSurfaceView");
        }
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(videoRendererGui2.surface, videoRendererGui2.yuvImageRenderers.size(), n, n2, n3, n4, scalingType, bl, glDrawer);
        if (videoRendererGui2.onSurfaceCreatedCalled) {
            object = new CountDownLatch(1);
            if (videoRendererGui2.surface != null) {
                videoRendererGui2.surface.queueEvent(new Runnable((CountDownLatch)object){
                    private final /* synthetic */ CountDownLatch val$countDownLatch;
                    {
                        this.val$countDownLatch = countDownLatch;
                    }

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(videoRendererGui2.screenWidth, videoRendererGui2.screenHeight);
                        this.val$countDownLatch.countDown();
                    }
                });
            } else {
                ((CountDownLatch)object).countDown();
            }
            try {
                ((CountDownLatch)object).await();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
        }
        object = videoRendererGui2.yuvImageRenderers;
        synchronized (object) {
            videoRendererGui2.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized YuvImageRenderer createRenderer(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl, RendererCommon.GlDrawer glDrawer) {
        if (n < 0 || n > 100 || n2 < 0 || n2 > 100 || n3 < 0 || n3 > 100 || n4 < 0 || n4 > 100 || n + n3 > 100 || n2 + n4 > 100) {
            throw new RuntimeException("Incorrect window parameters.");
        }
        final VideoRendererGui2 videoRendererGui2 = this;
        final YuvImageRenderer yuvImageRenderer = new YuvImageRenderer(videoRendererGui2.surface, videoRendererGui2.yuvImageRenderers.size(), n, n2, n3, n4, scalingType, bl, glDrawer);
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            if (videoRendererGui2.onSurfaceCreatedCalled) {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                videoRendererGui2.surface.queueEvent(new Runnable(){

                    @Override
                    public void run() {
                        yuvImageRenderer.createTextures();
                        yuvImageRenderer.setScreenSize(videoRendererGui2.screenWidth, videoRendererGui2.screenHeight);
                        countDownLatch.countDown();
                    }
                });
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            videoRendererGui2.yuvImageRenderers.add(yuvImageRenderer);
        }
        return yuvImageRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(VideoRenderer.Callbacks callbacks, int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
        Logging.d(TAG, "VideoRendererGui.update");
        VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            throw new RuntimeException("Attempt to update yuv renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : videoRendererGui2.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.setPosition(n, n2, n3, n4, scalingType, bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRendererEvents(VideoRenderer.Callbacks callbacks, RendererCommon.RendererEvents rendererEvents) {
        Logging.d(TAG, "VideoRendererGui.setRendererEvents");
        VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            throw new RuntimeException("Attempt to set renderer events before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : videoRendererGui2.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.rendererEvents = rendererEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(VideoRenderer.Callbacks callbacks) {
        Logging.d(TAG, "VideoRendererGui.remove");
        VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            throw new RuntimeException("Attempt to remove renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            int n = videoRendererGui2.yuvImageRenderers.indexOf(callbacks);
            if (n == -1) {
                Logging.w(TAG, "Couldn't remove renderer (not present in current list)");
            } else {
                videoRendererGui2.yuvImageRenderers.remove(n).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset(VideoRenderer.Callbacks callbacks) {
        Logging.d(TAG, "VideoRendererGui.reset");
        VideoRendererGui2 videoRendererGui2 = this;
        if (videoRendererGui2 == null) {
            throw new RuntimeException("Attempt to reset renderer before setting GLSurfaceView");
        }
        ArrayList<YuvImageRenderer> arrayList = videoRendererGui2.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : videoRendererGui2.yuvImageRenderers) {
                if (yuvImageRenderer != callbacks) continue;
                yuvImageRenderer.reset();
            }
        }
    }

    private static void printStackTrace(Thread thread, String string) {
        StackTraceElement[] stackTraceElementArray;
        if (thread != null && (stackTraceElementArray = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, String.valueOf(string) + " stacks trace:");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                Logging.d(TAG, stackTraceElement.toString());
                ++n2;
            }
        }
    }

    public synchronized void printStackTraces() {
        VideoRendererGui2.printStackTrace(this.renderFrameThread, "Render frame thread");
        VideoRendererGui2.printStackTrace(this.drawThread, "Draw thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceCreated");
        Class<VideoRendererGui2> clazz = VideoRendererGui.class;
        synchronized (VideoRendererGui.class) {
            this.eglContext = EglBase14.isEGL14Supported() ? new EglBase14.Context(EGL14.eglGetCurrentContext()) : new EglBase10.Context(((EGL10)EGLContext.getEGL()).eglGetCurrentContext());
            Logging.d(TAG, "VideoRendererGui EGL Context: " + this.eglContext);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            clazz = this.yuvImageRenderers;
            synchronized (clazz) {
                for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                    yuvImageRenderer.createTextures();
                }
                this.onSurfaceCreatedCalled = true;
            }
            GlUtil.checkNoGLES2Error("onSurfaceCreated done");
            GLES20.glPixelStorei((int)3317, (int)1);
            GLES20.glClearColor((float)0.15f, (float)0.15f, (float)0.15f, (float)1.0f);
            clazz = VideoRendererGui2.class;
            synchronized (VideoRendererGui2.class) {
                if (this.eglContextReady != null) {
                    this.eglContextReady.run();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSurfaceChanged(GL10 gL10, int n, int n2) {
        Logging.d(TAG, "VideoRendererGui.onSurfaceChanged: " + n + " x " + n2 + "  ");
        this.screenWidth = n;
        this.screenHeight = n2;
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.setScreenSize(this.screenWidth, this.screenHeight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDrawFrame(GL10 gL10) {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            if (!this.onSurfaceCreatedCalled) {
                return;
            }
        }
        if (this.drawThread == null) {
            this.drawThread = Thread.currentThread();
        }
        GLES20.glViewport((int)0, (int)0, (int)this.screenWidth, (int)this.screenHeight);
        GLES20.glClear((int)16384);
        arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            if (!this.renderEnabled) {
                return;
            }
            for (YuvImageRenderer yuvImageRenderer : this.yuvImageRenderers) {
                yuvImageRenderer.draw();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderEnable(boolean bl) {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            this.renderEnabled = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRenderEnable() {
        ArrayList<YuvImageRenderer> arrayList = this.yuvImageRenderers;
        synchronized (arrayList) {
            return this.renderEnabled;
        }
    }

    private static class YuvImageRenderer
    implements VideoRenderer.Callbacks {
        private VideoView surface;
        private int id;
        private int[] yuvTextures = new int[3];
        private final RendererCommon.YuvUploader yuvUploader = new RendererCommon.YuvUploader();
        private final RendererCommon.GlDrawer drawer;
        private GlTextureFrameBuffer textureCopy;
        private VideoRenderer.I420Frame pendingFrame;
        private final Object pendingFrameLock = new Object();
        private RendererType rendererType;
        private RendererCommon.ScalingType scalingType = RendererCommon.ScalingType.SCALE_ASPECT_FIT;
        RendererCommon.ScalingType newscalingtype;
        private boolean mirror;
        private RendererCommon.RendererEvents rendererEvents;
        boolean seenFrame;
        private int framesReceived;
        private int framesDropped;
        private int framesRendered;
        private long startTimeNs = -1L;
        private long drawTimeNs;
        private long copyTimeNs;
        private final Rect layoutInPercentage;
        private final Rect displayLayout = new Rect();
        private float[] layoutMatrix;
        private boolean updateLayoutProperties;
        private final Object updateLayoutLock = new Object();
        private float[] rotatedSamplingMatrix;
        private int screenWidth;
        private int screenHeight;
        private int videoWidth;
        private int videoHeight;
        private int rotationDegree;

        private YuvImageRenderer(VideoView videoView, int n, int n2, int n3, int n4, int n5, RendererCommon.ScalingType scalingType, boolean bl, RendererCommon.GlDrawer glDrawer) {
            Logging.d(VideoRendererGui2.TAG, "YuvImageRenderer.Create id: " + n);
            this.surface = videoView;
            this.id = n;
            this.scalingType = videoView != null ? (videoView.getScaleMode() == VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit ? RendererCommon.ScalingType.SCALE_ASPECT_FIT : RendererCommon.ScalingType.SCALE_ASPECT_FILL) : scalingType;
            this.mirror = bl;
            this.drawer = glDrawer;
            this.layoutInPercentage = new Rect(n2, n3, Math.min(100, n2 + n4), Math.min(100, n3 + n5));
            this.updateLayoutProperties = false;
            this.rotationDegree = 0;
        }

        public synchronized void reset() {
            this.seenFrame = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void release() {
            this.surface = null;
            this.drawer.release();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (this.pendingFrame != null) {
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
        }

        private void createTextures() {
            Logging.d(VideoRendererGui2.TAG, "  YuvImageRenderer.createTextures " + this.id + " on GL thread:" + Thread.currentThread().getId());
            int n = 0;
            while (n < 3) {
                this.yuvTextures[n] = GlUtil.generateTexture(3553);
                ++n;
            }
            this.textureCopy = new GlTextureFrameBuffer(6407);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateLayoutMatrix() {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                RendererCommon.ScalingType scalingType = this.newscalingtype = this.surface.getScaleMode() == VideoView.EMCallViewScaleMode.EMCallViewScaleModeAspectFit ? RendererCommon.ScalingType.SCALE_ASPECT_FIT : RendererCommon.ScalingType.SCALE_ASPECT_FILL;
                if (this.newscalingtype != this.scalingType) {
                    this.updateLayoutProperties = true;
                    this.scalingType = this.newscalingtype;
                }
                if (!this.updateLayoutProperties) {
                    return;
                }
                this.displayLayout.set((this.screenWidth * this.layoutInPercentage.left + 99) / 100, (this.screenHeight * this.layoutInPercentage.top + 99) / 100, this.screenWidth * this.layoutInPercentage.right / 100, this.screenHeight * this.layoutInPercentage.bottom / 100);
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". AdjustTextureCoords. Allowed display size: " + this.displayLayout.width() + " x " + this.displayLayout.height() + ". Video: " + this.videoWidth + " x " + this.videoHeight + ". Rotation: " + this.rotationDegree + ". Mirror: " + this.mirror);
                float f = this.rotationDegree % 180 == 0 ? (float)this.videoWidth / (float)this.videoHeight : (float)this.videoHeight / (float)this.videoWidth;
                Point point = RendererCommon.getDisplaySize(this.scalingType, f, this.displayLayout.width(), this.displayLayout.height());
                this.displayLayout.inset((this.displayLayout.width() - point.x) / 2, (this.displayLayout.height() - point.y) / 2);
                Logging.d(VideoRendererGui2.TAG, "  Adjusted display size: " + this.displayLayout.width() + " x " + this.displayLayout.height());
                this.layoutMatrix = RendererCommon.getLayoutMatrix(this.mirror, f, (float)this.displayLayout.width() / (float)this.displayLayout.height());
                this.updateLayoutProperties = false;
                Logging.d(VideoRendererGui2.TAG, "  AdjustTextureCoords done");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void draw() {
            boolean bl;
            if (!this.seenFrame) {
                return;
            }
            long l = System.nanoTime();
            Object object = this.pendingFrameLock;
            synchronized (object) {
                boolean bl2 = bl = this.pendingFrame != null;
                if (bl && this.startTimeNs == -1L) {
                    this.startTimeNs = l;
                }
                if (bl) {
                    this.rotatedSamplingMatrix = RendererCommon.rotateTextureMatrix(this.pendingFrame.samplingMatrix, this.pendingFrame.rotationDegree);
                    if (this.pendingFrame.yuvFrame) {
                        this.rendererType = RendererType.RENDERER_YUV;
                        this.yuvUploader.uploadYuvData(this.yuvTextures, this.pendingFrame.width, this.pendingFrame.height, this.pendingFrame.yuvStrides, this.pendingFrame.yuvPlanes);
                    } else {
                        this.rendererType = RendererType.RENDERER_TEXTURE;
                        this.textureCopy.setSize(this.pendingFrame.rotatedWidth(), this.pendingFrame.rotatedHeight());
                        GLES20.glBindFramebuffer((int)36160, (int)this.textureCopy.getFrameBufferId());
                        GlUtil.checkNoGLES2Error("glBindFramebuffer");
                        this.drawer.drawOes(this.pendingFrame.textureId, this.rotatedSamplingMatrix, 0, 0, this.textureCopy.getWidth(), this.textureCopy.getHeight());
                        this.rotatedSamplingMatrix = RendererCommon.identityMatrix();
                        GLES20.glBindFramebuffer((int)36160, (int)0);
                        GLES20.glFinish();
                    }
                    this.copyTimeNs += System.nanoTime() - l;
                    VideoRenderer.renderFrameDone(this.pendingFrame);
                    this.pendingFrame = null;
                }
            }
            this.updateLayoutMatrix();
            object = RendererCommon.multiplyMatrices(this.rotatedSamplingMatrix, this.layoutMatrix);
            int n = this.screenHeight - this.displayLayout.bottom;
            if (this.rendererType == RendererType.RENDERER_YUV) {
                this.drawer.drawYuv(this.yuvTextures, (float[])object, this.displayLayout.left, n, this.displayLayout.width(), this.displayLayout.height());
            } else {
                this.drawer.drawRgb(this.textureCopy.getTextureId(), (float[])object, this.displayLayout.left, n, this.displayLayout.width(), this.displayLayout.height());
            }
            if (bl) {
                ++this.framesRendered;
                this.drawTimeNs += System.nanoTime() - l;
                if (this.framesRendered % 300 == 0) {
                    this.logStatistics();
                }
            }
        }

        private void logStatistics() {
            long l = System.nanoTime() - this.startTimeNs;
            Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". Type: " + (Object)((Object)this.rendererType) + ". Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered);
            if (this.framesReceived > 0 && this.framesRendered > 0) {
                Logging.d(VideoRendererGui2.TAG, "Duration: " + (int)((double)l / 1000000.0) + " ms. FPS: " + (double)this.framesRendered * 1.0E9 / (double)l);
                Logging.d(VideoRendererGui2.TAG, "Draw time: " + (int)(this.drawTimeNs / (long)(1000 * this.framesRendered)) + " us. Copy time: " + (int)(this.copyTimeNs / (long)(1000 * this.framesReceived)) + " us");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setScreenSize(int n, int n2) {
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (n == this.screenWidth && n2 == this.screenHeight) {
                    return;
                }
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setScreenSize: " + n + " x " + n2);
                this.screenWidth = n;
                this.screenHeight = n2;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setPosition(int n, int n2, int n3, int n4, RendererCommon.ScalingType scalingType, boolean bl) {
            Rect rect = new Rect(n, n2, Math.min(100, n + n3), Math.min(100, n2 + n4));
            Object object = this.updateLayoutLock;
            synchronized (object) {
                if (rect.equals((Object)this.layoutInPercentage) && scalingType == this.scalingType && bl == this.mirror) {
                    return;
                }
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setPosition: (" + n + ", " + n2 + ") " + n3 + " x " + n4 + ". Scaling: " + (Object)((Object)scalingType) + ". Mirror: " + bl);
                this.layoutInPercentage.set(rect);
                this.mirror = bl;
                this.updateLayoutProperties = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setSize(int n, int n2, int n3) {
            if (n == this.videoWidth && n2 == this.videoHeight && n3 == this.rotationDegree) {
                return;
            }
            if (this.rendererEvents != null) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". Reporting frame resolution changed to " + n + " x " + n2);
                this.rendererEvents.onFrameResolutionChanged(n, n2, n3);
            }
            Object object = this.updateLayoutLock;
            synchronized (object) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". YuvImageRenderer.setSize: " + n + " x " + n2 + " rotation " + n3);
                this.videoWidth = n;
                this.videoHeight = n2;
                this.rotationDegree = n3;
                this.updateLayoutProperties = true;
                Logging.d(VideoRendererGui2.TAG, "  YuvImageRenderer.setSize done.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void renderFrame(VideoRenderer.I420Frame i420Frame) {
            if (this.surface == null) {
                VideoRenderer.renderFrameDone(i420Frame);
                return;
            }
            if (!this.seenFrame && this.rendererEvents != null) {
                Logging.d(VideoRendererGui2.TAG, "ID: " + this.id + ". Reporting first rendered frame.");
                this.rendererEvents.onFirstFrameRendered();
            }
            ++this.framesReceived;
            Object object = this.pendingFrameLock;
            synchronized (object) {
                if (i420Frame.yuvFrame && (i420Frame.yuvStrides[0] < i420Frame.width || i420Frame.yuvStrides[1] < i420Frame.width / 2 || i420Frame.yuvStrides[2] < i420Frame.width / 2)) {
                    Logging.e(VideoRendererGui2.TAG, "Incorrect strides " + i420Frame.yuvStrides[0] + ", " + i420Frame.yuvStrides[1] + ", " + i420Frame.yuvStrides[2]);
                    VideoRenderer.renderFrameDone(i420Frame);
                    return;
                }
                if (this.pendingFrame != null) {
                    ++this.framesDropped;
                    VideoRenderer.renderFrameDone(i420Frame);
                    this.seenFrame = true;
                    return;
                }
                this.pendingFrame = i420Frame;
            }
            this.setSize(i420Frame.width, i420Frame.height, i420Frame.rotationDegree);
            this.seenFrame = true;
            this.surface.requestRender();
        }

        private static enum RendererType {
            RENDERER_YUV,
            RENDERER_TEXTURE;

        }
    }
}

