/*
 * Decompiled with CFR 0.152.
 */
package com.superrtc.call;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import android.view.WindowManager;
import com.superrtc.call.CameraEnumerationAndroid;
import com.superrtc.call.EglBase;
import com.superrtc.call.Logging;
import com.superrtc.call.RendererCommon;
import com.superrtc.call.SurfaceTextureHelper;
import com.superrtc.call.ThreadUtils;
import com.superrtc.call.VideoCapturer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class VideoCapturerAndroid
implements Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener,
VideoCapturer {
    private static final String TAG = "VideoCapturerAndroid";
    private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
    private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
    private Camera camera;
    private Thread cameraThread;
    private final Handler cameraThreadHandler;
    private Context applicationContext;
    private final Object cameraIdLock = new Object();
    private int id;
    private Camera.CameraInfo info;
    private final CameraStatistics cameraStatistics;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final Object pendingCameraSwitchLock = new Object();
    private volatile boolean pendingCameraSwitch;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private final CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private final Set<byte[]> queuedBuffers = new HashSet<byte[]>();
    private final boolean isCapturingToTexture;
    final SurfaceTextureHelper surfaceHelper;
    private boolean dropNextFrame = false;
    private Runnable openCameraOnCodecThreadRunner;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private int openCameraAttempts;
    private boolean enableCamera = true;
    private boolean supportedCamraFormats = true;
    private VideoCapturerDataProcessor dataprocessor;
    private GlTextureProcessor textureProcessor;
    private boolean enableExternalVideoData;
    private boolean isStartvideo;
    private int configRotation = 0;
    private boolean isconfigRotation = false;
    private final Camera.ErrorCallback cameraErrorCallback = new Camera.ErrorCallback(){

        public void onError(int n, Camera camera) {
            String string = n == 100 ? "Camera server died!" : "Camera error: " + n;
            Logging.e(VideoCapturerAndroid.TAG, string);
            if (VideoCapturerAndroid.this.eventsHandler != null) {
                VideoCapturerAndroid.this.eventsHandler.onCameraError(string);
            }
        }
    };
    private final Runnable cameraObserver = new Runnable(){
        private int freezePeriodCount;

        @Override
        public void run() {
            int n = VideoCapturerAndroid.this.cameraStatistics.getAndResetFrameCount();
            int n2 = (n * 1000 + 1000) / 2000;
            Logging.d(VideoCapturerAndroid.TAG, "Camera fps: " + n2 + ".");
            if (n == 0) {
                ++this.freezePeriodCount;
                if (2000 * this.freezePeriodCount >= 4000 && VideoCapturerAndroid.this.eventsHandler != null) {
                    Logging.e(VideoCapturerAndroid.TAG, "Camera freezed.");
                    if (VideoCapturerAndroid.this.surfaceHelper.isTextureInUse()) {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                    } else {
                        VideoCapturerAndroid.this.eventsHandler.onCameraFreezed("Camera failure.");
                    }
                    return;
                }
            } else {
                this.freezePeriodCount = 0;
            }
            VideoCapturerAndroid.this.cameraThreadHandler.postDelayed((Runnable)this, 2000L);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraDataProcessor(VideoCapturerDataProcessor videoCapturerDataProcessor) {
        if (this.dataprocessor != null) {
            VideoCapturerDataProcessor videoCapturerDataProcessor2 = this.dataprocessor;
            synchronized (videoCapturerDataProcessor2) {
                this.dataprocessor = videoCapturerDataProcessor;
            }
        } else {
            this.dataprocessor = videoCapturerDataProcessor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlTextureProcessor(GlTextureProcessor glTextureProcessor) {
        if (this.textureProcessor != null) {
            GlTextureProcessor glTextureProcessor2 = this.textureProcessor;
            synchronized (glTextureProcessor2) {
                this.textureProcessor = glTextureProcessor;
            }
        } else {
            this.textureProcessor = glTextureProcessor;
        }
    }

    public void setEnableExternalVideoData(boolean bl) {
        this.enableExternalVideoData = bl;
    }

    public void setRotation(int n) {
        this.isconfigRotation = true;
        this.configRotation = n;
    }

    public static VideoCapturerAndroid create(String string, CameraEventsHandler cameraEventsHandler) {
        return VideoCapturerAndroid.create(string, cameraEventsHandler, null);
    }

    public static VideoCapturerAndroid create(String string, CameraEventsHandler cameraEventsHandler, EglBase.Context context) {
        int n = VideoCapturerAndroid.lookupDeviceName(string);
        if (n == -1) {
            return null;
        }
        return new VideoCapturerAndroid(n, cameraEventsHandler, context);
    }

    public void printStackTrace() {
        StackTraceElement[] stackTraceElementArray;
        if (this.cameraThread != null && (stackTraceElementArray = this.cameraThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "VideoCapturerAndroid stacks trace:");
            StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray2[n2];
                Logging.d(TAG, stackTraceElement.toString());
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchCamera(final CameraSwitchHandler cameraSwitchHandler) {
        if (this.enableExternalVideoData) {
            return;
        }
        if (Camera.getNumberOfCameras() < 2) {
            if (cameraSwitchHandler != null) {
                cameraSwitchHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Logging.w(TAG, "Ignoring camera switch request.");
                if (cameraSwitchHandler != null) {
                    cameraSwitchHandler.onCameraSwitchError("Pending camera switch already in progress.");
                }
                return;
            }
            this.pendingCameraSwitch = true;
        }
        this.cameraThreadHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (VideoCapturerAndroid.this.camera == null) {
                    if (cameraSwitchHandler != null) {
                        cameraSwitchHandler.onCameraSwitchError("Camera is stopped.");
                    }
                    return;
                }
                VideoCapturerAndroid.this.switchCameraOnCameraThread();
                Object object = VideoCapturerAndroid.this.pendingCameraSwitchLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraSwitch = false;
                }
                if (cameraSwitchHandler != null) {
                    cameraSwitchHandler.onCameraSwitchDone(((VideoCapturerAndroid)VideoCapturerAndroid.this).info.facing == 1);
                }
            }
        });
    }

    public void onOutputFormatRequest(final int n, final int n2, final int n3) {
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.enableExternalVideoData) {
                    return;
                }
                VideoCapturerAndroid.this.onOutputFormatRequestOnCameraThread(n, n2, n3);
            }
        });
    }

    public void changeCaptureFormat(final int n, final int n2, final int n3) {
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.enableExternalVideoData) {
                    return;
                }
                VideoCapturerAndroid.this.startPreviewOnCameraThread(n, n2, n3);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return CameraEnumerationAndroid.getSupportedFormats(this.getCurrentCameraId());
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    @Override
    public SurfaceTextureHelper getSurfaceTextureHelper() {
        return this.surfaceHelper;
    }

    private VideoCapturerAndroid(int n, CameraEventsHandler cameraEventsHandler, EglBase.Context context) {
        this.id = n;
        this.eventsHandler = cameraEventsHandler;
        this.isCapturingToTexture = context != null;
        this.cameraStatistics = new CameraStatistics();
        this.surfaceHelper = SurfaceTextureHelper.create(context);
        this.cameraThreadHandler = this.surfaceHelper.getHandler();
        this.cameraThread = this.cameraThreadHandler.getLooper().getThread();
        Logging.d(TAG, "VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture);
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThread) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static int lookupDeviceName(String string) {
        Logging.d(TAG, "lookupDeviceName: " + string);
        if (string == null || Camera.getNumberOfCameras() == 0) {
            return -1;
        }
        if (string.isEmpty()) {
            return 0;
        }
        int n = 0;
        while (n < Camera.getNumberOfCameras()) {
            if (string.equals(CameraEnumerationAndroid.getDeviceName(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "release");
        if (this.isDisposed()) {
            throw new IllegalStateException("Already released");
        }
        ThreadUtils.invokeUninterruptibly(this.cameraThreadHandler, new Runnable(){

            @Override
            public void run() {
                if (VideoCapturerAndroid.this.camera != null) {
                    throw new IllegalStateException("Release called while camera is running");
                }
            }
        });
        this.surfaceHelper.dispose();
        this.cameraThread = null;
    }

    public boolean isDisposed() {
        return this.cameraThread == null;
    }

    @Override
    public boolean getSupportedGetCameraFormats() {
        return this.supportedCamraFormats;
    }

    @Override
    public void startCapture(final int n, final int n2, final int n3, final Context context, final VideoCapturer.CapturerObserver capturerObserver) {
        Logging.d(TAG, "startCapture requested: " + n + "x" + n2 + "@" + n3);
        if (context == null) {
            throw new RuntimeException("applicationContext not set.");
        }
        if (capturerObserver == null) {
            throw new RuntimeException("frameObserver not set.");
        }
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startCaptureOnCameraThread(n, n2, n3, capturerObserver, context);
            }
        });
    }

    public void setEnableCameragetsuppoted(boolean bl) {
        this.supportedCamraFormats = bl;
    }

    public void setEnableCamera(boolean bl) {
        this.enableCamera = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(final int n, final int n2, final int n3, final VideoCapturer.CapturerObserver capturerObserver, final Context context) {
        RuntimeException runtimeException = null;
        this.checkIsOnCameraThread();
        if (this.camera != null) {
            throw new RuntimeException("Camera has already been started.");
        }
        this.applicationContext = context;
        this.frameObserver = capturerObserver;
        this.firstFrameReported = false;
        this.requestedWidth = n;
        this.requestedHeight = n2;
        this.requestedFramerate = n3;
        this.isStartvideo = true;
        if (!this.enableCamera) {
            return;
        }
        if (this.enableExternalVideoData) {
            return;
        }
        try {
            try {
                Object object = this.cameraIdLock;
                synchronized (object) {
                    Logging.d(TAG, "Opening camera " + this.id);
                    if (this.eventsHandler != null) {
                        this.eventsHandler.onCameraOpening(this.id);
                    }
                    this.camera = Camera.open((int)this.id);
                    this.info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
                }
            }
            catch (RuntimeException runtimeException2) {
                ++this.openCameraAttempts;
                if (this.openCameraAttempts < 3) {
                    Logging.e(TAG, "Camera.open failed, retrying", runtimeException2);
                    this.openCameraOnCodecThreadRunner = new Runnable(){

                        @Override
                        public void run() {
                            VideoCapturerAndroid.this.startCaptureOnCameraThread(n, n2, n3, capturerObserver, context);
                        }
                    };
                    this.cameraThreadHandler.postDelayed(this.openCameraOnCodecThreadRunner, 500L);
                    return;
                }
                this.openCameraAttempts = 0;
                throw runtimeException2;
            }
            try {
                this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
            }
            catch (IOException iOException) {
                Logging.e(TAG, "setPreviewTexture failed", runtimeException);
                throw new RuntimeException(iOException);
            }
            Logging.e(TAG, "Camera orientation: " + this.info.orientation + " .Device orientation: " + this.getDeviceOrientation());
            this.camera.setErrorCallback(this.cameraErrorCallback);
            this.startPreviewOnCameraThread(n, n2, n3);
            capturerObserver.onCapturerStarted(true);
            if (this.isCapturingToTexture) {
                this.surfaceHelper.startListening(this);
            }
            this.cameraThreadHandler.postDelayed(this.cameraObserver, 2000L);
            return;
        }
        catch (RuntimeException runtimeException3) {
            runtimeException = runtimeException3;
            Logging.e(TAG, "startCapture failed", runtimeException);
            this.stopCaptureOnCameraThread();
            capturerObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera can not be started.");
            }
            return;
        }
    }

    private void startPreviewOnCameraThread(int n, int n2, int n3) {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "startPreviewOnCameraThread requested: " + n + "x" + n2 + "@" + n3);
        if (this.camera == null) {
            Logging.e(TAG, "Calling startPreviewOnCameraThread on stopped camera.");
            return;
        }
        this.requestedWidth = n;
        this.requestedHeight = n2;
        this.requestedFramerate = n3;
        Camera.Parameters parameters = this.camera.getParameters();
        int[] nArray = CameraEnumerationAndroid.getFramerateRange(parameters, n3 * 1000);
        Camera.Size size = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPreviewSizes(), n, n2);
        CameraEnumerationAndroid.CaptureFormat captureFormat = new CameraEnumerationAndroid.CaptureFormat(size.width, size.height, nArray[0], nArray[1]);
        if (captureFormat.isSameFormat(this.captureFormat)) {
            return;
        }
        Logging.d(TAG, "isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported());
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (captureFormat.maxFramerate > 0) {
            parameters.setPreviewFpsRange(captureFormat.minFramerate, captureFormat.maxFramerate);
        }
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        if (!this.isCapturingToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        Camera.Size size2 = CameraEnumerationAndroid.getClosestSupportedSize(parameters.getSupportedPictureSizes(), n, n2);
        parameters.setPictureSize(size2.width, size2.height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.dropNextFrame = true;
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        Logging.e(TAG, "Start capturing: " + captureFormat);
        this.captureFormat = captureFormat;
        List list = parameters.getSupportedFocusModes();
        if (list.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        this.camera.setParameters(parameters);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int n4 = captureFormat.frameSize();
            int n5 = 0;
            while (n5 < 3) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4);
                this.queuedBuffers.add(byteBuffer.array());
                this.camera.addCallbackBuffer(byteBuffer.array());
                ++n5;
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        this.camera.startPreview();
    }

    @Override
    public void stopCapture() throws InterruptedException {
        Logging.d(TAG, "stopCapture");
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.stopCaptureOnCameraThread();
                countDownLatch.countDown();
            }
        });
        countDownLatch.await();
        Logging.d(TAG, "stopCapture done");
    }

    private void stopCaptureOnCameraThread() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "stopCaptureOnCameraThread");
        if (this.openCameraOnCodecThreadRunner != null) {
            this.cameraThreadHandler.removeCallbacks(this.openCameraOnCodecThreadRunner);
        }
        this.openCameraAttempts = 0;
        if (this.camera == null) {
            Logging.e(TAG, "Calling stopCapture() for already stopped camera.");
            return;
        }
        this.surfaceHelper.stopListening();
        this.cameraThreadHandler.removeCallbacks(this.cameraObserver);
        this.cameraStatistics.getAndResetFrameCount();
        Logging.d(TAG, "Stop preview.");
        if (this.enableExternalVideoData) {
            return;
        }
        this.camera.stopPreview();
        this.camera.setPreviewCallbackWithBuffer(null);
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Logging.d(TAG, "Release camera.");
        this.camera.release();
        this.camera = null;
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
    }

    public void enableCameraThread() {
        if (this.enableCamera) {
            return;
        }
        this.enableCamera = true;
        Logging.d(TAG, "enableCameraThread");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startCaptureOnCameraThread(VideoCapturerAndroid.this.requestedWidth, VideoCapturerAndroid.this.requestedHeight, VideoCapturerAndroid.this.requestedFramerate, VideoCapturerAndroid.this.frameObserver, VideoCapturerAndroid.this.applicationContext);
            }
        });
        Logging.d(TAG, "enableCameraThread done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread();
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.dropNextFrame = true;
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate, this.frameObserver, this.applicationContext);
        Logging.d(TAG, "switchCameraOnCameraThread done");
    }

    private void onOutputFormatRequestOnCameraThread(int n, int n2, int n3) {
        this.checkIsOnCameraThread();
        if (this.camera == null) {
            Logging.e(TAG, "Calling onOutputFormatRequest() on stopped camera.");
            return;
        }
        Logging.d(TAG, "onOutputFormatRequestOnCameraThread: " + n + "x" + n2 + "@" + n3);
        this.frameObserver.onOutputFormatRequest(n, n2, n3);
    }

    Handler getCameraThreadHandler() {
        return this.cameraThreadHandler;
    }

    private int getDeviceOrientation() {
        int n = 0;
        WindowManager windowManager = (WindowManager)this.applicationContext.getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                n = 90;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 270;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private int getFrameOrientation() {
        int n = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            n = 360 - n;
        }
        return (this.info.orientation + n) % 360;
    }

    public void handleZoom(boolean bl) {
        Camera.Parameters parameters;
        if (this.camera == null) {
            Logging.e(TAG, "camera is not Initialized");
        }
        if ((parameters = this.camera.getParameters()).isZoomSupported()) {
            int n = parameters.getMaxZoom();
            int n2 = parameters.getZoom();
            if (bl && n2 < n) {
                ++n2;
            } else if (n2 > 0) {
                --n2;
            }
            parameters.setZoom(n2);
            this.camera.setParameters(parameters);
        } else {
            Logging.e(TAG, "zoom not supported");
        }
    }

    public void handleFocusMetering(float f, float f2, int n, int n2) {
        Object object;
        Rect rect = VideoCapturerAndroid.calculateTapArea(f, f2, 1.0f, n, n2);
        Rect rect2 = VideoCapturerAndroid.calculateTapArea(f, f2, 1.5f, n, n2);
        this.camera.cancelAutoFocus();
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters.getMaxNumFocusAreas() > 0) {
            object = new ArrayList<Camera.Area>();
            object.add(new Camera.Area(rect, 800));
            parameters.setFocusAreas((List)object);
        } else {
            Logging.e(TAG, "focus areas not supported");
        }
        if (parameters.getMaxNumMeteringAreas() > 0) {
            object = new ArrayList();
            object.add(new Camera.Area(rect2, 800));
            parameters.setMeteringAreas((List)object);
        } else {
            Logging.e(TAG, "metering areas not supported");
        }
        object = parameters.getFocusMode();
        parameters.setFocusMode("macro");
        this.camera.setParameters(parameters);
        this.camera.autoFocus(new Camera.AutoFocusCallback((String)object){
            private final /* synthetic */ String val$currentFocusMode;
            {
                this.val$currentFocusMode = string;
            }

            public void onAutoFocus(boolean bl, Camera camera) {
                Camera.Parameters parameters = camera.getParameters();
                parameters.setFocusMode(this.val$currentFocusMode);
                camera.setParameters(parameters);
            }
        });
    }

    private static Rect calculateTapArea(float f, float f2, float f3, int n, int n2) {
        float f4 = 300.0f;
        int n3 = Float.valueOf(f4 * f3).intValue();
        int n4 = (int)(f / (float)n * 2000.0f - 1000.0f);
        int n5 = (int)(f2 / (float)n2 * 2000.0f - 1000.0f);
        int n6 = n3 / 2;
        RectF rectF = new RectF((float)VideoCapturerAndroid.clamp(n4 - n6, -1000, 1000), (float)VideoCapturerAndroid.clamp(n5 - n6, -1000, 1000), (float)VideoCapturerAndroid.clamp(n4 + n6, -1000, 1000), (float)VideoCapturerAndroid.clamp(n5 + n6, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int n, int n2, int n3) {
        if (n > n3) {
            return n3;
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPreviewFrame(byte[] byArray, Camera camera) {
        this.checkIsOnCameraThread();
        if (this.camera == null || !this.queuedBuffers.contains(byArray)) {
            return;
        }
        if (this.camera != camera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long l = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        int n = this.getFrameOrientation();
        if (this.dataprocessor != null) {
            VideoCapturerDataProcessor videoCapturerDataProcessor = this.dataprocessor;
            synchronized (videoCapturerDataProcessor) {
                this.dataprocessor.onProcessData(byArray, camera, this.captureFormat.width, this.captureFormat.height, n);
            }
        }
        if (this.isconfigRotation) {
            n = this.configRotation;
        }
        this.frameObserver.onByteBufferFrameCaptured(byArray, this.captureFormat.width, this.captureFormat.height, n, l);
        this.camera.addCallbackBuffer(byArray);
    }

    public void inputExternalVideoData(byte[] byArray, int n, int n2, int n3) {
        if (!this.isStartvideo || !this.enableExternalVideoData) {
            return;
        }
        long l = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        if (this.frameObserver != null) {
            this.frameObserver.onByteBufferFrameCaptured(byArray, n, n2, n3, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTextureFrameAvailable(int n, float[] fArray, long l) {
        if (this.camera == null) {
            throw new RuntimeException("onTextureFrameAvailable() called after stopCapture().");
        }
        this.checkIsOnCameraThread();
        if (this.dropNextFrame) {
            this.surfaceHelper.returnTextureFrame();
            this.dropNextFrame = false;
            return;
        }
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        int n2 = this.getFrameOrientation();
        if (this.info.facing == 1) {
            fArray = RendererCommon.multiplyMatrices(fArray, RendererCommon.horizontalFlipMatrix());
        }
        if (this.textureProcessor != null) {
            GlTextureProcessor glTextureProcessor = this.textureProcessor;
            synchronized (glTextureProcessor) {
                this.textureProcessor.onDrawFrame(n, this.captureFormat.width, this.captureFormat.height, fArray, n2);
            }
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, n, fArray, n2, l);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraFreezed(String var1);

        public void onCameraOpening(int var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }

    private static class CameraStatistics {
        private int frameCount = 0;
        private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();

        CameraStatistics() {
            this.threadChecker.detachThread();
        }

        public void addFrame() {
            this.threadChecker.checkIsOnValidThread();
            ++this.frameCount;
        }

        public int getAndResetFrameCount() {
            this.threadChecker.checkIsOnValidThread();
            int n = this.frameCount;
            this.frameCount = 0;
            return n;
        }
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface GlTextureProcessor {
        public void onDrawFrame(int var1, int var2, int var3, float[] var4, int var5);
    }

    public static interface VideoCapturerDataProcessor {
        public void onProcessData(byte[] var1, Camera var2, int var3, int var4, int var5);

        public void setResolution(int var1, int var2);
    }
}

