/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.UUID;

public class DeviceUuidFactory {
    protected static final String PREFS_FILE = "device_id.xml";
    protected static final String PREFS_DEVICE_ID = "device_id";
    protected static UUID uuid;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeviceUuidFactory(Context context) {
        if (uuid != null) return;
        Class<DeviceUuidFactory> clazz = DeviceUuidFactory.class;
        synchronized (DeviceUuidFactory.class) {
            if (uuid != null) return;
            SharedPreferences sharedPreferences = context.getSharedPreferences(PREFS_FILE, 0);
            String string = sharedPreferences.getString(PREFS_DEVICE_ID, null);
            if (string != null) {
                uuid = UUID.fromString(string);
            } else {
                String string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
                try {
                    String string3;
                    uuid = !"9774d56d682e549c".equals(string2) ? UUID.nameUUIDFromBytes(string2.getBytes("utf8")) : ((string3 = ((TelephonyManager)context.getSystemService("phone")).getDeviceId()) != null ? UUID.nameUUIDFromBytes(string3.getBytes("utf8")) : this.generateDeviceUuid(context));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException);
                }
                sharedPreferences.edit().putString(PREFS_DEVICE_ID, uuid.toString()).apply();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private UUID generateDeviceUuid(Context context) {
        String string = Build.BOARD + Build.BRAND + Build.CPU_ABI + Build.DEVICE + Build.DISPLAY + Build.FINGERPRINT + Build.HOST + Build.ID + Build.MANUFACTURER + Build.MODEL + Build.PRODUCT + Build.TAGS + Build.TYPE + Build.USER;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String string2 = telephonyManager.getDeviceId();
        String string3 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        String string4 = wifiManager.getConnectionInfo().getMacAddress();
        if (DeviceUuidFactory.isEmpty(string2) && DeviceUuidFactory.isEmpty(string3) && DeviceUuidFactory.isEmpty(string4)) {
            return UUID.randomUUID();
        }
        String string5 = string + string2 + string3 + string4;
        return UUID.nameUUIDFromBytes(string5.getBytes());
    }

    public UUID getDeviceUuid() {
        return uuid;
    }

    private static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String && ((String)object).trim().length() == 0) {
            return true;
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return false;
    }
}

