/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMContact;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.util.EMLog;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageEncoder {
    private static final String TAG = "encoder";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_MSG = "msg";
    public static final String ATTR_URL = "url";
    public static final String ATTR_LOCALURL = "localurl";
    public static final String ATTR_THUMB_LOCALURL = "thumblocalurl";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_THUMBNAIL = "thumb";
    public static final String ATTR_SECRET = "secret";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_IMG_WIDTH = "width";
    public static final String ATTR_IMG_HEIGHT = "height";
    public static final String ATTR_THUMBNAIL_SECRET = "thumb_secret";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_ADDRESS = "addr";
    public static final String ATTR_LATITUDE = "lat";
    public static final String ATTR_LONGITUDE = "lng";
    public static final String ATTR_ACTION = "action";
    public static final String ATTR_PARAM = "param";
    public static final String ATTR_FILE_LENGTH = "file_length";
    public static final String ATTR_EXT = "ext";
    private static final String ATTR_TYPE_TXT = "txt";
    private static final String ATTR_TYPE_IMG = "img";
    private static final String ATTR_TYPE_VOICE = "audio";
    private static final String ATTR_TYPE_VIDEO = "video";
    private static final String ATTR_TYPE_LOCATION = "loc";
    private static final String ATTR_TYPE_CMD = "cmd";
    private static final String ATTR_TYPE_file = "file";

    public static EMMessage getMsgFromJson(String string) {
        try {
            EMVideoMessageBody eMVideoMessageBody;
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            EMContact eMContact = new EMContact(jSONObject.getString(ATTR_FROM));
            EMContact eMContact2 = new EMContact(jSONObject.getString(ATTR_TO));
            JSONArray jSONArray = jSONObject.getJSONArray("bodies");
            if (jSONArray.length() < 1) {
                EMLog.d(TAG, "wrong msg without body");
                return null;
            }
            JSONObject jSONObject2 = jSONArray.getJSONObject(0);
            String string3 = jSONObject2.getString(ATTR_TYPE);
            EMMessage.Type type = EMMessage.Type.TXT;
            if (string3.equals(ATTR_TYPE_TXT)) {
                type = EMMessage.Type.TXT;
            } else if (string3.equals(ATTR_TYPE_IMG)) {
                type = EMMessage.Type.IMAGE;
            } else if (string3.equals(ATTR_TYPE_file)) {
                type = EMMessage.Type.FILE;
            } else if (string3.equals(ATTR_TYPE_VIDEO)) {
                type = EMMessage.Type.VIDEO;
            } else if (string3.equals(ATTR_TYPE_VOICE)) {
                type = EMMessage.Type.VOICE;
            } else if (string3.equals(ATTR_TYPE_LOCATION)) {
                type = EMMessage.Type.LOCATION;
            } else if (string3.equals(ATTR_TYPE_CMD)) {
                type = EMMessage.Type.CMD;
            }
            EMMessage eMMessage = null;
            eMMessage = eMContact.username.equals(EMClient.getInstance().getCurrentUser()) ? EMMessage.createSendMessage(type) : EMMessage.createReceiveMessage(type);
            if (string3.equals(ATTR_TYPE_TXT)) {
                string2 = jSONObject2.getString(ATTR_MSG);
                String string4 = string2.replaceAll("%22", "\"");
                EMTextMessageBody eMTextMessageBody = new EMTextMessageBody(string4);
                eMMessage.addBody(eMTextMessageBody);
            } else if (string3.equals(ATTR_TYPE_IMG)) {
                string2 = jSONObject2.getString(ATTR_URL);
                String string5 = jSONObject2.getString(ATTR_FILENAME);
                String string6 = string2;
                if (jSONObject2.has(ATTR_THUMBNAIL)) {
                    string6 = jSONObject2.getString(ATTR_THUMBNAIL);
                }
                EMImageMessageBody eMImageMessageBody = new EMImageMessageBody(string5, string2, string6);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    eMImageMessageBody.setLocalUrl(jSONObject2.getString(ATTR_LOCALURL));
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    eMImageMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                if (jSONObject2.has(ATTR_THUMBNAIL_SECRET)) {
                    eMImageMessageBody.setThumbnailSecret(jSONObject2.getString(ATTR_THUMBNAIL_SECRET));
                }
                if (jSONObject2.has(ATTR_SIZE)) {
                    eMVideoMessageBody = jSONObject2.getJSONObject(ATTR_SIZE);
                    eMImageMessageBody.setSize(eMVideoMessageBody.getInt(ATTR_IMG_WIDTH), eMVideoMessageBody.getInt(ATTR_IMG_HEIGHT));
                }
                eMMessage.addBody(eMImageMessageBody);
            } else if (string3.equals(ATTR_TYPE_file)) {
                string2 = jSONObject2.getString(ATTR_URL);
                String string7 = jSONObject2.getString(ATTR_FILENAME);
                EMNormalFileMessageBody eMNormalFileMessageBody = new EMNormalFileMessageBody(string7, string2);
                eMNormalFileMessageBody.setFileLength(Integer.parseInt(jSONObject2.getString(ATTR_FILE_LENGTH)));
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    eMNormalFileMessageBody.setLocalUrl(jSONObject2.getString(ATTR_LOCALURL));
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    eMNormalFileMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                eMMessage.addBody(eMNormalFileMessageBody);
            } else if (string3.equals(ATTR_TYPE_VIDEO)) {
                string2 = jSONObject2.getString(ATTR_URL);
                String string8 = jSONObject2.getString(ATTR_FILENAME);
                String string9 = jSONObject2.getString(ATTR_THUMBNAIL);
                int n = jSONObject2.getInt(ATTR_LENGTH);
                eMVideoMessageBody = new EMVideoMessageBody(string8, string2, string9, n);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    eMVideoMessageBody.setLocalUrl(jSONObject2.getString(ATTR_LOCALURL));
                }
                if (jSONObject2.has(ATTR_FILE_LENGTH)) {
                    eMVideoMessageBody.setFileLength(jSONObject2.getLong(ATTR_FILE_LENGTH));
                }
                if (jSONObject2.has(ATTR_THUMB_LOCALURL)) {
                    eMVideoMessageBody.setLocalThumb(jSONObject2.getString(ATTR_THUMB_LOCALURL));
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    eMVideoMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                if (jSONObject2.has(ATTR_THUMBNAIL_SECRET)) {
                    eMVideoMessageBody.setThumbnailSecret(jSONObject2.getString(ATTR_THUMBNAIL_SECRET));
                }
                eMMessage.addBody(eMVideoMessageBody);
            } else if (string3.equals(ATTR_TYPE_VOICE)) {
                string2 = jSONObject2.getString(ATTR_URL);
                String string10 = jSONObject2.getString(ATTR_FILENAME);
                int n = jSONObject2.getInt(ATTR_LENGTH);
                EMVoiceMessageBody eMVoiceMessageBody = new EMVoiceMessageBody(string10, string2, n);
                if (jSONObject2.has(ATTR_LOCALURL)) {
                    eMVoiceMessageBody.setLocalUrl(jSONObject2.getString(ATTR_LOCALURL));
                }
                if (jSONObject2.has(ATTR_SECRET)) {
                    eMVoiceMessageBody.setSecret(jSONObject2.getString(ATTR_SECRET));
                }
                eMMessage.addBody(eMVoiceMessageBody);
            } else if (string3.equals(ATTR_TYPE_LOCATION)) {
                string2 = jSONObject2.getString(ATTR_ADDRESS);
                double d = jSONObject2.getDouble(ATTR_LATITUDE);
                double d2 = jSONObject2.getDouble(ATTR_LONGITUDE);
                EMLocationMessageBody eMLocationMessageBody = new EMLocationMessageBody(string2, d, d2);
                eMMessage.addBody(eMLocationMessageBody);
            } else if (string3.equals(ATTR_TYPE_CMD)) {
                // empty if block
            }
            if (eMMessage != null) {
                eMMessage.setFrom(eMContact.getUsername());
                eMMessage.setTo(eMContact2.getUsername());
            }
            if (jSONObject.has(ATTR_EXT)) {
                string2 = jSONObject.getJSONObject(ATTR_EXT);
                Iterator iterator = string2.keys();
                while (iterator.hasNext()) {
                    String string11 = (String)iterator.next();
                    Object object = string2.get(string11);
                    if (object instanceof String) {
                        eMMessage.setAttribute(string11, (String)object);
                        continue;
                    }
                    if (object instanceof Integer) {
                        eMMessage.setAttribute(string11, (Integer)object);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        eMMessage.setAttribute(string11, (Boolean)object);
                        continue;
                    }
                    if (object instanceof JSONObject) {
                        eMMessage.setAttribute(string11, (JSONObject)object);
                        continue;
                    }
                    if (object instanceof JSONArray) {
                        eMMessage.setAttribute(string11, (JSONArray)object);
                        continue;
                    }
                    EMLog.e(ATTR_MSG, "unknow additonal msg attr:" + object.getClass().getName());
                }
            }
            return eMMessage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

