/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

import com.hyphenate.chat.adapter.message.EMAMessage;

public class EMAChatConfig extends EMABase {
	
	public void init(String resourcePath, String workPath, String appKey) {
		nativeInit(resourcePath, workPath, appKey);
	}
	
	public String getResourcePath() {
		return nativegetResourcePath();
	}	
	native String nativegetResourcePath();
	
	public String getWorkPath() {
		return nativegetWorkPath();
	}
	native String nativegetWorkPath();
	
	public String getAppKey() {
		return nativegetAppKey();
	}
	native String nativegetAppKey();
	
	public void setAppKey(String appkey) {
		nativesetAppKey(appkey);
	}	
	native void nativesetAppKey(String appkey); 
	
	public void setIsSandboxMode(boolean b) {
		nativesetIsSandboxMode(b);
	}
	native void nativesetIsSandboxMode(boolean b);
	
	public boolean getIsSandboxMode() {
		return nativegetIsSandboxMode();
	}
	native boolean nativegetIsSandboxMode();
	
	public void setEnableConsoleLog(boolean b) {
		nativesetEnableConsoleLog(b);
	}
	native void nativesetEnableConsoleLog(boolean b);
	
	public boolean getEnableConsoleLog() {
		return nativegetEnableConsoleLog();
	}
	native boolean nativegetEnableConsoleLog();

	
	public void setAutoLogin(boolean b) {
		nativesetAutoLogin(b);
	}
	native void nativesetAutoLogin(boolean b);
	
	public boolean getAutoLogin() {
		return nativegetAutoLogin();
	}
	native boolean nativegetAutoLogin();
	
	public void setAutoAccept(boolean b) {
		nativesetAutoAccept(b);
	}
	native void nativesetAutoAccept(boolean b);
	
	public boolean getAutoAccept() {
		return nativegetAutoAccept();
	}
	native boolean nativegetAutoAccept();
	
	public void setRequireReadAck(boolean b) {
		nativesetRequireReadAck(b);
	}
	native void nativesetRequireReadAck(boolean b);
	
	public boolean getRequireReadAck() {
		return nativegetRequireReadAck();
	}	
	native boolean nativegetRequireReadAck();
	
	public void setRequireDeliveryAck(boolean b) {
		nativesetRequireDeliveryAck(b);
	}
	native void nativesetRequireDeliveryAck(boolean b);
	
	public boolean getRequireDeliveryAck() {
		return nativegetRequireDeliveryAck();
	}
	native boolean nativegetRequireDeliveryAck();

	public void setAutoConversationLoaded(boolean b) {
		nativesetAutoConversationLoaded(b);
	}
	native void nativesetAutoConversationLoaded(boolean b);
	
	public boolean getAutoConversationLoaded() {
		return nativegetAutoConversationLoaded();
	}
	native boolean nativegetAutoConversationLoaded();
	
	public void setDeleteMessageAsExitGroup(boolean b) {
		nativesetDeleteMessageAsExitGroup(b);
	}
	native void nativesetDeleteMessageAsExitGroup(boolean b);
	
	public boolean getDeleteMessageAsExitGroup() {
		return nativegetDeleteMessageAsExitGroup();
	}
	native boolean nativegetDeleteMessageAsExitGroup();
	
	public void setAutoAcceptGroupInvitation(boolean b) {
	    nativesetAutoAcceptGroupInvitation(b);
	}
	native void nativesetAutoAcceptGroupInvitation(boolean b);

	public boolean getAutoAcceptGroupInvitation() {
	    return nativegetAutoAcceptGroupInvitation();
	}
	native boolean nativegetAutoAcceptGroupInvitation();
	
	public void setIsChatroomOwnerLeaveAllowed(boolean b) {
		nativesetIsChatroomOwnerLeaveAllowed(b);
	}
	native void nativesetIsChatroomOwnerLeaveAllowed(boolean b);
	
	public boolean getIsChatroomOwnerLeaveAllowed() {
		return nativegetIsChatroomOwnerLeaveAllowed();
	}
	native boolean nativegetIsChatroomOwnerLeaveAllowed();
	
	public boolean isGcmEnabled(){
	    return nativeIsGcmEnabled();
	}
    native boolean nativeIsGcmEnabled();
	
	public void setChatServer(String address) {
		nativesetChatServer(address);
	}
	native void nativesetChatServer(String address);
	
	public void setChatPort(int port) {
	    nativesetChatPort(port);
	}
	native void nativesetChatPort(int port);
	
	public void setRestServer(String resturl) {
		nativesetRestServer(resturl);
	}
	native void nativesetRestServer(String resturl);
	
	public void setChatDomain(String domain) {
		nativesetChatDomain(domain);
	}
	native void nativesetChatDomain(String domain);
	
	public void setGroupDomain(String domain) {
		nativesetGroupDomain(domain);
	}
	native void nativesetGroupDomain(String domain);
	
	public void enableDnsConfig(boolean b) {
		nativeenableDnsConfig(b);
	}
	native void nativeenableDnsConfig(boolean b);

	public boolean isEnableDnsConfig() {
		return nativeisEnableDnsConfig();
	}
	native boolean nativeisEnableDnsConfig();
	
	public String getChatAddress() {
		return nativegetChatAddress();
	}
	native String nativegetChatAddress();
	

	public String getRestServer() {
		return nativegetRestServer();
	}
	native String nativegetRestServer();
	
	public String getChatDomain() {
		return nativegetChatDomain();
	}
	native String nativegetChatDomain();
	
	public String getGroupDomain() {
		return nativegetGroupDomain();
	}
	native String nativegetGroupDomain();
	
	public boolean useHttps() {
		return false;
//		return nativeuserHttps();
	}
	native boolean nativeuseHttps();
	
	// native part EMDNSManager, rest base url
	public String getBaseUrl() {
		return nativegetBaseUrl();
	}
	native String nativegetBaseUrl();
	
	// native part EMDNSManager
	public String getNextAvailableBaseUrl() {
		return nativegetNextAvailableBaseUrl();
	}
	native String nativegetNextAvailableBaseUrl();
	
	public String getAccessToken() {
		return getAccessToken(false);
	}
	
	public String getAccessToken(boolean getFromServer) {
		return nativegetAccessToken(getFromServer);
	}
	native String nativegetAccessToken(boolean getFromServer);
	
	public long getTokenSaveTime() {
		return nativegetTokenSaveTime();
	}
	native long nativegetTokenSaveTime();
	
    public void importMessages(List<EMAMessage> msgs) {
    	nativeImportMessages(msgs);
    }    
    native void nativeImportMessages(List<EMAMessage> msgs);
    
    public void openDatabase(String username) {
    	nativeOpenDatabase(username);
    }
    native void nativeOpenDatabase(String username);
    
    public void setLogPath(String path) {
    	nativesetLogPath(path);
    }
    native void nativesetLogPath(String path);
    
    public void setDownloadPath(String path) {
        nativesetDownloadPath(path);
    }
    native void nativesetDownloadPath(String path);

	public String getDownloadPath() {
		return nativegetDownloadPath();
	}
	native String nativegetDownloadPath();
   
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(String resourcePath, String workPath, String appKey);	
//	native void nativeInit(EMAChatConfig message);	
	native void nativeFinalize();

	public void retrieveDNSConfig() {
		nativeretrieveDNSConfig();
	}
	native void nativeretrieveDNSConfig();
	
	public void uploadLog(EMACallback callback) {
	    nativeUploadLog(callback);
	}
	native void nativeUploadLog(EMACallback callback);

	public void setDebugMode(boolean debug) {
	    nativeSetDebugMode(debug);
	}
	native void nativeSetDebugMode(boolean debug);

	public void setUseEncryption(boolean value) {
	    nativeSetUseEncryption(value);
	}
	native void nativeSetUseEncryption(boolean value);
	
	public boolean getUserEncryption() {
	    return nativeGetUseEncryption();
	}
	native boolean nativeGetUseEncryption();
	
	public void importGroup(String id, int style, String owner, String subject, String description, List<String> allMembers, boolean isBlocked, int maxUsers) {
	    nativeImportGroup(id, style, owner, subject, description, allMembers, isBlocked, maxUsers);
	}
	native void nativeImportGroup(String id, int style, String owner, String subject, String description, List<String> allMembers, boolean isBlocked, int maxUsers);

	public void importChatRoom(String username, String ownerName, String subject, String description, List<String> members, int maxUsers) {
	    nativeImportChatRoom(username, ownerName, subject, description, members, maxUsers);
	}
	native void nativeImportChatRoom(String username, String ownerName, String subject, String description, List<String> members, int maxUsers);
	
	public void importConversation(String convId, int type, String ext) {
	    nativeImportConversation(convId, type, ext);
	}
	native void nativeImportConversation(String convId, int type, String ext);
	
	public void importBlackList(List<String> blacklist) {
	    nativeImportBlackList(blacklist);
	}
	native void nativeImportBlackList(List<String> blacklist);
	
	public void setNetCallback(EMANetCallback callback) {
	    nativeSetCallbackNet(callback);
	}
	native void nativeSetCallbackNet(EMANetCallback callback);
	
	public void updateConversationUnreadCount(String conversationId, int count) {
	    nativeUpdateConversationUnreadCount(conversationId, count);
	}
	native void nativeUpdateConversationUnreadCount(String conversationId, int count);
	
	public void importContacts(List<String> contacts) {
	    nativeImportContacts(contacts);
	}
	native void nativeImportContacts(List<String> contacts);
	
	public void reloadAll() {
	    nativeReloadAll();
	}
	native void nativeReloadAll();
	
	public static void logD(String tag, String msg) {
	    nativeLogD(tag, msg);
	}
	static native void nativeLogD(String tag, String msg);
	
	public static void logE(String tag, String msg) {
	    nativeLogE(tag, msg);
	}
	native static void nativeLogE(String tag, String msg);

	public static void logI(String tag, String msg) {
	    nativeLogI(tag, msg);
	}
	native static void nativeLogI(String tag, String msg);

	public static void logV(String tag, String msg) {
	    nativeLogV(tag, msg);
	}
	native static void nativeLogV(String tag, String msg);
	    
	public static void logW(String tag, String msg) {
	    nativeLogW(tag, msg);
	}
	native static void nativeLogW(String tag, String msg);

	public void setSDKVersion(String sdkVersion) {
	    nativeSetSDKVersion(sdkVersion);
	}
	native void nativeSetSDKVersion(String sdkVersion);
	
	public void setUseAws(boolean useAws) {
	    nativeSetUseAws(useAws);
	}
	native void nativeSetUseAws(boolean useAws);

	public boolean getUseAws() {
		return nativeGetUseAws();
	}
	native boolean nativeGetUseAws();
	
	public void setSortMessageByServerTime(boolean sortByServerTime) {
	    nativeSetSortMessageByServerTime(sortByServerTime);
	}
	native void nativeSetSortMessageByServerTime(boolean sortByServerTime);
	
	public boolean getSortMessageByServerTime() {
	    return nativeGetSortMessageByServerTime();
	}
	native boolean nativeGetSortMessageByServerTime();
	
    public boolean getCallSendPushNotificaitonIfOffline(EMACallManager emaObject) {
        return nativeGetCallSendPushNotificaitonIfOffline(emaObject);
    }
    native boolean nativeGetCallSendPushNotificaitonIfOffline(EMACallManager emaObject);
    
    public void setCallSendPushNotificaitonIfOffline(EMACallManager emaObject, boolean isSend ) {
        nativeSetCallSendPushNotificationIfOffline(emaObject, isSend);
    }
    native void nativeSetCallSendPushNotificationIfOffline(EMACallManager emaObject, boolean isSend);

	public String getGaoDeDiscoverKey() {
		return nativeGetGaoDeDiscoverKey();
	}
	native String nativeGetGaoDeDiscoverKey();

	public String getGaoDeLocationKey() {
		return nativeGetGaoDeLocationKey();
	}
	native String nativeGetGaoDeLocationKey();

	public boolean hasHeartBeatCustomizedParams() {
		return nativeHasHeartBeatCustomizedParams();
	}
	native boolean nativeHasHeartBeatCustomizedParams();

	public EMAHeartBeatCustomizedParams getWifiHeartBeatCustomizedParams() {
		AtomicInteger min = new AtomicInteger();
		AtomicInteger max = new AtomicInteger();
		AtomicInteger _default = new AtomicInteger();
		nativeGetWifiHeartBeatCustomizedParams(min, max, _default);
		EMAHeartBeatCustomizedParams params = new EMAHeartBeatCustomizedParams();
		params.minInterval = min.get();
		params.maxInterval = max.get();
		params.defaultInterval = _default.get();
		return params;
	}
	native void nativeGetWifiHeartBeatCustomizedParams(AtomicInteger minInterval, AtomicInteger maxInterval, AtomicInteger defaultInterval);

	public EMAHeartBeatCustomizedParams getMobileHeartBeatCustomizedParams() {
		AtomicInteger min = new AtomicInteger();
		AtomicInteger max = new AtomicInteger();
		AtomicInteger _default = new AtomicInteger();
		nativeGetMobileHeartBeatCustomizedParams(min, max, _default);
		EMAHeartBeatCustomizedParams params = new EMAHeartBeatCustomizedParams();
		params.minInterval = min.get();
		params.maxInterval = max.get();
		params.defaultInterval = _default.get();
		return params;
	}
	native void nativeGetMobileHeartBeatCustomizedParams(AtomicInteger minInterval, AtomicInteger maxInterval, AtomicInteger defaultInterval);

	public void setUseHttps(boolean useHttps) {
		nativeSetUseHttps(useHttps);
	}
	native void nativeSetUseHttps(boolean useHttps);

    public void setDeviceUuid(String uuid) {
        nativesetDeviceUuid(uuid);
    }
    native void nativesetDeviceUuid(String uuid);

	public void setDeviceName(String deviceName) {
		nativesetDeviceName(deviceName);
	}
	native void nativesetDeviceName(String deviceName);
}
