/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.WakefulBroadcastReceiver;

import com.hyphenate.util.EMLog;

/**
 * \~chinese
 * sdk用于接收gcm消息的广播接收者
 * 
 * \~english
 * use for receive gcm messages in sdk
 */
public class EMGCMBroadcastReceiver extends WakefulBroadcastReceiver{
	
	@SuppressWarnings("FieldCanBeLocal")
	private String TAG = "EMGCMBroadcastReceiver";

	@Override
	public void onReceive(Context context, Intent intent) {
		EMLog.d(TAG, "gcm broadcastreceive!");
		try {
			if (intent.getExtras().getString("alert") == null) {
				return;
			}
			ComponentName comp = new ComponentName(context.getPackageName(),
					EMGCMListenerService.class.getName());
			startWakefulService(context, (intent.setComponent(comp)));
			setResultCode(Activity.RESULT_OK);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
