/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.cloud;

import com.hyphenate.chat.EMClient;

import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

import java.util.Map;

public class HttpClientConfig {
	private static final String EASEMOB_USERSERVER_DOMAIN_ID = "hyphenate.com";
	private static final String EASEMOB_PLATFORM="Android";
	public static String EM_TIME_OUT_KEY = "em_timeout";
	public static int 	EM_DEFAULT_TIMEOUT = 30*1000;

	/**
	 * if is hyphenate server , https replace http, because http is quickly than
	 * https
	 */
	public static String getEaseMobUserServerDomainId() {
		return EASEMOB_USERSERVER_DOMAIN_ID;
	}

	/**
	 * 为每个HttpClient添加User-Agent
	 * @return
	 */
	private static String getDefaultUserAgent() {
		String sb = "Easemob-SDK(" +
				HttpClientConfig.EASEMOB_PLATFORM +
				") " +
				EMClient.getInstance().VERSION;
		return sb;
	}
	
	
	/**
	 * DefaultHttpClient
	 * @return  httpclient
	 */
	public static DefaultHttpClient getDefaultHttpClient(){
		return getDefaultHttpClient(EM_DEFAULT_TIMEOUT);
	}
	
	public static DefaultHttpClient getDefaultHttpClient(int timeout){
		HttpParams httpParameters=new BasicHttpParams();
		HttpConnectionParams.setConnectionTimeout(httpParameters, timeout);
		HttpConnectionParams.setSoTimeout(httpParameters, 30000);
		HttpConnectionParams.setTcpNoDelay(httpParameters, true);
		HttpProtocolParams.setUserAgent(httpParameters, getDefaultUserAgent());
		
		SchemeRegistry supportedSchemes = new SchemeRegistry();
	    SocketFactory sf = PlainSocketFactory.getSocketFactory();
	    supportedSchemes.register(new Scheme("http", sf, 80));
	    supportedSchemes.register(new Scheme("https", SSLSocketFactory.getSocketFactory(), 443));
		
		ClientConnectionManager ccm = new ThreadSafeClientConnManager(httpParameters, supportedSchemes);
		DefaultHttpClient httpClient=new DefaultHttpClient(ccm, httpParameters);
		httpClient.setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy());
		httpClient.setReuseStrategy(new DefaultConnectionReuseStrategy());
		return httpClient;
	}
	
	/**
	 * 检测remoteFilePath是完整的url还是uuid，如果是uuid则需要拼接成真正的url
	 * @param remoteFilePath
	 * @return
	 */
	public static String getFileRemoteUrl(String remoteFilePath) {
		if (remoteFilePath.startsWith("http")) {
			return remoteFilePath;
		}
		String remoteUrl = getFileDirRemoteUrl();
		remoteUrl += remoteFilePath;
		return remoteUrl;
	}
	
	/**
	 * get upload download remote-url eg.image audio ect.
	 * @return
	 */
	public static String getFileDirRemoteUrl() {
		String remoteUrl = getBaseUrlByAppKey();
		remoteUrl += "/chatfiles/";
		return remoteUrl;
	}
	
	/**
	 * the base remote url with appkey
	 * @return
	 */
	public static String getBaseUrlByAppKey(){
	    return EMHttpClient.getInstance().chatConfig().getBaseUrl();
	}

	public static int getTimeout(Map<String,String> headers){
        int timeout = HttpClientConfig.EM_DEFAULT_TIMEOUT;
    	
    	if(headers != null && headers.get(HttpClientConfig.EM_TIME_OUT_KEY) != null){
    		timeout = Integer.valueOf(headers.get(HttpClientConfig.EM_TIME_OUT_KEY));
    		headers.remove(HttpClientConfig.EM_TIME_OUT_KEY);
    	}
    	
    	return timeout;
	}
}
