/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;


public class EMAGroup extends EMABase {
	
    public enum EMGroupLeaveReason {
        BE_KICKED,      //User is kicked out by the group owner
        DESTROYED       //Group was destroyed by the group owner.
    }

	public final static int EMGroupLeaveReason_BE_KICKED = 0;
	public final static int EMGroupLeaveReason_DESTROYED = 1;
	
	public EMAGroup(EMAGroup group) {
		nativeInit(group);
	}
	
    public String groupId() {
    	return nativeGroupId();
    }
    
    native String nativeGroupId();
    
    public String getDescription() {
    	return nativeGroupDescription();
	}
    native String nativeGroupDescription();
    
    
    public String getOwner() {
    	return nativeGroupOwner();
    }
    native String nativeGroupOwner();
    
    
    public EMAGroupSetting groupSetting() {
    	return nativeGroupSetting();
    }
    native EMAGroupSetting nativeGroupSetting();
    
    
    public int getMemberCount() {
    	return nativeGroupMembersCount();
    }
    native int nativeGroupMembersCount();
    
    
    public boolean isPushEnabled() {
    	return nativeIsPushEnabled();
    }
    native boolean nativeIsPushEnabled();
    
    
    public boolean isMsgBlocked() {
    	return nativeIsMessageBlocked();
    }
    native boolean nativeIsMessageBlocked();
    
    public List<String> getMembers() {
        return nativeGroupMembers();
    }
    native List<String> nativeGroupMembers();
    
    public List<String> groupBlockList() {
    	return nativeGroupBlockList();
    }
    native List<String> nativeGroupBlockList();
    
    // TODO: begin
	public void setGroupName(String name) {
		nativesetGroupName(name);
	}
	native void nativesetGroupName(String name);
	
	public void setOwner(String owner) {
		nativesetOwner(owner);
	}
	native void nativesetOwner(String owner);
//	public void setLastModifiedTime(long time) {
//		nativesetLastModifiedTime(time);
//	}
//	native void nativesetLastModifiedTime(long time);
//	public void setIsPublic(boolean isPublic) {
//		nativesetIsPublic(isPublic);
//	}
//	native void nativesetIsPublic(boolean isPublic);
	public void setDescription(String desc) {
		nativesetDescription(desc);
	}
	native void nativesetDescription(String desc);
	public void setAffiliationsCount(int count) {
		nativesetAffiliationsCount(count);
	}
	native void nativesetAffiliationsCount(int count);
	public void setMsgBlocked(boolean isBlocked) {
		nativesetMsgBlocked(isBlocked);
	}
	native void nativesetMsgBlocked(boolean isBlocked);
	public void addMember(String member) {
		nativeaddMember(member);
	}
	native void nativeaddMember(String member);

	public EMAGroup() {
		nativeInit();
	}
	

	public String groupSubject() {
		return nativegroupSubject();
	}
	native String nativegroupSubject();

	public List<String> getAdminList() {
		return nativeGetAdminList();
	}
	native List<String> nativeGetAdminList();

	public List<String> getGroupBans() {
		return nativeGetGroupBans();
	}
	native List<String> nativeGetGroupBans();

	public List<String> getGroupMuteList() {
		return nativeGetGroupMuteList();
	}
	native List<String> nativeGetGroupMuteList();

	public String getAnnouncement() {
		return nativeGetAnnouncement();
	}
	native String nativeGetAnnouncement();

	public List<EMAMucShareFile> getShareFiles(){
		return nativeGetShareFiles();
	}
	native List<EMAMucShareFile> nativeGetShareFiles();
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAGroup group);
	native void nativeFinalize();

}
