/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAGroup;
import com.hyphenate.chat.adapter.EMAGroupSetting;
import com.hyphenate.chat.adapter.EMAMucShareFile;

import java.util.ArrayList;
import java.util.List;

public class EMGroup extends EMBase<EMAGroup> {

    public EMGroup(EMAGroup group) {
        emaObject = group;
    }

    /**
     * \~chinese
     * 获取群ID
     * @return 群ID
     * 
     * \~english
     * get group id
     * @return group id
     */
    public String getGroupId() {
    	return emaObject.groupId();
    }
    
    /**
     * \~chinese
     * 获取群名称
     * @return
     * 
     * \~english
     * get group name
     * @return
     */
    public String getGroupName() {
    	return emaObject.groupSubject();
    }


    /**
     * \~chinese
     * 获取群简介
     * @return
     *
     * \~english
     * get group description
     * @return
     */
    public String getDescription() {
        return emaObject.getDescription();
    }

    /**
     * \~chinese
     * 获取群组是否为公开群
     * @return
     * 
     * \~english
     * get whether the group is public 
     */
    public boolean isPublic() {

    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	switch (setting.style()) {
    	case EMAGroupSetting.EMAGroupStyle_PRIVATE_OWNER_INVITE:
    	case EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE:
    		return false;
    	default:
    		return true;
    	}
    }
    
    /**
     * \~chinese
     * 获取群组是否允许成员邀请
     * @return
     * @deprecated  使用 {@link EMGroup#isMemberAllowToInvite()} 替代
     * 
     * \~english
     * get whether the group member is allow invite the others
     * @return
     * @deprecated  use {@link EMGroup#isMemberAllowToInvite()} instead
     */
    @Deprecated
    public boolean isAllowInvites() {
        return isMemberAllowToInvite();
    }

    /**
     * \~chinese
     * 获取群组是否允许成员邀请
     * @return
     *
     * \~english
     * get whether the group member is allow invite the others
     * @return
     */
    public boolean isMemberAllowToInvite()
    {
    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	if (setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE) {
    		return true;
    	}
    	return false;
    }

    // TODO: need comments

    /**
     * \~chinese
     * 成员不能自由加入，与之对应的属性是除了EMGroupStylePublicOpenJoin之外的三种属性
     * @return
     * @deprecated  使用{@link EMGroup#isMemberOnly()}替代
     *
     * \~english
     * members can not auto join the group, need join group application approved or received invitation
     * corresponding group style is EMGroupStylePublicOpenJoin
     * @return
     * @deprecated  use {@link EMGroup#isMemberOnly()} instead
     */
    @Deprecated
    public boolean isMembersOnly() {
        return isMemberOnly();
    }

    /**
     * \~chinese
     * 成员不能自由加入，与之对应的属性是除了EMGroupStylePublicOpenJoin之外的三种属性
     * @return
     *
     * \~english
     * members can not auto join the group, need join group application approved or received invitation
     * corresponding group style is EMGroupStylePublicOpenJoin
     * @return
     */
    public boolean isMemberOnly()
    {
    	EMAGroupSetting setting = emaObject.groupSetting();
    	if (setting == null) {
    		return true;
    	}
    	if (setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_OWNER_INVITE ||
			setting.style() == EMAGroupSetting.EMAGroupStyle_PRIVATE_MEMBER_INVITE ||
			setting.style() == EMAGroupSetting.EMAGroupStyle_PUBLIC_JOIN_APPROVAL) {
    		return true;
    	}
    	return false;
    }

    /**
     * \~chinese
     * 获取群允许加入的最大成员数，在创建群时确定。
     * 需要获取群详情才能拿到正确的结果，如果没有获取则返回0
     * @return
     *
     * \~english
     * max group members capability.
     * It depends on group detail, if not fetch group detail, return 0;
     * @return
     */
    public int getMaxUserCount() {
        EMAGroupSetting setting = emaObject.groupSetting();
        if (setting == null) {
            return 0;
        }
        return setting.maxUserCount();
    }

    /**
     * \~chinese
     * 获取是否已屏蔽消息
     * @return
     * 
     * \~english
     * get whether the message is blocked
     */
    public boolean isMsgBlocked() {
        return emaObject.isMsgBlocked();
    }
     
    /**
     * \~chinese
     * 获取群创建者
     * @return
     * 
     * \~english
     * get the owner
     * @return
     */
    public String getOwner() {
        return emaObject.getOwner();
    }
      
     public String groupSubject() {
        return emaObject.groupSubject();
     }
      
     /**
      * \~chinese
      * 获取群成员列表
      * @return
      * 
      * \~english
      * get the member list
      * @return
      */
     public List<String> getMembers() {
         List<String> members = new ArrayList<String>();
         members.addAll(emaObject.getMembers());
         return members;
     }

      
    /**
      * @deprecated
      * \~chinese
      * 获取成员数量
      * @return
      * @deprecated  使用{@link EMGroup#getMemberCount()}替代
      * 
      * \~english
      * get the members size
      * @return
      * @deprecated  use {@link EMGroup#getMemberCount()} instead
      */
    @Deprecated
    public int getAffiliationsCount()
    {
        return emaObject.getMemberCount();
    }

    /**
     * \~chinese
     * 获取成员数量
     * @return
     *
     * \~english
     * get the members size
     * @return
     */
    public int getMemberCount()
    {
        return emaObject.getMemberCount();
    }

    /**
      * \~chinese
      * 返回群组名称或者群组ID，此方法可用于Adapter排序
      * @return
      * 
      * \~english
      * return group name or group id, this method can be used for adapter sorting
      * @return
      */
     public String toString() {
         String str = getGroupName();
         return str != null ? str : getGroupId();
     }

    /**
     * \~chinese
     * 获取群组管理员列表
     * @return
     *
     * \~english
     * get group administrator list
     * @return
     */
    public List<String> getAdminList() {
        return emaObject.getAdminList();
    }

    /**
     * \~chinese
     * 获取群组黑名版
     * @return
     *
     * \~english
     * get black list
     * @return
     */
    public List<String> getBlackList() {
        return emaObject.getGroupBans();
    }

    /**
     * \~chinese
     * 获取群组禁言列表
     *
     * @return
     * \~english
     * get group mute list
     */
    public List<String> getMuteList() {
        return emaObject.getGroupMuteList();
    }

    /**
     * \~chinese
     * 获取群组订制扩展信息
     *
     * \~english
     * get group customized extension
     */
    public String getExtension() {
        EMAGroupSetting setting = emaObject.groupSetting();
        if (setting == null) {
            return "";
        }
        return setting.extension();
    }

    /**
     * \~chinese
     * 获取群组公告
     * @return
     *
     * \~english
     * get group announcement
     * @return
     */
    public String getAnnouncement() {
        return emaObject.getAnnouncement();
    }

    private List<EMMucSharedFile> shareFileList;

    /**
     * \~chinese
     * 获取群组共享文件
     * @return
     *
     * \~english
     * get group shared list
     * @return
     */
    public List<EMMucSharedFile> getShareFileList(){
        if(shareFileList == null) {
            shareFileList = new ArrayList<EMMucSharedFile>();
        }else{
            shareFileList.clear();
        }
        List<EMAMucShareFile> afiles = emaObject.getShareFiles();
        for(EMAMucShareFile afile : afiles){
            shareFileList.add(new EMMucSharedFile(afile));
        }
        return shareFileList;
    }


}
