/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.util.Pair;
import com.amap.api.discover.Discover;
import com.amap.api.discover.Poi;
import com.amap.api.netlocation.AMapNetworkLocationClient;
import com.hyphenate.util.CryptoUtils;
import com.hyphenate.util.EMLog;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created by linan on 16/11/1.
 */
class EMGDLocation {


    public static final String TAG = "EMGDL";

    static EMGDLocation sInstance;
    public static synchronized EMGDLocation getInstance() {
        if (sInstance == null) {
            sInstance = new EMGDLocation();
        }
        return sInstance;
    }

    private class DiscoverResult implements Discover.AMapDiscoverListener {

        Object mLock;
        int typeCode = -1;
        String discoverUser = "";

        DiscoverResult(Object lock) {
            this.mLock = lock;
            discoverUser = EMClient.getInstance().getCurrentUser();
        }

        @Override
        public void onDiscovered(com.amap.api.discover.DiscoverResult discoverResult, int i) {
            EMLog.d(TAG, "onDiscovered, i:" + i);
            try {
                if (i != 1000 || discoverResult == null) {
                    return;
                }
                if (EMClient.getInstance().isConnected() && discoverUser.equals(EMClient.getInstance().getCurrentUser())) {
                    List<Poi> poiList = discoverResult.getPois();
                    if (poiList.size() > 0) {
                        Poi poi = poiList.get(0);
                        try {
                            Integer iObject = Integer.valueOf(poi.getTypeCode());
                            typeCode = iObject.intValue();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                synchronized (mLock) {
                    mLock.notify();
                }
            }
        }

        public int getTypeCode() {
            return typeCode;
        }
    }

    private Object lock = new Object();
    private AtomicBoolean working = new AtomicBoolean(false);

    /**
     * time consuming function, 20 seconds timeout.
     * @return
     */
    synchronized Pair<Integer, String> getLocation() {

        Pair<Integer, String> result = null;
        working.set(true);

        if (EMClient.getInstance().isConnected()) {
            Discover discover = new Discover(EMClient.getInstance().getContext());

            try {
                EMEncryptProvider provider = EMClient.getInstance().getEncryptProvider();
                String encryptDiscoverKey = EMClient.getInstance().getChatConfigPrivate().getGaoDeDiscoverKey();
                String encryptLocationKey = EMClient.getInstance().getChatConfigPrivate().getGaoDeLocationKey();

                int codeType = -1;
                String location = "";
                if (!encryptDiscoverKey.isEmpty()) {
                    byte[] bytes = provider.decrypt(CryptoUtils.fromHexString(encryptDiscoverKey), "");
                    String key = new String(bytes);
                    discover.setApiKey(key);
                    DiscoverResult discoverResult = new DiscoverResult(lock);
                    discover.setDiscoverListener(discoverResult);
                    discover.getDiscover();
                    synchronized (lock) {
                        lock.wait(20 * 1000);
                        if (working.get() == false) {
                            return null;
                        }
                    }
                    codeType = discoverResult.getTypeCode();
                }

                if (!encryptLocationKey.isEmpty()) {
                    byte[] bytes = provider.decrypt(CryptoUtils.fromHexString(encryptLocationKey), "");
                    String key = new String(bytes);
                    AMapNetworkLocationClient
                            mLocationClient = new AMapNetworkLocationClient(EMClient.getInstance().getContext());
                    mLocationClient.setApiKey(key);
                    location = mLocationClient.getNetworkLocation();
//                    EMLog.d(TAG, "network loc result:" + location);
                }
                result = new Pair<Integer, String>(codeType, location);
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                working.set(false);
            }
        }
        return result;
    }

    public void onDestroy() {
        if (lock != null && working.get() == true) {
            working.set(false);
            synchronized (lock) {
                lock.notify();
            }
        }
    }

}
