/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.analytics;

import android.content.Context;
import android.content.SharedPreferences.Editor;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;

import com.hyphenate.chat.core.EMChatConfigPrivate;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.util.DeviceUuidFactory;
import com.hyphenate.util.EMLog;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class EMActiveCollector {

	private final static String perf_actived = "actived";

	/**
	 * get the device active infomation when activity the app it will retrive OS
	 * version, device id & info user id, app version,
	 * 
	 * @return activy infomation as json string
	 */
	public static String collectActiveInfo(Context context, EMChatConfigPrivate config) {
		JSONObject activeInfo = new JSONObject();
		try {
			// os and device info
			activeInfo.put("version", Build.VERSION.RELEASE);
			activeInfo.put("manufacturer", Build.MANUFACTURER);
			activeInfo.put("model", Build.MODEL);

			try{
				// network info
				TelephonyManager telephonyManager = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
				activeInfo.put("imei", telephonyManager.getDeviceId());
				activeInfo.put("operator",telephonyManager.getNetworkOperatorName());
			}catch(Exception e){
				if(e != null){
					EMLog.d(perf_actived, e.getMessage());
				}
			}

			// app info
			activeInfo.put("hyphenate.version", config.getVersion());
			
			try{
				// try to get location info
				LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
				Location loc = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
				
				if (loc == null) {
					loc = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
				}
				
				if (loc != null) {
					activeInfo.put("loc.lat", loc.getLatitude());
					activeInfo.put("loc.lng", loc.getLongitude());
				} else {
					EMLog.d("ana", "no last location info to use");
				}
			}catch(Exception e){
				if(e != null){
					EMLog.d(perf_actived, e.getMessage());
				}
			}

			DeviceUuidFactory deviceFactory = new DeviceUuidFactory(context);
			final String fileName = deviceFactory.getDeviceUuid().toString();
			
			activeInfo.put("token", fileName);
			activeInfo.put("device_uuid", fileName);
		} catch (Exception e) {
			if(e != null){
				EMLog.d(perf_actived, e.getMessage());
			}
		}

		EMLog.d("EMActiveCollector", "device info: " + activeInfo.toString());
		return activeInfo.toString();
	}

	public static void sendActivePacket(final Context context, final EMChatConfigPrivate config) {
		boolean actived = PreferenceManager
				.getDefaultSharedPreferences(context).getBoolean(perf_actived,
						false);
		if (actived) {
			// already active
			EMLog.d("init", "s");
			return;
		}
		try {
			EMLog.d("init", "d");
			new Thread(new Runnable() {

				@SuppressWarnings("deprecation")
				@Override
				public void run() {

					String userserver = config.getBaseUrl() + "/devices";
					
					String result = null;
					try {
						final String activeInfo = collectActiveInfo(context, config);
						Map<String, String> headers = new HashMap<String, String>();
						// TODO: jni
//						Pair<Integer, String> response = EMAHttpAPI.httpExecute(sb.toString(), headers, activeInfo, EMHttpClient.POST);
						result=HttpClientManager.sendHttpRequest(userserver, headers, activeInfo, HttpClientManager.Method_POST);
						if (result.contains("uuid") || result.contains("duplicate_unique_property_exists")) {
							Editor edit = PreferenceManager
									.getDefaultSharedPreferences(context)
									.edit();
							edit.putBoolean(perf_actived, true);
							edit.apply();
						}
					} catch (Exception e) {
						if (e.toString().contains("duplicate_unique")) {
							// it is already registed in previous installation.
							// set flag
							Editor edit = PreferenceManager
									.getDefaultSharedPreferences(context)
									.edit();
							edit.putBoolean(perf_actived, true);
							edit.apply();
						}
					}
				}
			}).start();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	// inform server for app uninstallation
	public void sendUninstallPacket() {
		//
	}

}
