/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/*!
 *  \~chinese
 * 带参数返回值的回调函数
 *
 * @param <T> 参数返回类型
 *
 *  \~english
 * callback with return value
 *
 * @param <T> value     return type
 */
public interface EMValueCallBack<T> {
	/*!
     *  \~chinese
	 * 回调函数成功执行，并包含返回值
	 *
	 * @param value     T class 返回类型是T
     *
     *  \~english
	 * callback on request successfully
     *
	 * @param value     T class passed by app
	 * 
	 */
    void onSuccess(T value);

    /*!
     * \~chinese
     * 请求失败时的回调函数
     *
     * @param error     请求失败的错误代码，详情@see EMError
     * @param errorMsg  请求失败时的错误信息文字描述
     *
     * \~english
     * callback on request failed
     *
     * @param error     error of request
     * @param errorMsg  error description
     */
    void onError(final int error, final String errorMsg);
}
