/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

import com.hyphenate.chat.EMMessage;

import java.util.List;

/*!
 *  \~chinese
 * 消息侦听接口，可以用来侦听消息接受情况，成功发送到对方手机后会有回执， 对方阅读了这条消息也会收到回执。
 * 发送消息过程中，消息的ID会发生改变，由最初本地生成的一个UUID，变更为服务器端生成的全局唯一的ID，这个ID在所有使用Hyphenate SDK的
 * 设备上都是唯一的。
 * 应用需要实现此接口来监听消息变更状态。
 * 请参考: EMChatManager.addMessageListener(EMMessageListener listener)
 *
 *  \~english
 * Message event listener. Listening receive message, delivery acked, read acked.
 * If send a message, message ID will change during delivery process, first SDK local device will generate a UUID, and send to server,
 * server will create a global unique ID, and notify local device to update local database's message related stuff.
 *
 * app sholud implement this interface for monitoring any event releated to the message
 */
public interface EMMessageListener {
	/*!
     * \~chinese
	 * 接受消息接口，在接受到文本消息，图片，视频，语音，地理位置，文件这些消息体的时候，会通过此接口通知用户。
     *
     * \~english
	 * messages received, message body can be text, image, video, voice, location, file
	 */
	void onMessageReceived(List<EMMessage> messages);

	/*!
     * \~chinese
	 * 区别于{#onMessageReceived(List<EMMessage> messages)}, 这个接口只包含命令的消息体，包含命令的消息体通常不对用户展示。
	 *
     * \~english
	 * command messages received. Please refer to {#onMessageReceived(List<EMMessage> messages)}
	 */
	void onCmdMessageReceived(List<EMMessage> messages);

    /*!
     * \~chinese
     * 接受到消息体的已读回执, 消息的接收方已经阅读此消息。
     *
     * \~english
     * received message read ack by recipient as message had been read
     *
     */
	void onMessageRead(List<EMMessage> messages);

    /*!
     * \~chinese
     * 收到消息体的发送回执，消息体已经成功发送到对方设备。
     *
     * \~english
     * received message delivered ack as message delivered to recipient successfully
     */
	void onMessageDelivered(List<EMMessage> messages);

	/*!
     * \~chinese
     * 接受消息发生改变的通知，包括消息ID的改变。消息是改变后的消息。
     * @param message	发生改变的消息
     * @param change	@see EMMessageChangeEventData
     *
     * \~english
     * received message change event, including message ID change
     *
     * @param message   message value updated
     * @param change    @see EMMessageChangeEventData
     */
	void onMessageChanged(EMMessage message, Object change);
}
