/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.cloud;

import android.util.Pair;
import com.hyphenate.chat.EMClient;
import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientConfig;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpClientManager {
    private static final String TAG = "HttpClientManager";
    public static String Method_GET = "GET";
    public static String Method_POST = "POST";
    public static String Method_PUT = "PUT";
    public static String Method_DELETE = "DELETE";
    public static final int max_retries_times_on_connection_refused = 3;
    private static volatile long retrivedTokenTime = 0L;
    private static final int retriveInterval = 120000;
    private static volatile boolean isRetring = false;

    public static String sendHttpRequest(String string, Map<String, String> map, String string2, String string3) throws HyphenateException, IOException {
        String string4 = null;
        IOException iOException = null;
        HyphenateException hyphenateException = null;
        String string5 = string;
        for (int i = 0; i < 3; ++i) {
            EMLog.d(TAG, "try send request, request url: " + string5 + " with number: " + i);
            iOException = null;
            hyphenateException = null;
            try {
                string4 = HttpClientManager.sendHttpRequestWithCountDown(string5, map, string2, string3);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            catch (HyphenateException hyphenateException2) {
                hyphenateException = hyphenateException2;
            }
            if (string4 != null) break;
            string5 = HttpClientManager.getNewHost(string, EMHttpClient.getInstance().chatConfig().m());
        }
        if (iOException != null) {
            throw iOException;
        }
        if (hyphenateException != null) {
            throw hyphenateException;
        }
        return string4;
    }

    public static Pair<Integer, String> sendRequestWithToken(String string, String string2, String string3) throws HyphenateException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Authorization", "Bearer " + EMClient.getInstance().getOptions().getAccessToken());
        try {
            return HttpClientManager.sendHttpRequestWithRetryToken(string, hashMap, string2, string3);
        }
        catch (IOException iOException) {
            String string4 = " send request : " + string + " failed!";
            if (iOException != null && iOException.toString() != null) {
                string4 = iOException.toString();
            }
            EMLog.d(TAG, string4);
            throw new HyphenateException(1, string4);
        }
    }

    static Pair<Integer, String> sendHttpRequestWithRetryToken(String string, Map<String, String> map, String string2, String string3) throws HyphenateException, IOException {
        Pair<Integer, String> pair = HttpClientManager.sendRequest(string, map, string2, string3);
        if (pair != null && (Integer)pair.first == 401) {
            String string4 = null;
            long l = System.currentTimeMillis();
            if (l - retrivedTokenTime > 120000L && !isRetring) {
                isRetring = true;
                string4 = EMClient.getInstance().getOptions().getAccessToken(true);
                isRetring = false;
                retrivedTokenTime = System.currentTimeMillis();
                if (string4 != null) {
                    map.put("Authorization", "Bearer " + string4);
                    pair = HttpClientManager.sendRequest(string, map, string2, string3);
                }
            }
        }
        return pair;
    }

    public static Pair<Integer, String> sendRequest(String string, Map<String, String> map, String string2, String string3) throws IOException, HyphenateException {
        Pair pair = null;
        IOException iOException = null;
        HyphenateException hyphenateException = null;
        String string4 = string;
        for (int i = 0; i < 3; ++i) {
            Object object;
            EMLog.d(TAG, "try send request, request url: " + string4 + " with number: " + i);
            iOException = null;
            hyphenateException = null;
            Exception exception = null;
            try {
                object = HttpClientManager.sendRequestWithCountDown(string4, map, string2, string3);
                HttpEntity httpEntity = object.getEntity();
                if (null != httpEntity) {
                    String string5 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                    pair = new Pair((Object)object.getStatusLine().getStatusCode(), (Object)string5);
                }
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                exception = iOException2;
            }
            catch (HyphenateException hyphenateException2) {
                hyphenateException = hyphenateException2;
                exception = hyphenateException2;
            }
            object = "failed to send request, request url: " + string;
            if (exception != null) {
                if (exception.getMessage() != null) {
                    object = exception.getMessage();
                } else if (exception.toString() != null) {
                    object = exception.toString();
                }
            }
            if (!((String)object).toLowerCase().contains("refused") || !NetUtils.hasNetwork(EMClient.getInstance().getContext())) break;
            string4 = HttpClientManager.getNewHost(string, EMHttpClient.getInstance().chatConfig().m());
        }
        if (iOException != null) {
            throw iOException;
        }
        if (hyphenateException != null) {
            throw hyphenateException;
        }
        return pair;
    }

    private static HttpResponse sendRequestWithCountDown(String string, Map<String, String> map, String string2, String string3) throws HyphenateException, IOException {
        HttpResponse httpResponse = null;
        try {
            httpResponse = HttpClientManager.getHttpResponse(string, map, string2, string3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
            }
            String string4 = "http request failed : " + string;
            if (exception != null && exception.toString() != null) {
                string4 = exception.toString();
            }
            if (string4.contains("Unable to resolve host")) {
                throw new HyphenateException(2, "Unable to resolve host");
            }
            throw new HyphenateException(300, string4);
        }
        return httpResponse;
    }

    private static String sendHttpRequestWithCountDown(String string, Map<String, String> map, String string2, String string3) throws HyphenateException, IOException {
        String string4 = null;
        try {
            HttpResponse httpResponse = HttpClientManager.getHttpResponse(string, map, string2, string3);
            HttpEntity httpEntity = httpResponse.getEntity();
            if (null != httpEntity) {
                string4 = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            if (exception != null) {
                exception.printStackTrace();
            }
            String string5 = "http request failed : " + string;
            if (exception != null && exception.toString() != null) {
                string5 = exception.toString();
            }
            if (string5.contains("Unable to resolve host")) {
                throw new HyphenateException(2, "Unable to resolve host");
            }
            throw new HyphenateException(300, string5);
        }
        return string4;
    }

    static String getNewHost(String string, String string2) {
        String string3 = string.substring(string.indexOf("/", 8));
        string3 = string3.substring(string3.indexOf("/", 1));
        string3 = string3.substring(string3.indexOf("/", 1));
        return string2 + string3;
    }

    static Map<String, String> addDomainToHeaders(Map<String, String> map) {
        return map;
    }

    static void checkAndProcessSSL(String string, DefaultHttpClient defaultHttpClient) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
    }

    public static HttpResponse getHttpResponse(String string, Map<String, String> map, String string2, String string3) throws KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        map = HttpClientManager.addDomainToHeaders(map);
        return HttpClientManager.httpExecute(string, map, string2, string3);
    }

    public static HttpResponse httpExecute(String string, Map<String, String> map, String string2, String string3) throws ClientProtocolException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException {
        Object object;
        HttpResponse httpResponse = null;
        int n = HttpClientConfig.getTimeout(map);
        DefaultHttpClient defaultHttpClient = HttpClientConfig.getDefaultHttpClient(n);
        HttpGet httpGet = null;
        if (string3.equals(Method_POST)) {
            object = new HttpPost(string);
            object.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = object;
        } else if (string3.equals(Method_PUT)) {
            object = new HttpPut(string);
            object.setEntity((HttpEntity)new StringEntity(string2, "UTF-8"));
            httpGet = object;
        } else if (string3.equals(Method_GET)) {
            httpGet = new HttpGet(string);
        } else if (string3.equals(Method_DELETE)) {
            httpGet = new HttpDelete(string);
        }
        if (httpGet != null) {
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    httpGet.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        }
        return httpResponse;
    }
}

