/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import com.hyphenate.EMCallBack;
import com.hyphenate.EMGroupChangeListener;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMGroup;
import com.hyphenate.chat.EMGroupInfo;
import com.hyphenate.chat.adapter.EMAError;
import com.hyphenate.chat.adapter.EMAGroup;
import com.hyphenate.chat.adapter.EMAGroupManager;
import com.hyphenate.chat.adapter.EMAGroupManagerListener;
import com.hyphenate.chat.adapter.EMAGroupSetting;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EMGroupManager {
    EMAGroupManager emaObject;
    private static String TAG = "group";
    List<EMGroupChangeListener> groupChangeListeners;
    EMAGroupManagerListener listenerImpl = new EMAGroupManagerListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteFromGroup(String string, String string2, String string3) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationReceived(string, "", string2, string3);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteAcceptionFromGroup(EMAGroup eMAGroup, String string) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationAccepted(eMAGroup.groupId(), string, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveInviteDeclineFromGroup(EMAGroup eMAGroup, String string, String string2) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onInvitationDeclined(eMAGroup.groupId(), string, "");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAutoAcceptInvitationFromGroup(EMAGroup eMAGroup, String string, String string2) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAutoAcceptInvitationFromGroup(eMAGroup.groupId(), string, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLeaveGroup(EMAGroup eMAGroup, int n) {
            EMClient.getInstance().chatManager().caches.remove(eMAGroup.groupId());
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        if (n == EMAGroup.EMGroupLeaveReason.BE_KICKED.ordinal()) {
                            eMGroupChangeListener.onUserRemoved(eMAGroup.groupId(), eMAGroup.groupSubject());
                            continue;
                        }
                        eMGroupChangeListener.onGroupDestroyed(eMAGroup.groupId(), eMAGroup.groupSubject());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveJoinGroupApplication(EMAGroup eMAGroup, String string, String string2) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinReceived(eMAGroup.groupId(), eMAGroup.groupSubject(), string, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveAcceptionFromGroup(EMAGroup eMAGroup) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinAccepted(eMAGroup.groupId(), eMAGroup.groupSubject(), eMAGroup.getOwner());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceiveRejectionFromGroup(String string, String string2) {
            EMGroup eMGroup = EMGroupManager.this.getGroup(string);
            String string3 = eMGroup == null ? "" : eMGroup.groupSubject();
            String string4 = eMGroup == null ? "" : eMGroup.getOwner();
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onRequestToJoinDeclined(string, string3, string4, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        @Override
        public void onUpdateMyGroupList(List<EMAGroup> list) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddMutesFromGroup(EMAGroup eMAGroup, List<String> list, long l) {
            List<EMGroupChangeListener> list2 = EMGroupManager.this.groupChangeListeners;
            synchronized (list2) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMuteListAdded(eMAGroup.groupId(), list, l);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveMutesFromGroup(EMAGroup eMAGroup, List<String> list) {
            List<EMGroupChangeListener> list2 = EMGroupManager.this.groupChangeListeners;
            synchronized (list2) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMuteListRemoved(eMAGroup.groupId(), list);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAddAdminFromGroup(EMAGroup eMAGroup, String string) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAdminAdded(eMAGroup.groupId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveAdminFromGroup(EMAGroup eMAGroup, String string) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onAdminRemoved(eMAGroup.groupId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAssignOwnerFromGroup(EMAGroup eMAGroup, String string, String string2) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onOwnerChanged(eMAGroup.groupId(), string, string2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberJoined(EMAGroup eMAGroup, String string) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMemberJoined(eMAGroup.groupId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMemberExited(EMAGroup eMAGroup, String string) {
            List<EMGroupChangeListener> list = EMGroupManager.this.groupChangeListeners;
            synchronized (list) {
                try {
                    for (EMGroupChangeListener eMGroupChangeListener : EMGroupManager.this.groupChangeListeners) {
                        eMGroupChangeListener.onMemberExited(eMAGroup.groupId(), string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    };
    EMClient mClient;

    EMGroupManager(EMClient eMClient, EMAGroupManager eMAGroupManager) {
        this.emaObject = eMAGroupManager;
        this.mClient = eMClient;
        this.groupChangeListeners = Collections.synchronizedList(new ArrayList());
        this.emaObject.addListener(this.listenerImpl);
    }

    public List<EMGroup> getAllGroups() {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new EMGroup(eMAGroup));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public EMGroup getGroup(String string) {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.allMyGroups(eMAError);
        for (EMAGroup eMAGroup : list) {
            if (!eMAGroup.groupId().equals(string)) continue;
            return new EMGroup(eMAGroup);
        }
        return null;
    }

    public EMGroup createGroup(String string, String string2, String[] stringArray, String string3, EMGroupOptions eMGroupOptions) throws HyphenateException {
        int n = 0;
        switch (eMGroupOptions.style) {
            case EMGroupStylePrivateOnlyOwnerInvite: {
                n = 0;
                break;
            }
            case EMGroupStylePrivateMemberCanInvite: {
                n = 1;
                break;
            }
            case EMGroupStylePublicJoinNeedApproval: {
                n = 2;
                break;
            }
            case EMGroupStylePublicOpenJoin: {
                n = 3;
            }
        }
        return this.createGroup(n, string, string2, stringArray, eMGroupOptions.maxUsers, string3, eMGroupOptions.inviteNeedConfirm, eMGroupOptions.extField);
    }

    public void asyncCreateGroup(final String string, final String string2, final String[] stringArray, final String string3, final EMGroupOptions eMGroupOptions, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.createGroup(string, string2, stringArray, string3, eMGroupOptions);
                    eMValueCallBack.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public synchronized void loadAllGroups() {
        this.emaObject.loadAllMyGroupsFromDB();
    }

    public void destroyGroup(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.destroyGroup(string, eMAError);
        EMClient.getInstance().chatManager().caches.remove(string);
        this.handleError(eMAError);
    }

    public void asyncDestroyGroup(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.destroyGroup(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addUsersToGroup(String string, String[] stringArray) throws HyphenateException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        this.emaObject.addGroupMembers(string, arrayList, "welcome", eMAError);
        this.handleError(eMAError);
    }

    public void asyncAddUsersToGroup(final String string, final String[] stringArray, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.addUsersToGroup(string, stringArray);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void removeUserFromGroup(String string, String string2) throws HyphenateException {
        ArrayList<String> arrayList = new ArrayList<String>();
        EMAError eMAError = new EMAError();
        arrayList.add(string2);
        this.emaObject.removeGroupMembers(string, arrayList, eMAError);
        this.handleError(eMAError);
        this.emaObject.fetchGroupSpecification(string, eMAError, true);
        this.handleError(eMAError);
    }

    public void asyncRemoveUserFromGroup(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.removeUserFromGroup(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void leaveGroup(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.leaveGroup(string, eMAError);
        EMClient.getInstance().chatManager().caches.remove(string);
        this.handleError(eMAError);
    }

    public void asyncLeaveGroup(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.leaveGroup(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup getGroupFromServer(String string) throws HyphenateException {
        if (string == null || string.isEmpty()) {
            throw new HyphenateException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(string, eMAError, false);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public EMGroup getGroupFromServer(String string, boolean bl) throws HyphenateException {
        if (string == null || string.isEmpty()) {
            throw new HyphenateException(600, "group id is null or empty");
        }
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(string, eMAError, bl);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncGetGroupFromServer(final String string, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.getGroupFromServer(string);
                    eMValueCallBack.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    synchronized List<EMGroup> getGroupsFromServer() throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<EMAGroup> list = this.emaObject.fetchAllMyGroups(eMAError);
        this.handleError(eMAError);
        ArrayList<EMGroup> arrayList = new ArrayList<EMGroup>();
        for (EMAGroup eMAGroup : list) {
            arrayList.add(new EMGroup(eMAGroup));
        }
        return arrayList;
    }

    void asyncGetGroupsFromServer(final EMValueCallBack<List<EMGroup>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getGroupsFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public synchronized List<EMGroup> getJoinedGroupsFromServer() throws HyphenateException {
        return this.getGroupsFromServer();
    }

    public void asyncGetJoinedGroupsFromServer(final EMValueCallBack<List<EMGroup>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<EMGroup> list = EMGroupManager.this.getJoinedGroupsFromServer();
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMCursorResult<EMGroupInfo> getPublicGroupsFromServer(int n, String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<EMGroupInfo> eMCursorResult = this.emaObject.fetchPublicGroupsWithCursor(string, n, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncGetPublicGroupsFromServer(final int n, final String string, final EMValueCallBack<EMCursorResult<EMGroupInfo>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<EMGroupInfo> eMCursorResult = EMGroupManager.this.getPublicGroupsFromServer(n, string);
                    eMValueCallBack.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void joinGroup(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.fetchGroupSpecification(string, eMAError, false);
        this.handleError(eMAError);
        if (eMAGroup.groupSetting() == null) {
            throw new HyphenateException();
        }
        if (eMAGroup.groupSetting().style() == 3) {
            this.emaObject.joinPublicGroup(string, eMAError);
            this.handleError(eMAError);
            return;
        }
        if (eMAGroup.groupSetting().style() == 2) {
            this.emaObject.applyJoinPublicGroup(string, this.mClient.getCurrentUser(), "hello", eMAError);
            this.handleError(eMAError);
            return;
        }
    }

    public void asyncJoinGroup(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.joinGroup(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void changeGroupName(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupSubject(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupName(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.changeGroupName(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void changeGroupDescription(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.changeGroupDescription(string, string2, eMAError);
        this.handleError(eMAError);
    }

    public void asyncChangeGroupDescription(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.changeGroupDescription(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup acceptInvitation(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.acceptInvitationFromGroup(string, string2 == null ? "" : string2, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncAcceptInvitation(final String string, final String string2, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.acceptInvitation(string, string2);
                    eMValueCallBack.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineInvitation(String string, String string2, String string3) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineInvitationFromGroup(string, string2 == null ? "" : string2, string3 == null ? "" : string3, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineInvitation(final String string, final String string2, final String string3, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.declineInvitation(string, string2, string3);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void acceptApplication(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.acceptJoinGroupApplication(string2, string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncAcceptApplication(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.acceptApplication(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void declineApplication(String string, String string2, String string3) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.declineJoinGroupApplication(string2, string, string3, eMAError);
        this.handleError(eMAError);
    }

    public void asyncDeclineApplication(final String string, final String string2, final String string3, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.declineApplication(string, string2, string3);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void inviteUser(String string, String[] stringArray, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        this.emaObject.addGroupMembers(string, arrayList, string2, eMAError);
        this.handleError(eMAError);
    }

    public void asyncInviteUser(final String string, final String[] stringArray, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.inviteUser(string, stringArray, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void applyJoinToGroup(String string, String string2) throws HyphenateException {
        String string3 = this.mClient.getCurrentUser();
        EMAError eMAError = new EMAError();
        this.emaObject.applyJoinPublicGroup(string, string3, string2, eMAError);
        this.handleError(eMAError);
    }

    public void asyncApplyJoinToGroup(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.applyJoinToGroup(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void blockGroupMessage(String string) throws HyphenateException {
        EMAError eMAError = new EMAError();
        this.emaObject.blockGroupMessage(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncBlockGroupMessage(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.blockGroupMessage(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unblockGroupMessage(String string) throws HyphenateException {
        EMLog.d(TAG, "try to unblock group msg:" + string);
        EMAError eMAError = new EMAError();
        this.emaObject.unblockGroupMessage(string, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockGroupMessage(final String string, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.unblockGroupMessage(string);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void blockUser(String string, String string2) throws HyphenateException {
        EMLog.d(TAG, "block user for groupid:" + string + " username:" + string2);
        EMAError eMAError = new EMAError();
        String string3 = "";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.emaObject.blockGroupMembers(string, arrayList, eMAError, string3);
        this.handleError(eMAError);
    }

    public void asyncBlockUser(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.blockUser(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void unblockUser(String string, String string2) throws HyphenateException {
        EMLog.d(TAG, "unblock user groupid:" + string + " username:" + string2);
        EMAError eMAError = new EMAError();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        this.emaObject.unblockGroupMembers(string, arrayList, eMAError);
        this.handleError(eMAError);
    }

    public void asyncUnblockUser(final String string, final String string2, final EMCallBack eMCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroupManager.this.unblockUser(string, string2);
                    eMCallBack.onSuccess();
                }
                catch (HyphenateException hyphenateException) {
                    eMCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> getBlockedUsers(String string) throws HyphenateException {
        return this.getBlockedUsers(string, 0, 200);
    }

    public List<String> getBlockedUsers(String string, int n, int n2) throws HyphenateException {
        EMLog.d(TAG, "get blocked users for group:" + string);
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(string, n, n2, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncGetBlockedUsers(String string, EMValueCallBack<List<String>> eMValueCallBack) {
        this.asyncGetBlockedUsers(string, 0, 200, eMValueCallBack);
    }

    public void asyncGetBlockedUsers(final String string, final int n, final int n2, final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List<String> list = EMGroupManager.this.getBlockedUsers(string, n, n2);
                    eMValueCallBack.onSuccess(list);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public void addGroupChangeListener(EMGroupChangeListener eMGroupChangeListener) {
        EMLog.d(TAG, "add group change listener:" + eMGroupChangeListener.getClass().getName());
        if (!this.groupChangeListeners.contains(eMGroupChangeListener)) {
            this.groupChangeListeners.add(eMGroupChangeListener);
        }
    }

    public void removeGroupChangeListener(EMGroupChangeListener eMGroupChangeListener) {
        EMLog.d(TAG, "remove group change listener:" + eMGroupChangeListener.getClass().getName());
        this.groupChangeListeners.remove(eMGroupChangeListener);
    }

    private EMGroup createGroup(int n, String string, String string2, String[] stringArray, int n2, String string3, boolean bl, String string4) throws HyphenateException {
        EMAGroupSetting eMAGroupSetting = new EMAGroupSetting(n, n2, bl, string4);
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, stringArray);
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.createGroup(string, string2, string3, eMAGroupSetting, arrayList, bl, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public EMCursorResult<String> fetchGroupMembers(String string, String string2, int n) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMCursorResult<String> eMCursorResult = this.emaObject.fetchGroupMembers(string, string2, n, eMAError);
        this.handleError(eMAError);
        return eMCursorResult;
    }

    public void asyncFetchGroupMembers(final String string, final String string2, final int n, final EMValueCallBack<EMCursorResult<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMCursorResult<String> eMCursorResult = EMGroupManager.this.fetchGroupMembers(string, string2, n);
                    eMValueCallBack.onSuccess(eMCursorResult);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup changeOwner(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.transferGroupOwner(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncChangeOwner(final String string, final String string2, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    EMGroup eMGroup = EMGroupManager.this.changeOwner(string, string2);
                    eMValueCallBack.onSuccess(eMGroup);
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup addGroupAdmin(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.addGroupAdmin(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncAddGroupAdmin(final String string, final String string2, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.addGroupAdmin(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup removeGroupAdmin(String string, String string2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.removeGroupAdmin(string, string2, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncRemoveGroupAdmin(final String string, final String string2, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.removeGroupAdmin(string, string2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup muteGroupMembers(String string, List<String> list, long l) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.muteGroupMembers(string, list, l, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void aysncMuteGroupMembers(final String string, final List<String> list, final long l, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.muteGroupMembers(string, list, l));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public EMGroup unMuteGroupMembers(String string, List<String> list) throws HyphenateException {
        EMAError eMAError = new EMAError();
        EMAGroup eMAGroup = this.emaObject.unMuteGroupMembers(string, list, eMAError);
        this.handleError(eMAError);
        return new EMGroup(eMAGroup);
    }

    public void asyncUnMuteGroupMembers(final String string, final List<String> list, final EMValueCallBack<EMGroup> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.unMuteGroupMembers(string, list));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public Map<String, Long> fetchGroupMuteList(String string, int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        Map<String, Long> map = this.emaObject.fetchGroupMutes(string, n, n2, eMAError);
        this.handleError(eMAError);
        return map;
    }

    public void asyncFetchGroupMuteList(final String string, final int n, final int n2, final EMValueCallBack<Map<String, Long>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.fetchGroupMuteList(string, n, n2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    public List<String> fetchGroupBlackList(String string, int n, int n2) throws HyphenateException {
        EMAError eMAError = new EMAError();
        List<String> list = this.emaObject.fetchGroupBlackList(string, n, n2, eMAError);
        this.handleError(eMAError);
        return list;
    }

    public void asyncFetchGroupBlackList(final String string, final int n, final int n2, final EMValueCallBack<List<String>> eMValueCallBack) {
        EMClient.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    eMValueCallBack.onSuccess(EMGroupManager.this.fetchGroupBlackList(string, n, n2));
                }
                catch (HyphenateException hyphenateException) {
                    eMValueCallBack.onError(hyphenateException.getErrorCode(), hyphenateException.getDescription());
                }
            }
        });
    }

    void onLogout() {
    }

    private void handleError(EMAError eMAError) throws HyphenateException {
        if (eMAError.errCode() != 0) {
            throw new HyphenateException(eMAError);
        }
    }

    public static class EMGroupOptions {
        public int maxUsers = 200;
        public EMGroupStyle style = EMGroupStyle.EMGroupStylePrivateOnlyOwnerInvite;
        public boolean inviteNeedConfirm = false;
        public String extField;
    }

    public static enum EMGroupStyle {
        EMGroupStylePrivateOnlyOwnerInvite,
        EMGroupStylePrivateMemberCanInvite,
        EMGroupStylePublicJoinNeedApproval,
        EMGroupStylePublicOpenJoin;

    }
}

